/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.StorageFileInputStream;
import com.azure.storage.file.share.StorageFileOutputStream;
import com.azure.storage.file.share.StorageSeekableByteChannelShareFileReadBehavior;
import com.azure.storage.file.share.StorageSeekableByteChannelShareFileWriteBehavior;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.FilesCreateHeaders;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetRangeListHeaders;
import com.azure.storage.file.share.implementation.models.FilesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesSetHttpHeadersHeaders;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.FilesStartCopyHeaders;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLHeaders;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeHeaders;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.CopyableFileSmbPropertiesList;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.Range;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileCopyInfo;
import com.azure.storage.file.share.models.ShareFileDownloadAsyncResponse;
import com.azure.storage.file.share.models.ShareFileDownloadResponse;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadOptions;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeOptions;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileCopyOptions;
import com.azure.storage.file.share.options.ShareFileCreateOptions;
import com.azure.storage.file.share.options.ShareFileDownloadOptions;
import com.azure.storage.file.share.options.ShareFileListRangesDiffOptions;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareFileSeekableByteChannelReadOptions;
import com.azure.storage.file.share.options.ShareFileSeekableByteChannelWriteOptions;
import com.azure.storage.file.share.options.ShareFileSetPropertiesOptions;
import com.azure.storage.file.share.options.ShareFileUploadRangeFromUrlOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareFileClientBuilder.class)
public class ShareFileClient {
    private final ShareFileAsyncClient shareFileAsyncClient;
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String filePath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final String fileUrlString;

    ShareFileClient(ShareFileAsyncClient shareFileAsyncClient, AzureFileStorageImpl azureFileStorageClient, String shareName, String filePath, String snapshot, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        this.shareFileAsyncClient = shareFileAsyncClient;
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(filePath, "'filePath' cannot be null.");
        this.shareName = shareName;
        this.filePath = filePath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
        StringBuilder fileUrlstring = new StringBuilder(azureFileStorageClient.getUrl()).append("/").append(shareName).append("/").append(filePath);
        if (snapshot != null) {
            fileUrlstring.append("?sharesnapshot=").append(snapshot);
        }
        this.fileUrlString = fileUrlstring.toString();
    }

    public String getAccountUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public String getFileUrl() {
        return this.fileUrlString;
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public final StorageFileInputStream openInputStream() {
        return this.openInputStream(new ShareFileRange(0L));
    }

    public final StorageFileInputStream openInputStream(ShareFileRange range) {
        return new StorageFileInputStream(this.shareFileAsyncClient, range.getStart(), range.getEnd() == null ? null : Long.valueOf(range.getEnd() - range.getStart() + 1L));
    }

    public final StorageFileOutputStream getFileOutputStream() {
        return this.getFileOutputStream(0L);
    }

    public final StorageFileOutputStream getFileOutputStream(long offset) {
        return new StorageFileOutputStream(this.shareFileAsyncClient, offset);
    }

    public SeekableByteChannel getFileSeekableByteChannelWrite(ShareFileSeekableByteChannelWriteOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (options.isOverwriteMode()) {
            Objects.requireNonNull(options.getFileSizeInBytes(), "'options.getFileSize()' cannot return null.");
            this.create(options.getFileSizeInBytes());
        }
        int chunkSize = options.getChunkSizeInBytes() != null ? options.getChunkSizeInBytes().intValue() : 0x400000;
        return new StorageSeekableByteChannel(chunkSize, (StorageSeekableByteChannel.WriteBehavior)new StorageSeekableByteChannelShareFileWriteBehavior(this, options.getRequestConditions(), options.getFileLastWrittenMode()), 0L);
    }

    public SeekableByteChannel getFileSeekableByteChannelRead(ShareFileSeekableByteChannelReadOptions options) {
        ShareRequestConditions conditions = options != null ? options.getRequestConditions() : null;
        Long configuredChunkSize = options != null ? options.getChunkSizeInBytes() : null;
        int chunkSize = configuredChunkSize != null ? configuredChunkSize.intValue() : 0x400000;
        return new StorageSeekableByteChannel(chunkSize, (StorageSeekableByteChannel.ReadBehavior)new StorageSeekableByteChannelShareFileReadBehavior(this, conditions), 0L);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        try {
            Response<ShareFileProperties> response = this.getPropertiesWithResponse(timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (RuntimeException e) {
            if (ModelHelper.checkDoesNotExistStatusCode(e) && e instanceof HttpResponseException) {
                HttpResponse response = ((HttpResponseException)e).getResponse();
                return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileInfo create(long maxSize) {
        return (ShareFileInfo)this.createWithResponse(maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        ModelHelper.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        String finalFilePermission = smbProperties.setFilePermission(filePermission, "Inherit");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("None");
        String fileCreationTime = smbProperties.setFileCreationTime("Now");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Now");
        String fileChangeTime = smbProperties.getFileChangeTimeString();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().createWithResponse(this.shareName, this.filePath, maxSize, fileAttributes, null, metadata, finalFilePermission, null, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, finalRequestConditions.getLeaseId(), httpHeaders, finalContext);
        return ModelHelper.createFileInfoResponse((ResponseBase<FilesCreateHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(ShareFileCreateOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions requestConditions = options.getRequestConditions();
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        FileSmbProperties smbProperties = options.getSmbProperties();
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        ModelHelper.validateFilePermissionAndKey(options.getFilePermission(), smbProperties.getFilePermissionKey());
        String finalFilePermission = smbProperties.setFilePermission(options.getFilePermission(), "Inherit");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("None");
        String fileCreationTime = smbProperties.setFileCreationTime("Now");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Now");
        String fileChangeTime = smbProperties.getFileChangeTimeString();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().createWithResponse(this.shareName, this.filePath, options.getSize(), fileAttributes, null, options.getMetadata(), finalFilePermission, options.getFilePermissionFormat(), filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, finalRequestConditions.getLeaseId(), options.getShareFileHttpHeaders(), finalContext);
        return ModelHelper.createFileInfoResponse((ResponseBase<FilesCreateHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, Duration pollInterval) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setMetadata(metadata);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, FileSmbProperties smbProperties, String filePermission, PermissionCopyModeType filePermissionCopyMode, Boolean ignoreReadOnly, Boolean setArchiveAttribute, Map<String, String> metadata, Duration pollInterval, ShareRequestConditions destinationRequestConditions) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setSmbProperties(smbProperties).setFilePermission(filePermission).setPermissionCopyModeType(filePermissionCopyMode).setIgnoreReadOnly(ignoreReadOnly).setArchiveAttribute(setArchiveAttribute).setMetadata(metadata).setDestinationRequestConditions(destinationRequestConditions);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, ShareFileCopyOptions options, Duration pollInterval) {
        ShareRequestConditions finalRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        AtomicReference copyId = new AtomicReference();
        Duration interval = pollInterval == null ? Duration.ofSeconds(1L) : pollInterval;
        FileSmbProperties tempSmbProperties = options.getSmbProperties() == null ? new FileSmbProperties() : options.getSmbProperties();
        String filePermissionKey = tempSmbProperties.getFilePermissionKey();
        if (options.getFilePermission() == null || options.getPermissionCopyModeType() == PermissionCopyModeType.SOURCE) {
            if ((options.getFilePermission() != null || filePermissionKey != null) && options.getPermissionCopyModeType() != PermissionCopyModeType.OVERRIDE) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key can not be set when PermissionCopyModeType is source or null"));
            }
        } else if (options.getPermissionCopyModeType() == PermissionCopyModeType.OVERRIDE) {
            try {
                ModelHelper.validateFilePermissionAndKey(options.getFilePermission(), tempSmbProperties.getFilePermissionKey());
            }
            catch (RuntimeException ex) {
                throw LOGGER.logExceptionAsError(ex);
            }
        }
        CopyableFileSmbPropertiesList list = options.getSmbPropertiesToCopy() == null ? new CopyableFileSmbPropertiesList() : options.getSmbPropertiesToCopy();
        try {
            ModelHelper.validateCopyFlagAndSmbProperties(options, tempSmbProperties);
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
        String fileAttributes = list.isFileAttributes() != false ? "Source" : NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
        String fileCreationTime = list.isCreatedOn() != false ? "Source" : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
        String fileLastWriteTime = list.isLastWrittenOn() != false ? "Source" : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
        String fileChangedOnTime = list.isChangedOn() != false ? "Source" : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
        CopyFileSmbInfo copyFileSmbInfo = new CopyFileSmbInfo().setFilePermissionCopyMode(options.getPermissionCopyModeType()).setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangedOnTime).setIgnoreReadOnly(options.isIgnoreReadOnly()).setSetArchiveAttribute(options.isArchiveAttributeSet());
        String copySource = Utility.encodeUrlPath((String)sourceUrl);
        Function<PollingContext, PollResponse> syncActivationOperation = pollingContext -> {
            ResponseBase<FilesStartCopyHeaders, Void> response = this.azureFileStorageClient.getFiles().startCopyWithResponse(this.shareName, this.filePath, copySource, null, options.getMetadata(), options.getFilePermission(), options.getFilePermissionFormat(), tempSmbProperties.getFilePermissionKey(), finalRequestConditions.getLeaseId(), copyFileSmbInfo, null);
            FilesStartCopyHeaders headers = (FilesStartCopyHeaders)response.getDeserializedHeaders();
            copyId.set(headers.getXMsCopyId());
            return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new ShareFileCopyInfo(sourceUrl, headers.getXMsCopyId(), headers.getXMsCopyStatus(), headers.getETag(), headers.getLastModified(), response.getHeaders().getValue(Constants.HeaderConstants.ERROR_CODE_HEADER_NAME)));
        };
        Function<PollingContext, PollResponse> pollOperation = pollingContext -> this.onPoll((PollResponse<ShareFileCopyInfo>)pollingContext.getLatestResponse(), finalRequestConditions);
        BiFunction<PollingContext, PollResponse, ShareFileCopyInfo> cancelOperation = (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started."));
            }
            String copyIdentifier = ((ShareFileCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)copyIdentifier)) {
                LOGGER.info("Cancelling copy operation for copy id: {}", new Object[]{copyIdentifier});
                this.abortCopyWithResponse(copyIdentifier, finalRequestConditions, null, null);
                return (ShareFileCopyInfo)firstResponse.getValue();
            }
            return null;
        };
        Function<PollingContext, Void> fetchResultOperation = pollingContext -> null;
        return SyncPoller.createPoller((Duration)interval, syncActivationOperation, pollOperation, cancelOperation, fetchResultOperation);
    }

    private PollResponse<ShareFileCopyInfo> onPoll(PollResponse<ShareFileCopyInfo> pollResponse, ShareRequestConditions requestConditions) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return pollResponse;
        }
        ShareFileCopyInfo lastInfo = (ShareFileCopyInfo)pollResponse.getValue();
        if (lastInfo == null) {
            LOGGER.warning("ShareFileCopyInfo does not exist. Activation operation failed.");
            return new PollResponse(LongRunningOperationStatus.fromString((String)"COPY_START_FAILED", (boolean)true), null);
        }
        try {
            Response<ShareFileProperties> response = this.getPropertiesWithResponse(requestConditions, null, null);
            ShareFileProperties value = (ShareFileProperties)response.getValue();
            CopyStatusType status = value.getCopyStatus();
            ShareFileCopyInfo result = new ShareFileCopyInfo(value.getCopySource(), value.getCopyId(), status, value.getETag(), value.getCopyCompletionTime(), value.getCopyStatusDescription());
            LongRunningOperationStatus operationStatus = ModelHelper.mapStatusToLongRunningOperationStatus(status);
            return new PollResponse(operationStatus, (Object)result);
        }
        catch (RuntimeException e) {
            return new PollResponse(LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true), (Object)lastInfo);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortCopy(String copyId) {
        this.abortCopyWithResponse(copyId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyWithResponse(String copyId, Duration timeout, Context context) {
        return this.abortCopyWithResponse(copyId, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<Response> operation = () -> this.azureFileStorageClient.getFiles().abortCopyNoCustomHeadersWithResponse(this.shareName, this.filePath, copyId, null, finalRequestConditions.getLeaseId(), finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileProperties downloadToFile(String downloadFilePath) {
        return (ShareFileProperties)this.downloadToFileWithResponse(downloadFilePath, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(downloadFilePath, range, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileProperties>> response = this.shareFileAsyncClient.downloadToFileWithResponse(downloadFilePath, range, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void download(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, Context.NONE);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, range, rangeGetContentMD5, null, timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, new ShareFileDownloadOptions().setRange(range).setRangeContentMd5Requested(rangeGetContentMD5).setRequestConditions(requestConditions), timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileDownloadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(stream, "'stream' cannot be null.");
        Mono download = this.shareFileAsyncClient.downloadWithResponse(options, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)((Flux)response.getValue()), (OutputStream)stream).thenReturn((Object)new ShareFileDownloadResponse((ShareFileDownloadAsyncResponse)((Object)response))));
        return (ShareFileDownloadResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return this.deleteWithResponse(null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<Response> operation = () -> this.azureFileStorageClient.getFiles().deleteNoCustomHeadersWithResponse(this.shareName, this.filePath, null, finalRequestConditions.getLeaseId(), finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(requestConditions, timeout, context);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals((Object)ShareErrorCode.RESOURCE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileProperties getProperties() {
        return (ShareFileProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return this.getPropertiesWithResponse(null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> getPropertiesWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().getPropertiesWithResponse(this.shareName, this.filePath, this.snapshot, null, finalRequestConditions.getLeaseId(), finalContext);
        return ModelHelper.getPropertiesResponse((ResponseBase<FilesGetPropertiesHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileInfo setProperties(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return (ShareFileInfo)this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        ModelHelper.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        String finalFilePermission = smbProperties.setFilePermission(filePermission, "Preserve");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("Preserve");
        String fileCreationTime = smbProperties.setFileCreationTime("Preserve");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Preserve");
        String fileChangeTime = smbProperties.getFileChangeTimeString();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().setHttpHeadersWithResponse(this.shareName, this.filePath, fileAttributes, null, newFileSize, finalFilePermission, null, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, finalRequestConditions.getLeaseId(), httpHeaders, finalContext);
        return ModelHelper.setPropertiesResponse((ResponseBase<FilesSetHttpHeadersHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(ShareFileSetPropertiesOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions requestConditions = options.getRequestConditions();
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        FileSmbProperties smbProperties = options.getSmbProperties();
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        ModelHelper.validateFilePermissionAndKey(options.getFilePermissions().getPermission(), smbProperties.getFilePermissionKey());
        String finalFilePermission = smbProperties.setFilePermission(options.getFilePermissions().getPermission(), "Preserve");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("Preserve");
        String fileCreationTime = smbProperties.setFileCreationTime("Preserve");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Preserve");
        String fileChangeTime = smbProperties.getFileChangeTimeString();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().setHttpHeadersWithResponse(this.shareName, this.filePath, fileAttributes, null, options.getSizeInBytes(), finalFilePermission, options.getFilePermissions().getPermissionFormat(), filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, finalRequestConditions.getLeaseId(), options.getHttpHeaders(), finalContext);
        return ModelHelper.setPropertiesResponse((ResponseBase<FilesSetHttpHeadersHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileMetadataInfo setMetadata(Map<String, String> metadata) {
        return (ShareFileMetadataInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return this.setMetadataWithResponse(metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().setMetadataWithResponse(this.shareName, this.filePath, null, metadata, finalRequestConditions.getLeaseId(), finalContext);
        return ModelHelper.setMetadataResponse((ResponseBase<FilesSetMetadataHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadInfo upload(InputStream data, long length) {
        return (ShareFileUploadInfo)this.uploadWithResponse(data, length, 0L, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, Duration timeout, Context context) {
        return this.uploadWithResponse(data, length, offset, null, timeout, context);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length).setOffset(offset).setRequestConditions(requestConditions), timeout, context);
    }

    public ShareFileUploadInfo upload(InputStream data, long length, ParallelTransferOptions transferOptions) {
        return (ShareFileUploadInfo)this.uploadWithResponse(new ShareFileUploadOptions(data, length).setParallelTransferOptions(transferOptions), null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadWithResponse(ShareFileUploadOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadWithResponse(options, context), (Duration)timeout);
    }

    public ShareFileUploadInfo uploadRange(InputStream data, long length) {
        return (ShareFileUploadInfo)this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length), null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadRangeWithResponse(ShareFileUploadRangeOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadRangeWithResponse(options, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadRangeFromUrlInfo uploadRangeFromUrl(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return (ShareFileUploadRangeFromUrlInfo)this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(new ShareFileUploadRangeFromUrlOptions(length, sourceUrl).setDestinationOffset(destinationOffset).setSourceOffset(sourceOffset).setDestinationRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(ShareFileUploadRangeFromUrlOptions options, Duration timeout, Context context) {
        ShareRequestConditions finalRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        ShareFileRange destinationRange = new ShareFileRange(options.getDestinationOffset(), options.getDestinationOffset() + options.getLength() - 1L);
        ShareFileRange sourceRange = new ShareFileRange(options.getSourceOffset(), options.getSourceOffset() + options.getLength() - 1L);
        Context finalContext = context == null ? Context.NONE : context;
        String sourceAuth = options.getSourceAuthorization() == null ? null : options.getSourceAuthorization().toString();
        String copySource = Utility.encodeUrlPath((String)options.getSourceUrl());
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().uploadRangeFromURLWithResponse(this.shareName, this.filePath, destinationRange.toString(), copySource, 0L, null, sourceRange.toString(), null, finalRequestConditions.getLeaseId(), sourceAuth, options.getLastWrittenMode(), null, finalContext);
        return ModelHelper.mapUploadRangeFromUrlResponse((ResponseBase<FilesUploadRangeFromURLHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadInfo clearRange(long length) {
        return (ShareFileUploadInfo)this.clearRangeWithResponse(length, 0L, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, Duration timeout, Context context) {
        return this.clearRangeWithResponse(length, offset, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        ShareFileRange range = new ShareFileRange(offset, offset + length - 1L);
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().uploadRangeWithResponse(this.shareName, this.filePath, range.toString(), ShareFileRangeWriteType.CLEAR, 0L, null, null, finalRequestConditions.getLeaseId(), null, null, null, null, finalContext);
        return ModelHelper.transformUploadResponse((ResponseBase<FilesUploadRangeHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String uploadFilePath) {
        this.uploadFromFile(uploadFilePath, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String uploadFilePath, ShareRequestConditions requestConditions) {
        this.shareFileAsyncClient.uploadFromFile(uploadFilePath, requestConditions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges() {
        return this.listRanges(null, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, Duration timeout, Context context) {
        return this.listRanges(range, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        String rangeString = range == null ? null : range.toString();
        try {
            Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().getRangeListWithResponse(this.shareName, this.filePath, this.snapshot, null, null, rangeString, finalRequestConditions.getLeaseId(), null, finalContext);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            List shareFileRangeList = ((ShareFileRangeList)response.getValue()).getRanges().stream().map(r -> new Range().setStart(r.getStart()).setEnd(r.getEnd())).map(ShareFileRange::new).collect(Collectors.toList());
            Supplier<PagedResponse> finalResponse = () -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), shareFileRangeList, null, (Object)((FilesGetRangeListHeaders)response.getDeserializedHeaders()));
            return new PagedIterable(finalResponse);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileRangeList listRangesDiff(String previousSnapshot) {
        return (ShareFileRangeList)this.listRangesDiffWithResponse(new ShareFileListRangesDiffOptions(previousSnapshot), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileRangeList> listRangesDiffWithResponse(ShareFileListRangesDiffOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        String rangeString = options.getRange() == null ? null : options.getRange().toString();
        Callable<Response> operation = () -> this.azureFileStorageClient.getFiles().getRangeListNoCustomHeadersWithResponse(this.shareName, this.filePath, this.snapshot, options.getPreviousSnapshot(), null, rangeString, requestConditions.getLeaseId(), options.isRenameIncluded(), finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles() {
        return this.listHandles(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles(Integer maxResultsPerPage, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().listHandlesWithResponse(this.shareName, this.filePath, null, maxResultsPerPage, null, this.snapshot, finalContext);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            Supplier<PagedResponse> finalResponse = () -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ModelHelper.transformHandleItems(((ListHandlesResponse)response.getValue()).getHandleList()), null, (Object)((FilesListHandlesHeaders)response.getDeserializedHeaders()));
            return new PagedIterable(finalResponse);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseHandle(String handleId) {
        return (CloseHandlesInfo)this.forceCloseHandleWithResponse(handleId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloseHandlesInfo> forceCloseHandleWithResponse(String handleId, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().forceCloseHandlesWithResponse(this.shareName, this.filePath, handleId, null, null, this.snapshot, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
        return new SimpleResponse((Response)response, (Object)new CloseHandlesInfo(((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseAllHandles(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().forceCloseHandlesWithResponse(this.shareName, this.filePath, "*", null, null, this.snapshot, finalContext);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            Supplier<PagedResponse> finalResponse = () -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsMarker(), (Object)((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()));
            return new PagedIterable(finalResponse).stream().reduce(new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles()));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient rename(String destinationPath) {
        return (ShareFileClient)this.renameWithResponse(new ShareFileRenameOptions(destinationPath), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> renameWithResponse(ShareFileRenameOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new ShareRequestConditions() : options.getSourceRequestConditions();
        ShareRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        SourceLeaseAccessConditions sourceConditions = new SourceLeaseAccessConditions().setSourceLeaseId(sourceRequestConditions.getLeaseId());
        DestinationLeaseAccessConditions destinationConditions = new DestinationLeaseAccessConditions().setDestinationLeaseId(destinationRequestConditions.getLeaseId());
        CopyFileSmbInfo smbInfo = null;
        String filePermissionKey = null;
        if (options.getSmbProperties() != null) {
            FileSmbProperties tempSmbProperties = options.getSmbProperties();
            filePermissionKey = tempSmbProperties.getFilePermissionKey();
            String fileAttributes = NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
            String fileCreationTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
            String fileLastWriteTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
            String fileChangeTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
            smbInfo = new CopyFileSmbInfo().setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangeTime).setIgnoreReadOnly(options.isIgnoreReadOnly());
        }
        CopyFileSmbInfo finalSmbInfo = smbInfo;
        String finalFilePermissionKey = filePermissionKey;
        ShareFileClient destinationFileClient = this.getFileClient(options.getDestinationPath());
        ShareFileHttpHeaders headers = options.getContentType() == null ? null : new ShareFileHttpHeaders().setContentType(options.getContentType());
        String renameSource = Utility.encodeUrlPath((String)this.getFileUrl());
        String finalRenameSource = this.sasToken != null ? renameSource + "?" + this.sasToken.getSignature() : renameSource;
        Callable<Response> operation = () -> destinationFileClient.azureFileStorageClient.getFiles().renameNoCustomHeadersWithResponse(destinationFileClient.getShareName(), destinationFileClient.getFilePath(), finalRenameSource, null, options.getReplaceIfExists(), options.isIgnoreReadOnly(), options.getFilePermission(), options.getFilePermissionFormat(), finalFilePermissionKey, options.getMetadata(), sourceConditions, destinationConditions, finalSmbInfo, headers, finalContext);
        return new SimpleResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class), (Object)destinationFileClient);
    }

    ShareFileClient getFileClient(String destinationPath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new ShareFileClient(this.shareFileAsyncClient, this.azureFileStorageClient, this.getShareName(), destinationPath, null, this.getAccountName(), this.getServiceVersion(), this.getSasToken());
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    AzureSasCredential getSasToken() {
        return this.sasToken;
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.generateSas(shareServiceSasSignatureValues, null, context);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getFilePath()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }
}

