// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A listed file item.
 */
@Fluent
public final class FileItem implements XmlSerializable<FileItem> {
    /*
     * The Name property.
     */
    private StringEncoded name;

    /*
     * The FileId property.
     */
    private String fileId;

    /*
     * File properties.
     */
    private FileProperty properties;

    /*
     * The Attributes property.
     */
    private String attributes;

    /*
     * The PermissionKey property.
     */
    private String permissionKey;

    /**
     * Creates an instance of FileItem class.
     */
    public FileItem() {
    }

    /**
     * Get the name property: The Name property.
     * 
     * @return the name value.
     */
    public StringEncoded getName() {
        return this.name;
    }

    /**
     * Set the name property: The Name property.
     * 
     * @param name the name value to set.
     * @return the FileItem object itself.
     */
    public FileItem setName(StringEncoded name) {
        this.name = name;
        return this;
    }

    /**
     * Get the fileId property: The FileId property.
     * 
     * @return the fileId value.
     */
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Set the fileId property: The FileId property.
     * 
     * @param fileId the fileId value to set.
     * @return the FileItem object itself.
     */
    public FileItem setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    /**
     * Get the properties property: File properties.
     * 
     * @return the properties value.
     */
    public FileProperty getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: File properties.
     * 
     * @param properties the properties value to set.
     * @return the FileItem object itself.
     */
    public FileItem setProperties(FileProperty properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the attributes property: The Attributes property.
     * 
     * @return the attributes value.
     */
    public String getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The Attributes property.
     * 
     * @param attributes the attributes value to set.
     * @return the FileItem object itself.
     */
    public FileItem setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the permissionKey property: The PermissionKey property.
     * 
     * @return the permissionKey value.
     */
    public String getPermissionKey() {
        return this.permissionKey;
    }

    /**
     * Set the permissionKey property: The PermissionKey property.
     * 
     * @param permissionKey the permissionKey value to set.
     * @return the FileItem object itself.
     */
    public FileItem setPermissionKey(String permissionKey) {
        this.permissionKey = permissionKey;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "File" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.name, "Name");
        xmlWriter.writeStringElement("FileId", this.fileId);
        xmlWriter.writeXml(this.properties, "Properties");
        xmlWriter.writeStringElement("Attributes", this.attributes);
        xmlWriter.writeStringElement("PermissionKey", this.permissionKey);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of FileItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of FileItem if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the FileItem.
     */
    public static FileItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of FileItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of FileItem if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the FileItem.
     */
    public static FileItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "File" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            FileItem deserializedFileItem = new FileItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedFileItem.name = StringEncoded.fromXml(reader, "Name");
                } else if ("FileId".equals(elementName.getLocalPart())) {
                    deserializedFileItem.fileId = reader.getStringElement();
                } else if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedFileItem.properties = FileProperty.fromXml(reader, "Properties");
                } else if ("Attributes".equals(elementName.getLocalPart())) {
                    deserializedFileItem.attributes = reader.getStringElement();
                } else if ("PermissionKey".equals(elementName.getLocalPart())) {
                    deserializedFileItem.permissionKey = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedFileItem;
        });
    }
}
