/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressListener;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.BufferAggregator;
import com.azure.storage.common.implementation.BufferStagingArea;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.FilesDownloadHeaders;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesStartCopyHeaders;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.CopyableFileSmbPropertiesList;
import com.azure.storage.file.share.models.DownloadRetryOptions;
import com.azure.storage.file.share.models.FilePermissionFormat;
import com.azure.storage.file.share.models.FilePosixProperties;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.Range;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileCopyInfo;
import com.azure.storage.file.share.models.ShareFileDownloadAsyncResponse;
import com.azure.storage.file.share.models.ShareFileDownloadHeaders;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFilePermission;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadOptions;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeOptions;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileCopyOptions;
import com.azure.storage.file.share.options.ShareFileCreateHardLinkOptions;
import com.azure.storage.file.share.options.ShareFileCreateOptions;
import com.azure.storage.file.share.options.ShareFileDownloadOptions;
import com.azure.storage.file.share.options.ShareFileListRangesDiffOptions;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareFileSetPropertiesOptions;
import com.azure.storage.file.share.options.ShareFileUploadRangeFromUrlOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;
import reactor.util.retry.Retry;

@ServiceClient(builder=ShareFileClientBuilder.class, isAsync=true)
public class ShareFileAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileAsyncClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String filePath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;

    ShareFileAsyncClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String filePath, String snapshot, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(filePath, "'filePath' cannot be null.");
        this.shareName = shareName;
        this.filePath = filePath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
    }

    ShareFileAsyncClient(ShareFileAsyncClient fileAsyncClient) {
        this(fileAsyncClient.azureFileStorageClient, fileAsyncClient.shareName, Utility.urlEncode((String)fileAsyncClient.filePath), fileAsyncClient.snapshot, fileAsyncClient.accountName, fileAsyncClient.serviceVersion, fileAsyncClient.sasToken);
    }

    public String getAccountUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public String getFileUrl() {
        StringBuilder fileUrlstring = new StringBuilder(this.azureFileStorageClient.getUrl()).append("/").append(this.shareName).append("/").append(this.filePath);
        if (this.snapshot != null) {
            fileUrlstring.append("?sharesnapshot=").append(this.snapshot);
        }
        return fileUrlstring.toString();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    AzureSasCredential getSasToken() {
        return this.sasToken;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(null, context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(this::checkDoesNotExistStatusCode, t -> {
            HttpResponse response = t instanceof ShareStorageException ? ((ShareStorageException)((Object)((Object)t))).getResponse() : ((HttpResponseException)t).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    private boolean checkDoesNotExistStatusCode(Throwable t) {
        return t instanceof ShareStorageException && ((ShareStorageException)((Object)t)).getStatusCode() == 404 && (((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.RESOURCE_NOT_FOUND || ((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND) || t instanceof HttpResponseException && ((HttpResponseException)t).getResponse().getStatusCode() == 404 && (((HttpResponseException)t).getResponse().getHeaderValue("x-ms-error-code").equals(ShareErrorCode.RESOURCE_NOT_FOUND.toString()) || ((HttpResponseException)t).getResponse().getHeaderValue("x-ms-error-code").equals(ShareErrorCode.SHARE_NOT_FOUND.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileInfo> create(long maxSize) {
        return this.createWithResponse(maxSize, null, null, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        return this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, null, null, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> createWithResponse(ShareFileCreateOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return FluxUtil.withContext(context -> this.createWithResponse(options.getSize(), options.getShareFileHttpHeaders(), options.getSmbProperties(), options.getFilePermission(), options.getFilePermissionFormat(), options.getPosixProperties(), options.getMetadata(), options.getRequestConditions(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileInfo>> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, FilePermissionFormat filePermissionFormat, FilePosixProperties fileposixProperties, Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        context = context == null ? Context.NONE : context;
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        fileposixProperties = fileposixProperties == null ? new FilePosixProperties() : fileposixProperties;
        ModelHelper.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        return this.azureFileStorageClient.getFiles().createWithResponseAsync(this.shareName, this.filePath, maxSize, null, metadata, filePermission, filePermissionFormat, smbProperties.getFilePermissionKey(), smbProperties.getNtfsFileAttributesString(), smbProperties.getFileCreationTimeString(), smbProperties.getFileLastWriteTimeString(), smbProperties.getFileChangeTimeString(), requestConditions.getLeaseId(), fileposixProperties.getOwner(), fileposixProperties.getGroup(), fileposixProperties.getFileMode(), fileposixProperties.getFileType(), httpHeaders, context).map(ModelHelper::createFileInfoResponse);
    }

    public PollerFlux<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, Duration pollInterval) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setMetadata(metadata);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public PollerFlux<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, FileSmbProperties smbProperties, String filePermission, PermissionCopyModeType filePermissionCopyMode, Boolean ignoreReadOnly, Boolean setArchiveAttribute, Map<String, String> metadata, Duration pollInterval, ShareRequestConditions destinationRequestConditions) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setSmbProperties(smbProperties).setFilePermission(filePermission).setPermissionCopyModeType(filePermissionCopyMode).setIgnoreReadOnly(ignoreReadOnly).setArchiveAttribute(setArchiveAttribute).setMetadata(metadata).setDestinationRequestConditions(destinationRequestConditions);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public PollerFlux<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, ShareFileCopyOptions options, Duration pollInterval) {
        CopyableFileSmbPropertiesList list;
        ShareRequestConditions finalRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        AtomicReference copyId = new AtomicReference();
        Duration interval = pollInterval == null ? Duration.ofSeconds(1L) : pollInterval;
        FileSmbProperties tempSmbProperties = options.getSmbProperties() == null ? new FileSmbProperties() : options.getSmbProperties();
        String filePermissionKey = tempSmbProperties.getFilePermissionKey();
        if (options.getFilePermission() == null || options.getPermissionCopyModeType() == PermissionCopyModeType.SOURCE) {
            if ((options.getFilePermission() != null || filePermissionKey != null) && options.getPermissionCopyModeType() != PermissionCopyModeType.OVERRIDE) {
                return PollerFlux.error((Exception)LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key can not be set when PermissionCopyModeType is source or null")));
            }
        } else if (options.getPermissionCopyModeType() == PermissionCopyModeType.OVERRIDE) {
            try {
                ModelHelper.validateFilePermissionAndKey(options.getFilePermission(), tempSmbProperties.getFilePermissionKey());
            }
            catch (RuntimeException ex) {
                return PollerFlux.error((Exception)LOGGER.logExceptionAsError(ex));
            }
        }
        CopyableFileSmbPropertiesList copyableFileSmbPropertiesList = list = options.getSmbPropertiesToCopy() == null ? new CopyableFileSmbPropertiesList() : options.getSmbPropertiesToCopy();
        if (list.isFileAttributes().booleanValue() && tempSmbProperties.getNtfsFileAttributes() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetFileAttributes and smbProperties.ntfsFileAttributes cannot be set."));
        }
        if (list.isCreatedOn().booleanValue() && tempSmbProperties.getFileCreationTime() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetCreatedOn and smbProperties.fileCreationTime cannot be set."));
        }
        if (list.isLastWrittenOn().booleanValue() && tempSmbProperties.getFileLastWriteTime() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetLastWrittenOn and smbProperties.fileLastWriteTime cannot be set."));
        }
        if (list.isChangedOn().booleanValue() && tempSmbProperties.getFileChangeTime() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetChangedOn and smbProperties.fileChangeTime cannot be set."));
        }
        String fileAttributes = list.isFileAttributes() != false ? null : NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
        String fileCreationTime = list.isCreatedOn() != false ? null : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
        String fileLastWriteTime = list.isLastWrittenOn() != false ? null : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
        String fileChangedOnTime = list.isChangedOn() != false ? null : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
        CopyFileSmbInfo copyFileSmbInfo = new CopyFileSmbInfo().setFilePermissionCopyMode(options.getPermissionCopyModeType()).setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangedOnTime).setIgnoreReadOnly(options.isIgnoreReadOnly()).setSetArchiveAttribute(options.isArchiveAttributeSet());
        String copySource = Utility.encodeUrlPath((String)sourceUrl);
        FilePosixProperties fileposixProperties = options.getPosixProperties() == null ? new FilePosixProperties() : options.getPosixProperties();
        return new PollerFlux(interval, pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.azureFileStorageClient.getFiles().startCopyWithResponseAsync(this.shareName, this.filePath, copySource, null, options.getMetadata(), options.getFilePermission(), options.getFilePermissionFormat(), tempSmbProperties.getFilePermissionKey(), finalRequestConditions.getLeaseId(), fileposixProperties.getOwner(), fileposixProperties.getGroup(), fileposixProperties.getFileMode(), options.getModeCopyMode(), options.getOwnerCopyMode(), copyFileSmbInfo, (Context)context)).map(response -> {
                    FilesStartCopyHeaders headers = (FilesStartCopyHeaders)response.getDeserializedHeaders();
                    copyId.set(headers.getXMsCopyId());
                    return new ShareFileCopyInfo(sourceUrl, headers.getXMsCopyId(), headers.getXMsCopyStatus(), headers.getETag(), headers.getLastModified(), response.getHeaders().getValue("x-ms-error-code"));
                });
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        }, pollingContext -> {
            try {
                return this.onPoll((PollResponse<ShareFileCopyInfo>)pollingContext.getLatestResponse(), finalRequestConditions);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        }, (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started.")));
            }
            String copyIdentifier = ((ShareFileCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)copyIdentifier)) {
                LOGGER.info("Cancelling copy operation for copy id: {}", new Object[]{copyIdentifier});
                return this.abortCopyWithResponse(copyIdentifier, finalRequestConditions).thenReturn((Object)((ShareFileCopyInfo)firstResponse.getValue()));
            }
            return Mono.empty();
        }, pollingContext -> Mono.empty());
    }

    private Mono<PollResponse<ShareFileCopyInfo>> onPoll(PollResponse<ShareFileCopyInfo> pollResponse, ShareRequestConditions requestConditions) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.just(pollResponse);
        }
        ShareFileCopyInfo lastInfo = (ShareFileCopyInfo)pollResponse.getValue();
        if (lastInfo == null) {
            LOGGER.warning("ShareFileCopyInfo does not exist. Activation operation failed.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"COPY_START_FAILED", (boolean)true), null));
        }
        return this.getPropertiesWithResponse(requestConditions).map(response -> {
            ShareFileProperties value = (ShareFileProperties)response.getValue();
            CopyStatusType status = value.getCopyStatus();
            ShareFileCopyInfo result = new ShareFileCopyInfo(value.getCopySource(), value.getCopyId(), status, value.getETag(), value.getCopyCompletionTime(), value.getCopyStatusDescription());
            LongRunningOperationStatus operationStatus = ModelHelper.mapStatusToLongRunningOperationStatus(status);
            return new PollResponse(operationStatus, (Object)result);
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true), (Object)lastInfo));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> abortCopy(String copyId) {
        return this.abortCopyWithResponse(copyId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> abortCopyWithResponse(String copyId) {
        return this.abortCopyWithResponse(copyId, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.abortCopyWithResponse(copyId, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        return this.azureFileStorageClient.getFiles().abortCopyNoCustomHeadersWithResponseAsync(this.shareName, this.filePath, copyId, null, requestConditions.getLeaseId(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileProperties> downloadToFile(String downloadFilePath) {
        return this.downloadToFileWithResponse(downloadFilePath, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileProperties>> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range) {
        return this.downloadToFileWithResponse(downloadFilePath, range, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileProperties>> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.downloadToFileWithResponse(downloadFilePath, range, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileProperties>> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions, Context context) {
        return Mono.using(() -> this.channelSetup(downloadFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), channel -> this.getPropertiesWithResponse(requestConditions, context).flatMap(response -> this.downloadResponseInChunk((Response<ShareFileProperties>)response, (AsynchronousFileChannel)channel, range, requestConditions, context)), this::channelCleanUp);
    }

    private Mono<Response<ShareFileProperties>> downloadResponseInChunk(Response<ShareFileProperties> response, AsynchronousFileChannel channel, ShareFileRange range, ShareRequestConditions requestConditions, Context context) {
        return Mono.justOrEmpty((Object)range).switchIfEmpty(Mono.defer(() -> Mono.just((Object)new ShareFileRange(0L, ((ShareFileProperties)response.getValue()).getContentLength())))).map(currentRange -> {
            ArrayList<ShareFileRange> chunks = new ArrayList<ShareFileRange>();
            for (long pos = currentRange.getStart(); pos < currentRange.getEnd(); pos += 0x400000L) {
                long count = 0x400000L;
                if (pos + count > currentRange.getEnd()) {
                    count = currentRange.getEnd() - pos;
                }
                chunks.add(new ShareFileRange(pos, pos + count - 1L));
            }
            return chunks;
        }).flatMapMany(Flux::fromIterable).flatMap(chunk -> this.downloadWithResponse(new ShareFileDownloadOptions().setRange((ShareFileRange)chunk).setRangeContentMd5Requested(false).setRequestConditions(requestConditions), context).map(ResponseBase::getValue).flatMap(fbb -> FluxUtil.writeFile((Flux)fbb, (AsynchronousFileChannel)channel, (long)(chunk.getStart() - (range == null ? 0L : range.getStart()))))).then(Mono.just(response));
    }

    private AsynchronousFileChannel channelSetup(String filePath, OpenOption ... options) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), options);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    private void channelCleanUp(AsynchronousFileChannel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)new UncheckedIOException(e)));
        }
    }

    public Flux<ByteBuffer> download() {
        return this.downloadWithResponse(null).flatMapMany(ResponseBase::getValue);
    }

    public Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileRange range, Boolean rangeGetContentMD5) {
        return this.downloadWithResponse(range, rangeGetContentMD5, null);
    }

    public Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions) {
        return this.downloadWithResponse(new ShareFileDownloadOptions().setRange(range).setRangeContentMd5Requested(rangeGetContentMD5).setRequestConditions(requestConditions));
    }

    public Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileDownloadOptions options) {
        try {
            return FluxUtil.withContext(context -> this.downloadWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileDownloadOptions options, Context context) {
        options = options == null ? new ShareFileDownloadOptions() : options;
        ShareFileRange range = options.getRange() == null ? new ShareFileRange(0L) : options.getRange();
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        DownloadRetryOptions retryOptions = options.getRetryOptions() == null ? new DownloadRetryOptions() : options.getRetryOptions();
        Boolean getRangeContentMd5 = options.isRangeContentMd5Requested();
        return this.downloadRange(range, getRangeContentMd5, requestConditions, context).map(response -> {
            String eTag = ModelHelper.getETag(response.getHeaders());
            ShareFileDownloadHeaders headers = ModelHelper.transformFileDownloadHeaders((FilesDownloadHeaders)response.getDeserializedHeaders(), response.getHeaders());
            long finalEnd = range.getEnd() == null ? (headers.getContentRange() == null ? headers.getContentLength() : Long.parseLong(headers.getContentRange().split("/")[1])) : range.getEnd();
            Flux bufferFlux = FluxUtil.createRetriableDownloadFlux(() -> ((ResponseBase)response).getValue(), (throwable, offset) -> {
                if (!(throwable instanceof IOException) && !(throwable instanceof TimeoutException)) {
                    return Flux.error((Throwable)throwable);
                }
                long newCount = finalEnd - (offset - range.getStart());
                if (newCount == 0L) {
                    LOGGER.warning("Exception encountered in ReliableDownload after all data read from the network but but before stream signaled completion. Returning success as all data was downloaded. Exception message: " + throwable.getMessage());
                    return Flux.empty();
                }
                try {
                    return this.downloadRange(new ShareFileRange((long)offset, range.getEnd()), getRangeContentMd5, requestConditions, context).flatMapMany(r -> {
                        String receivedETag = ModelHelper.getETag(r.getHeaders());
                        if (eTag != null && eTag.equals(receivedETag)) {
                            return (Publisher)r.getValue();
                        }
                        return Flux.error((Throwable)new ConcurrentModificationException(String.format("File has been modified concurrently. Expected eTag: %s, Received eTag: %s", eTag, receivedETag)));
                    });
                }
                catch (Exception e) {
                    return Flux.error((Throwable)e);
                }
            }, (int)retryOptions.getMaxRetryRequests(), (long)range.getStart()).switchIfEmpty((Publisher)Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(new byte[0]))));
            return new ShareFileDownloadAsyncResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Flux<ByteBuffer>)bufferFlux, headers);
        });
    }

    private Mono<ResponseBase<FilesDownloadHeaders, Flux<ByteBuffer>>> downloadRange(ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions, Context context) {
        String rangeString = range == null ? null : range.toHeaderValue();
        return this.azureFileStorageClient.getFiles().downloadWithResponseAsync(this.shareName, this.filePath, null, rangeString, rangeGetContentMD5, null, requestConditions.getLeaseId(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse() {
        return this.deleteWithResponse(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        return this.azureFileStorageClient.getFiles().deleteNoCustomHeadersWithResponseAsync(this.shareName, this.filePath, null, requestConditions.getLeaseId(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteIfExists() {
        return this.deleteIfExistsWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteIfExistsWithResponse(ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteIfExistsWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> deleteIfExistsWithResponse(ShareRequestConditions requestConditions, Context context) {
        try {
            requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
            return this.deleteWithResponse(requestConditions, context).map(response -> new SimpleResponse(response, (Object)true)).onErrorResume(t -> t instanceof ShareStorageException && ((ShareStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
                HttpResponse response = ((ShareStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileProperties>> getPropertiesWithResponse() {
        return this.getPropertiesWithResponse(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileProperties>> getPropertiesWithResponse(ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileProperties>> getPropertiesWithResponse(ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getFiles().getPropertiesWithResponseAsync(this.shareName, this.filePath, this.snapshot, null, requestConditions.getLeaseId(), context).map(ModelHelper::getPropertiesResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileInfo> setProperties(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, null, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> setPropertiesWithResponse(ShareFileSetPropertiesOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            ShareFilePermission filePermission = options.getFilePermissions() == null ? new ShareFilePermission() : options.getFilePermissions();
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(options.getSizeInBytes(), options.getHttpHeaders(), options.getSmbProperties(), filePermission.getPermission(), filePermission.getPermissionFormat(), options.getPosixProperties(), options.getRequestConditions(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileInfo>> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, FilePermissionFormat filePermissionFormat, FilePosixProperties fileposixProperties, ShareRequestConditions requestConditions, Context context) {
        context = context == null ? Context.NONE : context;
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        fileposixProperties = fileposixProperties == null ? new FilePosixProperties() : fileposixProperties;
        ModelHelper.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        return this.azureFileStorageClient.getFiles().setHttpHeadersWithResponseAsync(this.shareName, this.filePath, null, newFileSize, filePermission, filePermissionFormat, smbProperties.getFilePermissionKey(), smbProperties.getNtfsFileAttributesString(), smbProperties.getFileCreationTimeString(), smbProperties.getFileLastWriteTimeString(), smbProperties.getFileChangeTimeString(), requestConditions.getLeaseId(), fileposixProperties.getOwner(), fileposixProperties.getGroup(), fileposixProperties.getFileMode(), httpHeaders, context).map(ModelHelper::setPropertiesResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileMetadataInfo> setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        try {
            return this.azureFileStorageClient.getFiles().setMetadataWithResponseAsync(this.shareName, this.filePath, null, metadata, requestConditions.getLeaseId(), context).map(ModelHelper::setMetadataResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileUploadInfo> upload(Flux<ByteBuffer> data, long length) {
        return this.uploadWithResponse(data, length, 0L).flatMap(FluxUtil::toMono);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadInfo>> uploadWithResponse(Flux<ByteBuffer> data, long length, Long offset) {
        return this.uploadWithResponse(data, length, offset, null);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadInfo>> uploadWithResponse(Flux<ByteBuffer> data, long length, Long offset, ShareRequestConditions requestConditions) {
        try {
            return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length).setOffset(offset).setRequestConditions(requestConditions));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Mono<ShareFileUploadInfo> upload(Flux<ByteBuffer> data, ParallelTransferOptions transferOptions) {
        try {
            return this.uploadWithResponse(new ShareFileUploadOptions(data).setParallelTransferOptions(transferOptions)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileUploadInfo>> uploadWithResponse(ShareFileUploadOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadInfo>> uploadWithResponse(ShareFileUploadOptions options, Context context) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            ShareRequestConditions validatedRequestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
            ParallelTransferOptions validatedParallelTransferOptions = ModelHelper.populateAndApplyDefaults(options.getParallelTransferOptions());
            long validatedOffset = options.getOffset() == null ? 0L : options.getOffset();
            Function<Flux, Mono> uploadInChunks = stream -> this.uploadInChunks((Flux<ByteBuffer>)stream, validatedOffset, validatedParallelTransferOptions, validatedRequestConditions, context);
            BiFunction<Flux, Long, Mono> uploadFull = (stream, length) -> {
                ProgressListener progressListener = validatedParallelTransferOptions.getProgressListener();
                Context uploadContext = context;
                if (progressListener != null) {
                    uploadContext = Contexts.with((Context)context).setHttpRequestProgressReporter(ProgressReporter.withProgressListener((ProgressListener)progressListener)).getContext();
                }
                return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions((Flux<ByteBuffer>)stream, (long)length).setOffset(options.getOffset()).setRequestConditions(validatedRequestConditions), uploadContext);
            };
            Flux data = options.getDataFlux();
            data = UploadUtils.extractByteBuffer(data, (Long)options.getLength(), (Long)validatedParallelTransferOptions.getBlockSizeLong(), (InputStream)options.getDataStream());
            return UploadUtils.uploadFullOrChunked((Flux)data, (ParallelTransferOptions)validatedParallelTransferOptions, uploadInChunks, uploadFull);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadInfo>> uploadInChunks(Flux<ByteBuffer> data, long offset, ParallelTransferOptions parallelTransferOptions, ShareRequestConditions requestConditions, Context context) {
        BufferStagingArea stagingArea = new BufferStagingArea(parallelTransferOptions.getBlockSizeLong().longValue(), 0x400000L);
        Flux chunkedSource = UploadUtils.chunkSource(data, (ParallelTransferOptions)parallelTransferOptions);
        ProgressListener progressListener = parallelTransferOptions.getProgressListener();
        ProgressReporter progressReporter = progressListener == null ? null : ProgressReporter.withProgressListener((ProgressListener)progressListener);
        return chunkedSource.flatMapSequential(arg_0 -> ((BufferStagingArea)stagingArea).write(arg_0), 1, 1).concatWith((Publisher)Flux.defer(() -> ((BufferStagingArea)stagingArea).flush())).map(bufferAggregator -> Tuples.of((Object)bufferAggregator, (Object)bufferAggregator.length(), (Object)0L)).scan((result, source) -> {
            BufferAggregator bufferAggregator = (BufferAggregator)source.getT1();
            long currentBufferLength = bufferAggregator.length();
            long lastBytesWritten = (Long)result.getT2();
            long lastOffset = (Long)result.getT3();
            return Tuples.of((Object)bufferAggregator, (Object)currentBufferLength, (Object)(lastBytesWritten + lastOffset));
        }).flatMapSequential(tuple3 -> {
            BufferAggregator bufferAggregator = (BufferAggregator)tuple3.getT1();
            long currentBufferLength = bufferAggregator.length();
            long currentOffset = (Long)tuple3.getT3() + offset;
            Context uploadContext = context;
            if (progressReporter != null) {
                uploadContext = Contexts.with((Context)context).setHttpRequestProgressReporter(progressReporter.createChild()).getContext();
            }
            return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions((Flux<ByteBuffer>)bufferAggregator.asFlux(), currentBufferLength).setOffset(currentOffset).setRequestConditions(requestConditions), uploadContext).flux();
        }, parallelTransferOptions.getMaxConcurrency().intValue(), 1).last();
    }

    public Mono<ShareFileUploadInfo> uploadRange(Flux<ByteBuffer> data, long length) {
        try {
            return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileUploadInfo>> uploadRangeWithResponse(ShareFileUploadRangeOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadRangeWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadInfo>> uploadRangeWithResponse(ShareFileUploadRangeOptions options, Context context) {
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        long rangeOffset = options.getOffset() == null ? 0L : options.getOffset();
        ShareFileRange range = new ShareFileRange(rangeOffset, rangeOffset + options.getLength() - 1L);
        context = context == null ? Context.NONE : context;
        Flux data = options.getDataFlux() == null ? Utility.convertStreamToByteBuffer((InputStream)options.getDataStream(), (long)options.getLength(), (int)0x400000, (boolean)true) : options.getDataFlux();
        return this.azureFileStorageClient.getFiles().uploadRangeWithResponseAsync(this.shareName, this.filePath, range.toString(), ShareFileRangeWriteType.UPDATE, options.getLength(), null, null, requestConditions.getLeaseId(), options.getLastWrittenMode(), null, null, (Flux<ByteBuffer>)data, context).map(ModelHelper::uploadRangeHeadersToShareFileInfo);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrl(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions destinationRequestConditions) {
        try {
            return this.uploadRangeFromUrlWithResponse(new ShareFileUploadRangeFromUrlOptions(length, sourceUrl).setDestinationOffset(destinationOffset).setSourceOffset(sourceOffset).setDestinationRequestConditions(destinationRequestConditions));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(ShareFileUploadRangeFromUrlOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadRangeFromUrlWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(ShareFileUploadRangeFromUrlOptions options, Context context) {
        ShareRequestConditions modifiedRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        ShareFileRange destinationRange = new ShareFileRange(options.getDestinationOffset(), options.getDestinationOffset() + options.getLength() - 1L);
        ShareFileRange sourceRange = new ShareFileRange(options.getSourceOffset(), options.getSourceOffset() + options.getLength() - 1L);
        context = context == null ? Context.NONE : context;
        String sourceAuth = options.getSourceAuthorization() == null ? null : options.getSourceAuthorization().toString();
        String copySource = Utility.encodeUrlPath((String)options.getSourceUrl());
        return this.azureFileStorageClient.getFiles().uploadRangeFromURLWithResponseAsync(this.shareName, this.filePath, destinationRange.toString(), copySource, 0L, null, sourceRange.toString(), null, modifiedRequestConditions.getLeaseId(), sourceAuth, options.getLastWrittenMode(), null, context).map(ModelHelper::mapUploadRangeFromUrlResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileUploadInfo> clearRange(long length) {
        return this.clearRangeWithResponse(length, 0L).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadInfo>> clearRangeWithResponse(long length, long offset) {
        return this.clearRangeWithResponse(length, offset, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileUploadInfo>> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.clearRangeWithResponse(length, offset, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadInfo>> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        ShareFileRange range = new ShareFileRange(offset, offset + length - 1L);
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getFiles().uploadRangeWithResponseAsync(this.shareName, this.filePath, range.toString(), ShareFileRangeWriteType.CLEAR, 0L, null, null, requestConditions.getLeaseId(), null, null, null, (Flux<ByteBuffer>)((Flux)null), context).map(ModelHelper::transformUploadResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String uploadFilePath) {
        return this.uploadFromFile(uploadFilePath, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String uploadFilePath, ShareRequestConditions requestConditions) {
        try {
            return Mono.using(() -> this.channelSetup(uploadFilePath, StandardOpenOption.READ), channel -> Flux.fromIterable(ShareFileAsyncClient.sliceFile(uploadFilePath)).flatMap(chunk -> this.uploadWithResponse((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)channel, (long)chunk.getStart(), (long)(chunk.getEnd() - chunk.getStart() + 1L)), chunk.getEnd() - chunk.getStart() + 1L, chunk.getStart(), requestConditions).retryWhen((Retry)Retry.max((long)3L).filter(throwable -> throwable instanceof IOException || throwable instanceof TimeoutException))).then(), this::channelCleanUp);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private static List<ShareFileRange> sliceFile(String path) {
        File file = new File(path);
        assert (file.exists());
        ArrayList<ShareFileRange> ranges = new ArrayList<ShareFileRange>();
        for (long pos = 0L; pos < file.length(); pos += 0x400000L) {
            long count = 0x400000L;
            if (pos + count > file.length()) {
                count = file.length() - pos;
            }
            ranges.add(new ShareFileRange(pos, pos + count - 1L));
        }
        return ranges;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareFileRange> listRanges() {
        return this.listRanges(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareFileRange> listRanges(ShareFileRange range) {
        return this.listRanges(range, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareFileRange> listRanges(ShareFileRange range, ShareRequestConditions requestConditions) {
        try {
            return this.listRangesWithOptionalTimeout(range, requestConditions, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileRangeList> listRangesDiff(String previousSnapshot) {
        try {
            return this.listRangesDiffWithResponse(new ShareFileListRangesDiffOptions(previousSnapshot)).map(Response::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileRangeList>> listRangesDiffWithResponse(ShareFileListRangesDiffOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return this.listRangesWithResponse(options.getRange(), options.getRequestConditions(), options.getPreviousSnapshot(), options.isRenameIncluded(), Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<ShareFileRange> listRangesWithOptionalTimeout(ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.listRangesWithResponse(range, requestConditions, null, null, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ShareFileRangeList)response.getValue()).getRanges().stream().map(r -> new Range().setStart(r.getStart()).setEnd(r.getEnd())).map(ShareFileRange::new).collect(Collectors.toList()), null, (Object)response.getHeaders()));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    Mono<Response<ShareFileRangeList>> listRangesWithResponse(ShareFileRange range, ShareRequestConditions requestConditions, String previousSnapshot, Boolean supportRename, Context context) {
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        String rangeString = range == null ? null : range.toString();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getFiles().getRangeListWithResponseAsync(this.shareName, this.filePath, this.snapshot, previousSnapshot, null, rangeString, finalRequestConditions.getLeaseId(), supportRename, context).map(response -> new SimpleResponse((Response)response, (Object)((ShareFileRangeList)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HandleItem> listHandles() {
        return this.listHandles(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HandleItem> listHandles(Integer maxResultsPerPage) {
        try {
            return this.listHandlesWithOptionalTimeout(maxResultsPerPage, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<HandleItem> listHandlesWithOptionalTimeout(Integer maxResultsPerPage, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.getFiles().listHandlesWithResponseAsync(this.shareName, this.filePath, (String)marker, maxResultsPerPage, null, this.snapshot, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ModelHelper.transformHandleItems(((ListHandlesResponse)response.getValue()).getHandleList()), ((ListHandlesResponse)response.getValue()).getNextMarker(), (Object)((FilesListHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CloseHandlesInfo> forceCloseHandle(String handleId) {
        return this.forceCloseHandleWithResponse(handleId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getFiles().forceCloseHandlesWithResponseAsync(this.shareName, this.filePath, handleId, null, null, this.snapshot, context).map(response -> new SimpleResponse((Response)response, (Object)new CloseHandlesInfo(((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CloseHandlesInfo> forceCloseAllHandles() {
        try {
            return FluxUtil.withContext(context -> this.forceCloseAllHandlesWithOptionalTimeout(null, (Context)context).reduce((Object)new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<CloseHandlesInfo> forceCloseAllHandlesWithOptionalTimeout(Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.getFiles().forceCloseHandlesWithResponseAsync(this.shareName, this.filePath, "*", null, (String)marker, this.snapshot, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsMarker(), (Object)((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileAsyncClient> rename(String destinationPath) {
        try {
            return this.renameWithResponse(new ShareFileRenameOptions(destinationPath)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileAsyncClient>> renameWithResponse(ShareFileRenameOptions options) {
        try {
            return FluxUtil.withContext(context -> this.renameWithResponse(options, (Context)context)).map(response -> new SimpleResponse(response, (Object)new ShareFileAsyncClient((ShareFileAsyncClient)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileAsyncClient>> renameWithResponse(ShareFileRenameOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        context = context == null ? Context.NONE : context;
        ShareRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new ShareRequestConditions() : options.getSourceRequestConditions();
        ShareRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        SourceLeaseAccessConditions sourceConditions = new SourceLeaseAccessConditions().setSourceLeaseId(sourceRequestConditions.getLeaseId());
        DestinationLeaseAccessConditions destinationConditions = new DestinationLeaseAccessConditions().setDestinationLeaseId(destinationRequestConditions.getLeaseId());
        CopyFileSmbInfo smbInfo = null;
        String filePermissionKey = null;
        if (options.getSmbProperties() != null) {
            FileSmbProperties tempSmbProperties = options.getSmbProperties();
            filePermissionKey = tempSmbProperties.getFilePermissionKey();
            String fileAttributes = NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
            String fileCreationTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
            String fileLastWriteTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
            String fileChangeTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
            smbInfo = new CopyFileSmbInfo().setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangeTime).setIgnoreReadOnly(options.isIgnoreReadOnly());
        }
        ShareFileAsyncClient destinationFileClient = this.getFileAsyncClient(options.getDestinationPath());
        ShareFileHttpHeaders headers = options.getContentType() == null ? null : new ShareFileHttpHeaders().setContentType(options.getContentType());
        String renameSource = Utility.encodeUrlPath((String)this.getFileUrl());
        renameSource = this.sasToken != null ? renameSource + "?" + this.sasToken.getSignature() : renameSource;
        return destinationFileClient.azureFileStorageClient.getFiles().renameWithResponseAsync(destinationFileClient.getShareName(), destinationFileClient.getFilePath(), renameSource, null, options.getReplaceIfExists(), options.isIgnoreReadOnly(), options.getFilePermission(), options.getFilePermissionFormat(), filePermissionKey, options.getMetadata(), sourceConditions, destinationConditions, smbInfo, headers, context).map(response -> new SimpleResponse((Response)response, (Object)destinationFileClient));
    }

    ShareFileAsyncClient getFileAsyncClient(String destinationPath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new ShareFileAsyncClient(this.azureFileStorageClient, this.getShareName(), destinationPath, null, this.getAccountName(), this.getServiceVersion(), this.getSasToken());
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.generateSas(shareServiceSasSignatureValues, null, context);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getFilePath()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileInfo> createHardLink(String targetFile) {
        return this.createHardLinkWithResponse(new ShareFileCreateHardLinkOptions(targetFile)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileInfo>> createHardLinkWithResponse(ShareFileCreateHardLinkOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return FluxUtil.withContext(context -> this.createHardLinkWithResponse(options.getTargetFile(), options.getRequestConditions(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileInfo>> createHardLinkWithResponse(String targetFile, ShareRequestConditions requestConditions, Context context) {
        context = context == null ? Context.NONE : context;
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        return this.azureFileStorageClient.getFiles().createHardLinkWithResponseAsync(this.shareName, this.filePath, targetFile, null, null, requestConditions.getLeaseId(), context).map(ModelHelper::createHardLinkResponse);
    }
}

