// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

/**
 * Defines values for OwnerCopyMode.
 */
public enum OwnerCopyMode {
    /**
     * Enum value source.
     */
    SOURCE("source"),

    /**
     * Enum value override.
     */
    OVERRIDE("override");

    /**
     * The actual serialized value for a OwnerCopyMode instance.
     */
    private final String value;

    OwnerCopyMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a OwnerCopyMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed OwnerCopyMode object, or null if unable to parse.
     */
    public static OwnerCopyMode fromString(String value) {
        if (value == null) {
            return null;
        }
        OwnerCopyMode[] items = OwnerCopyMode.values();
        for (OwnerCopyMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
