// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

/**
 * Defines values for ListFilesIncludeType.
 */
public enum ListFilesIncludeType {
    /**
     * Enum value Timestamps.
     */
    TIMESTAMPS("Timestamps"),

    /**
     * Enum value Etag.
     */
    ETAG("Etag"),

    /**
     * Enum value Attributes.
     */
    ATTRIBUTES("Attributes"),

    /**
     * Enum value PermissionKey.
     */
    PERMISSION_KEY("PermissionKey");

    /**
     * The actual serialized value for a ListFilesIncludeType instance.
     */
    private final String value;

    ListFilesIncludeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ListFilesIncludeType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ListFilesIncludeType object, or null if unable to parse.
     */
    public static ListFilesIncludeType fromString(String value) {
        if (value == null) {
            return null;
        }
        ListFilesIncludeType[] items = ListFilesIncludeType.values();
        for (ListFilesIncludeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
