/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.NfsFileType;
import java.time.OffsetDateTime;

public final class FilesCreateHardLinkHeaders {
    private String xMsGroup;
    private String xMsVersion;
    private String xMsFileId;
    private OffsetDateTime xMsFileCreationTime;
    private NfsFileType xMsFileFileType;
    private DateTimeRfc1123 lastModified;
    private DateTimeRfc1123 date;
    private String xMsMode;
    private String eTag;
    private Long xMsLinkCount;
    private OffsetDateTime xMsFileChangeTime;
    private String xMsFileParentId;
    private String xMsRequestId;
    private OffsetDateTime xMsFileLastWriteTime;
    private String xMsClientRequestId;
    private String xMsOwner;
    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString((String)"x-ms-group");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_FILE_ID = HttpHeaderName.fromString((String)"x-ms-file-id");
    private static final HttpHeaderName X_MS_FILE_CREATION_TIME = HttpHeaderName.fromString((String)"x-ms-file-creation-time");
    private static final HttpHeaderName X_MS_FILE_FILE_TYPE = HttpHeaderName.fromString((String)"x-ms-file-file-type");
    private static final HttpHeaderName X_MS_MODE = HttpHeaderName.fromString((String)"x-ms-mode");
    private static final HttpHeaderName X_MS_LINK_COUNT = HttpHeaderName.fromString((String)"x-ms-link-count");
    private static final HttpHeaderName X_MS_FILE_CHANGE_TIME = HttpHeaderName.fromString((String)"x-ms-file-change-time");
    private static final HttpHeaderName X_MS_FILE_PARENT_ID = HttpHeaderName.fromString((String)"x-ms-file-parent-id");
    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME = HttpHeaderName.fromString((String)"x-ms-file-last-write-time");
    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString((String)"x-ms-owner");

    public FilesCreateHardLinkHeaders(HttpHeaders rawHeaders) {
        String xMsFileChangeTime;
        String date;
        String lastModified;
        String xMsFileFileType;
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsFileId = rawHeaders.getValue(X_MS_FILE_ID);
        String xMsFileCreationTime = rawHeaders.getValue(X_MS_FILE_CREATION_TIME);
        if (xMsFileCreationTime != null) {
            this.xMsFileCreationTime = OffsetDateTime.parse(xMsFileCreationTime);
        }
        if ((xMsFileFileType = rawHeaders.getValue(X_MS_FILE_FILE_TYPE)) != null) {
            this.xMsFileFileType = NfsFileType.fromString(xMsFileFileType);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.xMsMode = rawHeaders.getValue(X_MS_MODE);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsLinkCount = rawHeaders.getValue(X_MS_LINK_COUNT);
        if (xMsLinkCount != null) {
            this.xMsLinkCount = Long.parseLong(xMsLinkCount);
        }
        if ((xMsFileChangeTime = rawHeaders.getValue(X_MS_FILE_CHANGE_TIME)) != null) {
            this.xMsFileChangeTime = OffsetDateTime.parse(xMsFileChangeTime);
        }
        this.xMsFileParentId = rawHeaders.getValue(X_MS_FILE_PARENT_ID);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME);
        if (xMsFileLastWriteTime != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
    }

    public String getXMsGroup() {
        return this.xMsGroup;
    }

    public FilesCreateHardLinkHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesCreateHardLinkHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsFileId() {
        return this.xMsFileId;
    }

    public FilesCreateHardLinkHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    public FilesCreateHardLinkHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    public NfsFileType getXMsFileFileType() {
        return this.xMsFileFileType;
    }

    public FilesCreateHardLinkHeaders setXMsFileFileType(NfsFileType xMsFileFileType) {
        this.xMsFileFileType = xMsFileFileType;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FilesCreateHardLinkHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesCreateHardLinkHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsMode() {
        return this.xMsMode;
    }

    public FilesCreateHardLinkHeaders setXMsMode(String xMsMode) {
        this.xMsMode = xMsMode;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FilesCreateHardLinkHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Long getXMsLinkCount() {
        return this.xMsLinkCount;
    }

    public FilesCreateHardLinkHeaders setXMsLinkCount(Long xMsLinkCount) {
        this.xMsLinkCount = xMsLinkCount;
        return this;
    }

    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    public FilesCreateHardLinkHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    public FilesCreateHardLinkHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesCreateHardLinkHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public FilesCreateHardLinkHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public FilesCreateHardLinkHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public String getXMsOwner() {
        return this.xMsOwner;
    }

    public FilesCreateHardLinkHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }
}

