// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.ShareSignedIdentifierWrapper;
import com.azure.storage.file.share.implementation.models.ShareStats;
import com.azure.storage.file.share.implementation.models.ShareStorageExceptionInternal;
import com.azure.storage.file.share.implementation.models.SharesAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesBreakLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.SharesDeleteHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsHeaders;
import com.azure.storage.file.share.implementation.models.SharesReleaseLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRenewLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRestoreHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.FilePermissionFormat;
import com.azure.storage.file.share.models.ShareAccessTier;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareTokenIntent;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Shares.
 */
public final class SharesImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final SharesService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureFileStorageImpl client;

    /**
     * Initializes an instance of SharesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    SharesImpl(AzureFileStorageImpl client) {
        this.service = RestProxy.create(SharesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureFileStorageShares to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureFileStorageShares")
    public interface SharesService {

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesCreateHeaders, Void>> create(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-share-quota") Integer quota, @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-enabled-protocols") String enabledProtocols,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> createNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-share-quota") Integer quota, @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-enabled-protocols") String enabledProtocols,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesCreateHeaders, Void> createSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-share-quota") Integer quota, @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-enabled-protocols") String enabledProtocols,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> createNoCustomHeadersSync(@HostParam("url") String url, @PathParam("shareName") String shareName,
            @QueryParam("restype") String restype, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-share-quota") Integer quota,
            @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-enabled-protocols") String enabledProtocols,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getProperties(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesGetPropertiesHeaders, Void> getPropertiesSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> getPropertiesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesDeleteHeaders, Void>> delete(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-delete-snapshots") DeleteSnapshotsOptionType deleteSnapshots,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> deleteNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-delete-snapshots") DeleteSnapshotsOptionType deleteSnapshots,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesDeleteHeaders, Void> deleteSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-delete-snapshots") DeleteSnapshotsOptionType deleteSnapshots,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> deleteNoCustomHeadersSync(@HostParam("url") String url, @PathParam("shareName") String shareName,
            @QueryParam("restype") String restype, @QueryParam("sharesnapshot") String sharesnapshot,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-delete-snapshots") DeleteSnapshotsOptionType deleteSnapshots,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLease(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> acquireLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesAcquireLeaseHeaders, Void> acquireLeaseSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> acquireLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLease(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> releaseLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesReleaseLeaseHeaders, Void> releaseLeaseSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> releaseLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLease(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> changeLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesChangeLeaseHeaders, Void> changeLeaseSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> changeLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version,
            @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLease(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> renewLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesRenewLeaseHeaders, Void> renewLeaseSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> renewLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLease(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> breakLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesBreakLeaseHeaders, Void> breakLeaseSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> breakLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("comp") String comp,
            @HeaderParam("x-ms-lease-action") String action, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("sharesnapshot") String sharesnapshot,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshot(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> createSnapshotNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesCreateSnapshotHeaders, Void> createSnapshotSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> createSnapshotNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermission(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/json") SharePermission sharePermission, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> createPermissionNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/json") SharePermission sharePermission, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesCreatePermissionHeaders, Void> createPermissionSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/json") SharePermission sharePermission, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> createPermissionNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/json") SharePermission sharePermission, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermission(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
            @HeaderParam("x-ms-file-permission-format") FilePermissionFormat filePermissionFormat,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<SharePermission>> getPermissionNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
            @HeaderParam("x-ms-file-permission-format") FilePermissionFormat filePermissionFormat,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesGetPermissionHeaders, SharePermission> getPermissionSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
            @HeaderParam("x-ms-file-permission-format") FilePermissionFormat filePermissionFormat,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<SharePermission> getPermissionNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
            @HeaderParam("x-ms-file-permission-format") FilePermissionFormat filePermissionFormat,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setProperties(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-share-quota") Integer quota,
            @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-share-quota") Integer quota,
            @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-share-quota") Integer quota,
            @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> setPropertiesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-share-quota") Integer quota,
            @HeaderParam("x-ms-access-tier") ShareAccessTier accessTier, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-root-squash") ShareRootSquash rootSquash,
            @HeaderParam("x-ms-enable-snapshot-virtual-directory-access") Boolean enableSnapshotVirtualDirectoryAccess,
            @HeaderParam("x-ms-share-paid-bursting-enabled") Boolean paidBurstingEnabled,
            @HeaderParam("x-ms-share-paid-bursting-max-bandwidth-mibps") Long paidBurstingMaxBandwidthMibps,
            @HeaderParam("x-ms-share-paid-bursting-max-iops") Long paidBurstingMaxIops,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("x-ms-share-provisioned-iops") Long shareProvisionedIops,
            @HeaderParam("x-ms-share-provisioned-bandwidth-mibps") Long shareProvisionedBandwidthMibps,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadata(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesSetMetadataHeaders, Void> setMetadataSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> setMetadataNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>> getAccessPolicy(
            @HostParam("url") String url, @PathParam("shareName") String shareName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<ShareSignedIdentifierWrapper>> getAccessPolicyNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper> getAccessPolicySync(
            @HostParam("url") String url, @PathParam("shareName") String shareName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<ShareSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareSignedIdentifierWrapper shareAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> setAccessPolicyNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareSignedIdentifierWrapper shareAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesSetAccessPolicyHeaders, Void> setAccessPolicySync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareSignedIdentifierWrapper shareAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> setAccessPolicyNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareSignedIdentifierWrapper shareAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatistics(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<ShareStats>> getStatisticsNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesGetStatisticsHeaders, ShareStats> getStatisticsSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{shareName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<ShareStats> getStatisticsNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<SharesRestoreHeaders, Void>> restore(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-share-name") String deletedShareName,
            @HeaderParam("x-ms-deleted-share-version") String deletedShareVersion,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> restoreNoCustomHeaders(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-share-name") String deletedShareName,
            @HeaderParam("x-ms-deleted-share-version") String deletedShareVersion,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<SharesRestoreHeaders, Void> restoreSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-share-name") String deletedShareName,
            @HeaderParam("x-ms-deleted-share-version") String deletedShareVersion,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{shareName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> restoreNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("shareName") String shareName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-share-name") String deletedShareName,
            @HeaderParam("x-ms-deleted-share-version") String deletedShareVersion,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateHeaders, Void>> createWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols,
        ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled,
        Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops,
        Long shareProvisionedBandwidthMibps) {
        return FluxUtil
            .withContext(context -> createWithResponseAsync(shareName, timeout, metadata, quota, accessTier,
                enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled,
                paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops,
                shareProvisionedBandwidthMibps, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateHeaders, Void>> createWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols,
        ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled,
        Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops,
        Long shareProvisionedBandwidthMibps, Context context) {
        final String restype = "share";
        final String accept = "application/xml";
        return service.create(this.client.getUrl(), shareName, restype, timeout, metadata, quota, accessTier,
            this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess,
            paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(),
            shareProvisionedIops, shareProvisionedBandwidthMibps, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota,
        ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash,
            enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
            paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps)
                .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota,
        ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        return createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash,
            enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
            paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, context)
                .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols,
        ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled,
        Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops,
        Long shareProvisionedBandwidthMibps) {
        return FluxUtil
            .withContext(context -> createNoCustomHeadersWithResponseAsync(shareName, timeout, metadata, quota,
                accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled,
                paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops,
                shareProvisionedBandwidthMibps, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols,
        ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled,
        Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops,
        Long shareProvisionedBandwidthMibps, Context context) {
        final String restype = "share";
        final String accept = "application/xml";
        return service.createNoCustomHeaders(this.client.getUrl(), shareName, restype, timeout, metadata, quota,
            accessTier, this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess,
            paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(),
            shareProvisionedIops, shareProvisionedBandwidthMibps, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesCreateHeaders, Void> createWithResponse(String shareName, Integer timeout,
        Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols,
        ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled,
        Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops,
        Long shareProvisionedBandwidthMibps, Context context) {
        try {
            final String restype = "share";
            final String accept = "application/xml";
            return service.createSync(this.client.getUrl(), shareName, restype, timeout, metadata, quota, accessTier,
                this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess,
                paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops,
                this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void create(String shareName, Integer timeout, Map<String, String> metadata, Integer quota,
        ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        createWithResponse(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash,
            enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
            paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, Context.NONE);
    }

    /**
     * Creates a new share under the specified account. If the share with the same name already exists, the operation
     * fails.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param enabledProtocols Protocols to enable on the share.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String shareName, Integer timeout,
        Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols,
        ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled,
        Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops,
        Long shareProvisionedBandwidthMibps, Context context) {
        try {
            final String restype = "share";
            final String accept = "application/xml";
            return service.createNoCustomHeadersSync(this.client.getUrl(), shareName, restype, timeout, metadata, quota,
                accessTier, this.client.getVersion(), enabledProtocols, rootSquash,
                enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
                paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops,
                shareProvisionedBandwidthMibps, accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName,
        String sharesnapshot, Integer timeout, String leaseId) {
        return FluxUtil
            .withContext(context -> getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName,
        String sharesnapshot, Integer timeout, String leaseId, Context context) {
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .getProperties(this.client.getUrl(), shareName, restype, sharesnapshot, timeout, this.client.getVersion(),
                leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        return getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId,
        Context context) {
        return getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot,
        Integer timeout, String leaseId) {
        return FluxUtil
            .withContext(context -> getPropertiesNoCustomHeadersWithResponseAsync(shareName, sharesnapshot, timeout,
                leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot,
        Integer timeout, String leaseId, Context context) {
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .getPropertiesNoCustomHeaders(this.client.getUrl(), shareName, restype, sharesnapshot, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesGetPropertiesHeaders, Void> getPropertiesWithResponse(String shareName,
        String sharesnapshot, Integer timeout, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String accept = "application/xml";
            return service.getPropertiesSync(this.client.getUrl(), shareName, restype, sharesnapshot, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void getProperties(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        getPropertiesWithResponse(shareName, sharesnapshot, timeout, leaseId, Context.NONE);
    }

    /**
     * Returns all user-defined metadata and system properties for the specified share or share snapshot. The data
     * returned does not include the share's list of files.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String shareName, String sharesnapshot,
        Integer timeout, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String accept = "application/xml";
            return service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, restype, sharesnapshot,
                timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String sharesnapshot,
        Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return FluxUtil.withContext(
            context -> deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String sharesnapshot,
        Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .delete(this.client.getUrl(), shareName, restype, sharesnapshot, timeout, this.client.getVersion(),
                deleteSnapshots, leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String sharesnapshot, Integer timeout,
        DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String sharesnapshot, Integer timeout,
        DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        return deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot,
        Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return FluxUtil
            .withContext(context -> deleteNoCustomHeadersWithResponseAsync(shareName, sharesnapshot, timeout,
                deleteSnapshots, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot,
        Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .deleteNoCustomHeaders(this.client.getUrl(), shareName, restype, sharesnapshot, timeout,
                this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesDeleteHeaders, Void> deleteWithResponse(String shareName, String sharesnapshot,
        Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String accept = "application/xml";
            return service.deleteSync(this.client.getUrl(), shareName, restype, sharesnapshot, timeout,
                this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String shareName, String sharesnapshot, Integer timeout,
        DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        deleteWithResponse(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, Context.NONE);
    }

    /**
     * Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files
     * contained within it are later deleted during garbage collection.
     *
     * @param shareName The name of the target share.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param deleteSnapshots Specifies the option include to delete the base share and all of its snapshots.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String shareName, String sharesnapshot, Integer timeout,
        DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String accept = "application/xml";
            return service.deleteNoCustomHeadersSync(this.client.getUrl(), shareName, restype, sharesnapshot, timeout,
                this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName,
        Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(context -> acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId,
                sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName,
        Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId,
        Context context) {
        final String comp = "lease";
        final String action = "acquire";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .acquireLease(this.client.getUrl(), shareName, comp, action, restype, timeout, duration, proposedLeaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId,
        String sharesnapshot, String requestId) {
        return acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId,
        String sharesnapshot, String requestId, Context context) {
        return acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId,
            context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(context -> acquireLeaseNoCustomHeadersWithResponseAsync(shareName, timeout, duration,
                proposedLeaseId, sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        final String comp = "lease";
        final String action = "acquire";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .acquireLeaseNoCustomHeaders(this.client.getUrl(), shareName, comp, action, restype, timeout, duration,
                proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(),
                accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesAcquireLeaseHeaders, Void> acquireLeaseWithResponse(String shareName, Integer timeout,
        Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "acquire";
            final String restype = "share";
            final String accept = "application/xml";
            return service.acquireLeaseSync(this.client.getUrl(), shareName, comp, action, restype, timeout, duration,
                proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(),
                accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void acquireLease(String shareName, Integer timeout, Integer duration, String proposedLeaseId,
        String sharesnapshot, String requestId) {
        acquireLeaseWithResponse(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId, Context.NONE);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> acquireLeaseNoCustomHeadersWithResponse(String shareName, Integer timeout, Integer duration,
        String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "acquire";
            final String restype = "share";
            final String accept = "application/xml";
            return service.acquireLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, comp, action, restype,
                timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName,
        String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(
            context -> releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName,
        String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        final String comp = "lease";
        final String action = "release";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .releaseLease(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot,
        String requestId) {
        return releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot,
        String requestId, Context context) {
        return releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId,
        Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(context -> releaseLeaseNoCustomHeadersWithResponseAsync(shareName, leaseId, timeout,
                sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId,
        Integer timeout, String sharesnapshot, String requestId, Context context) {
        final String comp = "lease";
        final String action = "release";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .releaseLeaseNoCustomHeaders(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesReleaseLeaseHeaders, Void> releaseLeaseWithResponse(String shareName, String leaseId,
        Integer timeout, String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "release";
            final String restype = "share";
            final String accept = "application/xml";
            return service.releaseLeaseSync(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void releaseLease(String shareName, String leaseId, Integer timeout, String sharesnapshot,
        String requestId) {
        releaseLeaseWithResponse(shareName, leaseId, timeout, sharesnapshot, requestId, Context.NONE);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> releaseLeaseNoCustomHeadersWithResponse(String shareName, String leaseId, Integer timeout,
        String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "release";
            final String restype = "share";
            final String accept = "application/xml";
            return service.releaseLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, comp, action, restype,
                timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName,
        String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(context -> changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId,
                sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName,
        String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId,
        Context context) {
        final String comp = "lease";
        final String action = "change";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .changeLease(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId, proposedLeaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId,
        String sharesnapshot, String requestId) {
        return changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId,
        String sharesnapshot, String requestId, Context context) {
        return changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId,
            context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId,
        Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(context -> changeLeaseNoCustomHeadersWithResponseAsync(shareName, leaseId, timeout,
                proposedLeaseId, sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId,
        Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        final String comp = "lease";
        final String action = "change";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .changeLeaseNoCustomHeaders(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(),
                accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesChangeLeaseHeaders, Void> changeLeaseWithResponse(String shareName, String leaseId,
        Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "change";
            final String restype = "share";
            final String accept = "application/xml";
            return service.changeLeaseSync(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(),
                accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void changeLease(String shareName, String leaseId, Integer timeout, String proposedLeaseId,
        String sharesnapshot, String requestId) {
        changeLeaseWithResponse(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId, Context.NONE);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> changeLeaseNoCustomHeadersWithResponse(String shareName, String leaseId, Integer timeout,
        String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "change";
            final String restype = "share";
            final String accept = "application/xml";
            return service.changeLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, comp, action, restype,
                timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String shareName,
        String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(
                context -> renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String shareName,
        String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        final String comp = "lease";
        final String action = "renew";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .renewLease(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot,
        String requestId) {
        return renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot,
        String requestId, Context context) {
        return renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId,
        Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil
            .withContext(context -> renewLeaseNoCustomHeadersWithResponseAsync(shareName, leaseId, timeout,
                sharesnapshot, requestId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId,
        Integer timeout, String sharesnapshot, String requestId, Context context) {
        final String comp = "lease";
        final String action = "renew";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .renewLeaseNoCustomHeaders(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesRenewLeaseHeaders, Void> renewLeaseWithResponse(String shareName, String leaseId,
        Integer timeout, String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "renew";
            final String restype = "share";
            final String accept = "application/xml";
            return service.renewLeaseSync(this.client.getUrl(), shareName, comp, action, restype, timeout, leaseId,
                this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void renewLease(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        renewLeaseWithResponse(shareName, leaseId, timeout, sharesnapshot, requestId, Context.NONE);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> renewLeaseNoCustomHeadersWithResponse(String shareName, String leaseId, Integer timeout,
        String sharesnapshot, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String action = "renew";
            final String restype = "share";
            final String accept = "application/xml";
            return service.renewLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, comp, action, restype,
                timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName,
        Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        return FluxUtil
            .withContext(context -> breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId,
                sharesnapshot, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName,
        Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        final String comp = "lease";
        final String action = "break";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .breakLease(this.client.getUrl(), shareName, comp, action, restype, timeout, breakPeriod, leaseId,
                this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId,
        String requestId, String sharesnapshot) {
        return breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId,
        String requestId, String sharesnapshot, Context context) {
        return breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        return FluxUtil
            .withContext(context -> breakLeaseNoCustomHeadersWithResponseAsync(shareName, timeout, breakPeriod, leaseId,
                requestId, sharesnapshot, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        final String comp = "lease";
        final String action = "break";
        final String restype = "share";
        final String accept = "application/xml";
        return service
            .breakLeaseNoCustomHeaders(this.client.getUrl(), shareName, comp, action, restype, timeout, breakPeriod,
                leaseId, this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), accept,
                context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesBreakLeaseHeaders, Void> breakLeaseWithResponse(String shareName, Integer timeout,
        Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        try {
            final String comp = "lease";
            final String action = "break";
            final String restype = "share";
            final String accept = "application/xml";
            return service.breakLeaseSync(this.client.getUrl(), shareName, comp, action, restype, timeout, breakPeriod,
                leaseId, this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void breakLease(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId,
        String sharesnapshot) {
        breakLeaseWithResponse(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, Context.NONE);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete
     * share operations.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     * snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> breakLeaseNoCustomHeadersWithResponse(String shareName, Integer timeout, Integer breakPeriod,
        String leaseId, String requestId, String sharesnapshot, Context context) {
        try {
            final String comp = "lease";
            final String action = "break";
            final String restype = "share";
            final String accept = "application/xml";
            return service.breakLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, comp, action, restype,
                timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshotWithResponseAsync(String shareName,
        Integer timeout, Map<String, String> metadata) {
        return FluxUtil.withContext(context -> createSnapshotWithResponseAsync(shareName, timeout, metadata, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshotWithResponseAsync(String shareName,
        Integer timeout, Map<String, String> metadata, Context context) {
        final String restype = "share";
        final String comp = "snapshot";
        final String accept = "application/xml";
        return service
            .createSnapshot(this.client.getUrl(), shareName, restype, comp, timeout, metadata, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createSnapshotAsync(String shareName, Integer timeout, Map<String, String> metadata) {
        return createSnapshotWithResponseAsync(shareName, timeout, metadata)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createSnapshotAsync(String shareName, Integer timeout, Map<String, String> metadata,
        Context context) {
        return createSnapshotWithResponseAsync(shareName, timeout, metadata, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createSnapshotNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata) {
        return FluxUtil
            .withContext(
                context -> createSnapshotNoCustomHeadersWithResponseAsync(shareName, timeout, metadata, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createSnapshotNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, Context context) {
        final String restype = "share";
        final String comp = "snapshot";
        final String accept = "application/xml";
        return service
            .createSnapshotNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout, metadata,
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesCreateSnapshotHeaders, Void> createSnapshotWithResponse(String shareName, Integer timeout,
        Map<String, String> metadata, Context context) {
        try {
            final String restype = "share";
            final String comp = "snapshot";
            final String accept = "application/xml";
            return service.createSnapshotSync(this.client.getUrl(), shareName, restype, comp, timeout, metadata,
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createSnapshot(String shareName, Integer timeout, Map<String, String> metadata) {
        createSnapshotWithResponse(shareName, timeout, metadata, Context.NONE);
    }

    /**
     * Creates a read-only snapshot of a share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createSnapshotNoCustomHeadersWithResponse(String shareName, Integer timeout,
        Map<String, String> metadata, Context context) {
        try {
            final String restype = "share";
            final String comp = "snapshot";
            final String accept = "application/xml";
            return service.createSnapshotNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                metadata, this.client.getVersion(), this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermissionWithResponseAsync(String shareName,
        SharePermission sharePermission, Integer timeout) {
        return FluxUtil
            .withContext(context -> createPermissionWithResponseAsync(shareName, sharePermission, timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermissionWithResponseAsync(String shareName,
        SharePermission sharePermission, Integer timeout, Context context) {
        final String restype = "share";
        final String comp = "filepermission";
        final String accept = "application/xml";
        return service
            .createPermission(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), sharePermission, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createPermissionAsync(String shareName, SharePermission sharePermission, Integer timeout) {
        return createPermissionWithResponseAsync(shareName, sharePermission, timeout)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createPermissionAsync(String shareName, SharePermission sharePermission, Integer timeout,
        Context context) {
        return createPermissionWithResponseAsync(shareName, sharePermission, timeout, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createPermissionNoCustomHeadersWithResponseAsync(String shareName,
        SharePermission sharePermission, Integer timeout) {
        return FluxUtil.withContext(
            context -> createPermissionNoCustomHeadersWithResponseAsync(shareName, sharePermission, timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createPermissionNoCustomHeadersWithResponseAsync(String shareName,
        SharePermission sharePermission, Integer timeout, Context context) {
        final String restype = "share";
        final String comp = "filepermission";
        final String accept = "application/xml";
        return service
            .createPermissionNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesCreatePermissionHeaders, Void> createPermissionWithResponse(String shareName,
        SharePermission sharePermission, Integer timeout, Context context) {
        try {
            final String restype = "share";
            final String comp = "filepermission";
            final String accept = "application/xml";
            return service.createPermissionSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createPermission(String shareName, SharePermission sharePermission, Integer timeout) {
        createPermissionWithResponse(shareName, sharePermission, timeout, Context.NONE);
    }

    /**
     * Create a permission (a security descriptor).
     *
     * @param shareName The name of the target share.
     * @param sharePermission A permission (a security descriptor) at the share level.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createPermissionNoCustomHeadersWithResponse(String shareName, SharePermission sharePermission,
        Integer timeout, Context context) {
        try {
            final String restype = "share";
            final String comp = "filepermission";
            final String accept = "application/xml";
            return service.createPermissionNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermissionWithResponseAsync(
        String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout) {
        return FluxUtil
            .withContext(context -> getPermissionWithResponseAsync(shareName, filePermissionKey, filePermissionFormat,
                timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermissionWithResponseAsync(
        String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout,
        Context context) {
        final String restype = "share";
        final String comp = "filepermission";
        final String accept = "application/json";
        return service
            .getPermission(this.client.getUrl(), shareName, restype, comp, filePermissionKey, filePermissionFormat,
                timeout, this.client.getVersion(), this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SharePermission> getPermissionAsync(String shareName, String filePermissionKey,
        FilePermissionFormat filePermissionFormat, Integer timeout) {
        return getPermissionWithResponseAsync(shareName, filePermissionKey, filePermissionFormat, timeout)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SharePermission> getPermissionAsync(String shareName, String filePermissionKey,
        FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        return getPermissionWithResponseAsync(shareName, filePermissionKey, filePermissionFormat, timeout, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SharePermission>> getPermissionNoCustomHeadersWithResponseAsync(String shareName,
        String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout) {
        return FluxUtil
            .withContext(context -> getPermissionNoCustomHeadersWithResponseAsync(shareName, filePermissionKey,
                filePermissionFormat, timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SharePermission>> getPermissionNoCustomHeadersWithResponseAsync(String shareName,
        String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        final String restype = "share";
        final String comp = "filepermission";
        final String accept = "application/json";
        return service
            .getPermissionNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, filePermissionKey,
                filePermissionFormat, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), accept,
                context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesGetPermissionHeaders, SharePermission> getPermissionWithResponse(String shareName,
        String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        try {
            final String restype = "share";
            final String comp = "filepermission";
            final String accept = "application/json";
            return service.getPermissionSync(this.client.getUrl(), shareName, restype, comp, filePermissionKey,
                filePermissionFormat, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SharePermission getPermission(String shareName, String filePermissionKey,
        FilePermissionFormat filePermissionFormat, Integer timeout) {
        try {
            return getPermissionWithResponse(shareName, filePermissionKey, filePermissionFormat, timeout, Context.NONE)
                .getValue();
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns the permission (security descriptor) for a given key.
     *
     * @param shareName The name of the target share.
     * @param filePermissionKey Key of the permission to be set for the directory/file.
     * @param filePermissionFormat Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified
     * or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is
     * explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the
     * permission.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a permission (a security descriptor) at the share level along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SharePermission> getPermissionNoCustomHeadersWithResponse(String shareName,
        String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        try {
            final String restype = "share";
            final String comp = "filepermission";
            final String accept = "application/json";
            return service.getPermissionNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp,
                filePermissionKey, filePermissionFormat, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName,
        Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return FluxUtil
            .withContext(context -> setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId,
                rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
                paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName,
        Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        final String restype = "share";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .setProperties(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(), quota,
                accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled,
                paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(),
                shareProvisionedIops, shareProvisionedBandwidthMibps, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier,
        String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess,
        Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops,
        Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash,
            enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
            paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps)
                .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier,
        String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess,
        Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops,
        Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        return setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash,
            enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
            paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, context)
                .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return FluxUtil
            .withContext(context -> setPropertiesNoCustomHeadersWithResponseAsync(shareName, timeout, quota, accessTier,
                leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled,
                paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops,
                shareProvisionedBandwidthMibps, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        final String restype = "share";
        final String comp = "properties";
        final String accept = "application/xml";
        return service.setPropertiesNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout,
            this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess,
            paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(),
            shareProvisionedIops, shareProvisionedBandwidthMibps, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesSetPropertiesHeaders, Void> setPropertiesWithResponse(String shareName, Integer timeout,
        Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        try {
            final String restype = "share";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.setPropertiesSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess,
                paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops,
                this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setProperties(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier,
        String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess,
        Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops,
        Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        setPropertiesWithResponse(shareName, timeout, quota, accessTier, leaseId, rootSquash,
            enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps,
            paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, Context.NONE);
    }

    /**
     * Sets properties for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param quota Specifies the maximum size of the share, in gigabytes.
     * @param accessTier Specifies the access tier of the share.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param rootSquash Root squash to set on the share. Only valid for NFS shares.
     * @param enableSnapshotVirtualDirectoryAccess The enableSnapshotVirtualDirectoryAccess parameter.
     * @param paidBurstingEnabled Optional. Boolean. Default if not specified is false. This property enables paid
     * bursting.
     * @param paidBurstingMaxBandwidthMibps Optional. Integer. Default if not specified is the maximum throughput the
     * file share can support. Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxIops Optional. Integer. Default if not specified is the maximum IOPS the file share can
     * support. Current maximum for a file share is 102,400 IOPS.
     * @param shareProvisionedIops Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2
     * file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this
     * is not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
     * @param shareProvisionedBandwidthMibps Optional. Supported in version 2025-01-05 and later. Only allowed for
     * provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If
     * this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(String shareName, Integer timeout, Integer quota,
        ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash,
        Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps,
        Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        try {
            final String restype = "share";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess,
                paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops,
                this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName,
        Integer timeout, Map<String, String> metadata, String leaseId) {
        return FluxUtil
            .withContext(context -> setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName,
        Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        final String restype = "share";
        final String comp = "metadata";
        final String accept = "application/xml";
        return service
            .setMetadata(this.client.getUrl(), shareName, restype, comp, timeout, metadata, this.client.getVersion(),
                leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, Integer timeout, Map<String, String> metadata,
        String leaseId) {
        return setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId,
        Context context) {
        return setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, String leaseId) {
        return FluxUtil
            .withContext(
                context -> setMetadataNoCustomHeadersWithResponseAsync(shareName, timeout, metadata, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        Map<String, String> metadata, String leaseId, Context context) {
        final String restype = "share";
        final String comp = "metadata";
        final String accept = "application/xml";
        return service
            .setMetadataNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout, metadata,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesSetMetadataHeaders, Void> setMetadataWithResponse(String shareName, Integer timeout,
        Map<String, String> metadata, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String comp = "metadata";
            final String accept = "application/xml";
            return service.setMetadataSync(this.client.getUrl(), shareName, restype, comp, timeout, metadata,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setMetadata(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        setMetadataWithResponse(shareName, timeout, metadata, leaseId, Context.NONE);
    }

    /**
     * Sets one or more user-defined name-value pairs for the specified share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String shareName, Integer timeout,
        Map<String, String> metadata, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String comp = "metadata";
            final String accept = "application/xml";
            return service.setMetadataNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                metadata, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>>
        getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> getAccessPolicyWithResponseAsync(shareName, timeout, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>>
        getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        final String restype = "share";
        final String comp = "acl";
        final String accept = "application/xml";
        return service
            .getAccessPolicy(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(), leaseId,
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ShareSignedIdentifierWrapper> getAccessPolicyAsync(String shareName, Integer timeout, String leaseId) {
        return getAccessPolicyWithResponseAsync(shareName, timeout, leaseId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ShareSignedIdentifierWrapper> getAccessPolicyAsync(String shareName, Integer timeout, String leaseId,
        Context context) {
        return getAccessPolicyWithResponseAsync(shareName, timeout, leaseId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ShareSignedIdentifierWrapper>>
        getAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        return FluxUtil
            .withContext(
                context -> getAccessPolicyNoCustomHeadersWithResponseAsync(shareName, timeout, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ShareSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(
        String shareName, Integer timeout, String leaseId, Context context) {
        final String restype = "share";
        final String comp = "acl";
        final String accept = "application/xml";
        return service
            .getAccessPolicyNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>
        getAccessPolicyWithResponse(String shareName, Integer timeout, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String comp = "acl";
            final String accept = "application/xml";
            return service.getAccessPolicySync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ShareSignedIdentifierWrapper getAccessPolicy(String shareName, Integer timeout, String leaseId) {
        try {
            return getAccessPolicyWithResponse(shareName, timeout, leaseId, Context.NONE).getValue();
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Returns information about stored access policies specified on the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ShareSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersWithResponse(String shareName,
        Integer timeout, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String comp = "acl";
            final String accept = "application/xml";
            return service.getAccessPolicyNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String shareName,
        Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        return FluxUtil
            .withContext(context -> setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String shareName,
        Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        final String restype = "share";
        final String comp = "acl";
        final String accept = "application/xml";
        ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
        return service
            .setAccessPolicy(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(), leaseId,
                this.client.getFileRequestIntent(), shareAclConverted, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String shareName, Integer timeout, String leaseId,
        List<ShareSignedIdentifier> shareAcl) {
        return setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String shareName, Integer timeout, String leaseId,
        List<ShareSignedIdentifier> shareAcl, Context context) {
        return setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        String leaseId, List<ShareSignedIdentifier> shareAcl) {
        return FluxUtil.withContext(
            context -> setAccessPolicyNoCustomHeadersWithResponseAsync(shareName, timeout, leaseId, shareAcl, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        final String restype = "share";
        final String comp = "acl";
        final String accept = "application/xml";
        ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
        return service.setAccessPolicyNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout,
            this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesSetAccessPolicyHeaders, Void> setAccessPolicyWithResponse(String shareName,
        Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        try {
            final String restype = "share";
            final String comp = "acl";
            final String accept = "application/xml";
            ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
            return service.setAccessPolicySync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setAccessPolicy(String shareName, Integer timeout, String leaseId,
        List<ShareSignedIdentifier> shareAcl) {
        setAccessPolicyWithResponse(shareName, timeout, leaseId, shareAcl, Context.NONE);
    }

    /**
     * Sets a stored access policy for use with shared access signatures.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareAcl The ACL for the share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setAccessPolicyNoCustomHeadersWithResponse(String shareName, Integer timeout, String leaseId,
        List<ShareSignedIdentifier> shareAcl, Context context) {
        try {
            final String restype = "share";
            final String comp = "acl";
            final String accept = "application/xml";
            ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
            return service.setAccessPolicyNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, accept,
                context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatisticsWithResponseAsync(String shareName,
        Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> getStatisticsWithResponseAsync(shareName, timeout, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatisticsWithResponseAsync(String shareName,
        Integer timeout, String leaseId, Context context) {
        final String restype = "share";
        final String comp = "stats";
        final String accept = "application/xml";
        return service
            .getStatistics(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(), leaseId,
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ShareStats> getStatisticsAsync(String shareName, Integer timeout, String leaseId) {
        return getStatisticsWithResponseAsync(shareName, timeout, leaseId)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ShareStats> getStatisticsAsync(String shareName, Integer timeout, String leaseId, Context context) {
        return getStatisticsWithResponseAsync(shareName, timeout, leaseId, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ShareStats>> getStatisticsNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        String leaseId) {
        return FluxUtil
            .withContext(context -> getStatisticsNoCustomHeadersWithResponseAsync(shareName, timeout, leaseId, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ShareStats>> getStatisticsNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        String leaseId, Context context) {
        final String restype = "share";
        final String comp = "stats";
        final String accept = "application/xml";
        return service
            .getStatisticsNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesGetStatisticsHeaders, ShareStats> getStatisticsWithResponse(String shareName,
        Integer timeout, String leaseId, Context context) {
        try {
            final String restype = "share";
            final String comp = "stats";
            final String accept = "application/xml";
            return service.getStatisticsSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ShareStats getStatistics(String shareName, Integer timeout, String leaseId) {
        try {
            return getStatisticsWithResponse(shareName, timeout, leaseId, Context.NONE).getValue();
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Retrieves statistics related to the share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return stats for the share along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ShareStats> getStatisticsNoCustomHeadersWithResponse(String shareName, Integer timeout,
        String leaseId, Context context) {
        try {
            final String restype = "share";
            final String comp = "stats";
            final String accept = "application/xml";
            return service.getStatisticsNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRestoreHeaders, Void>> restoreWithResponseAsync(String shareName, Integer timeout,
        String requestId, String deletedShareName, String deletedShareVersion) {
        return FluxUtil
            .withContext(context -> restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName,
                deletedShareVersion, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRestoreHeaders, Void>> restoreWithResponseAsync(String shareName, Integer timeout,
        String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        final String restype = "share";
        final String comp = "undelete";
        final String accept = "application/xml";
        return service
            .restore(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(), requestId,
                deletedShareName, deletedShareVersion, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String shareName, Integer timeout, String requestId, String deletedShareName,
        String deletedShareVersion) {
        return restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String shareName, Integer timeout, String requestId, String deletedShareName,
        String deletedShareVersion, Context context) {
        return restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        String requestId, String deletedShareName, String deletedShareVersion) {
        return FluxUtil
            .withContext(context -> restoreNoCustomHeadersWithResponseAsync(shareName, timeout, requestId,
                deletedShareName, deletedShareVersion, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String shareName, Integer timeout,
        String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        final String restype = "share";
        final String comp = "undelete";
        final String accept = "application/xml";
        return service
            .restoreNoCustomHeaders(this.client.getUrl(), shareName, restype, comp, timeout, this.client.getVersion(),
                requestId, deletedShareName, deletedShareVersion, this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<SharesRestoreHeaders, Void> restoreWithResponse(String shareName, Integer timeout,
        String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        try {
            final String restype = "share";
            final String comp = "undelete";
            final String accept = "application/xml";
            return service.restoreSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), requestId, deletedShareName, deletedShareVersion,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restore(String shareName, Integer timeout, String requestId, String deletedShareName,
        String deletedShareVersion) {
        restoreWithResponse(shareName, timeout, requestId, deletedShareName, deletedShareVersion, Context.NONE);
    }

    /**
     * Restores a previously deleted Share.
     *
     * @param shareName The name of the target share.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedShareName Specifies the name of the previously-deleted share.
     * @param deletedShareVersion Specifies the version of the previously-deleted share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> restoreNoCustomHeadersWithResponse(String shareName, Integer timeout, String requestId,
        String deletedShareName, String deletedShareVersion, Context context) {
        try {
            final String restype = "share";
            final String comp = "undelete";
            final String accept = "application/xml";
            return service.restoreNoCustomHeadersSync(this.client.getUrl(), shareName, restype, comp, timeout,
                this.client.getVersion(), requestId, deletedShareName, deletedShareVersion,
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }
}
