// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * The FilesDownloadHeaders model.
 */
@Fluent
public final class FilesDownloadHeaders {
    /*
     * The x-ms-file-id property.
     */
    @Generated
    private String xMsFileId;

    /*
     * The x-ms-lease-status property.
     */
    @Generated
    private LeaseStatusType xMsLeaseStatus;

    /*
     * The x-ms-file-creation-time property.
     */
    @Generated
    private OffsetDateTime xMsFileCreationTime;

    /*
     * The Content-Range property.
     */
    @Generated
    private String contentRange;

    /*
     * The x-ms-lease-state property.
     */
    @Generated
    private LeaseStateType xMsLeaseState;

    /*
     * The x-ms-content-md5 property.
     */
    @Generated
    private byte[] xMsContentMd5;

    /*
     * The Last-Modified property.
     */
    @Generated
    private DateTimeRfc1123 lastModified;

    /*
     * The x-ms-structured-body property.
     */
    @Generated
    private String xMsStructuredBody;

    /*
     * The x-ms-mode property.
     */
    @Generated
    private String xMsMode;

    /*
     * The x-ms-file-attributes property.
     */
    @Generated
    private String xMsFileAttributes;

    /*
     * The x-ms-structured-content-length property.
     */
    @Generated
    private Long xMsStructuredContentLength;

    /*
     * The Content-Encoding property.
     */
    @Generated
    private String contentEncoding;

    /*
     * The x-ms-copy-status-description property.
     */
    @Generated
    private String xMsCopyStatusDescription;

    /*
     * The x-ms-lease-duration property.
     */
    @Generated
    private LeaseDurationType xMsLeaseDuration;

    /*
     * The Content-Length property.
     */
    @Generated
    private Long contentLength;

    /*
     * The x-ms-request-id property.
     */
    @Generated
    private String xMsRequestId;

    /*
     * The x-ms-owner property.
     */
    @Generated
    private String xMsOwner;

    /*
     * The Content-Type property.
     */
    @Generated
    private String contentType;

    /*
     * The x-ms-group property.
     */
    @Generated
    private String xMsGroup;

    /*
     * The x-ms-version property.
     */
    @Generated
    private String xMsVersion;

    /*
     * The x-ms-file-permission-key property.
     */
    @Generated
    private String xMsFilePermissionKey;

    /*
     * The x-ms-copy-id property.
     */
    @Generated
    private String xMsCopyId;

    /*
     * The x-ms-copy-source property.
     */
    @Generated
    private String xMsCopySource;

    /*
     * The x-ms-copy-progress property.
     */
    @Generated
    private String xMsCopyProgress;

    /*
     * The x-ms-meta- property.
     */
    @Generated
    private Map<String, String> xMsMeta;

    /*
     * The Date property.
     */
    @Generated
    private DateTimeRfc1123 date;

    /*
     * The Content-MD5 property.
     */
    @Generated
    private byte[] contentMD5;

    /*
     * The Accept-Ranges property.
     */
    @Generated
    private String acceptRanges;

    /*
     * The x-ms-copy-completion-time property.
     */
    @Generated
    private DateTimeRfc1123 xMsCopyCompletionTime;

    /*
     * The x-ms-server-encrypted property.
     */
    @Generated
    private Boolean xMsServerEncrypted;

    /*
     * The Cache-Control property.
     */
    @Generated
    private String cacheControl;

    /*
     * The ETag property.
     */
    @Generated
    private String eTag;

    /*
     * The x-ms-link-count property.
     */
    @Generated
    private Long xMsLinkCount;

    /*
     * The Content-Disposition property.
     */
    @Generated
    private String contentDisposition;

    /*
     * The x-ms-file-change-time property.
     */
    @Generated
    private OffsetDateTime xMsFileChangeTime;

    /*
     * The x-ms-file-parent-id property.
     */
    @Generated
    private String xMsFileParentId;

    /*
     * The x-ms-copy-status property.
     */
    @Generated
    private CopyStatusType xMsCopyStatus;

    /*
     * The Content-Language property.
     */
    @Generated
    private String contentLanguage;

    /*
     * The x-ms-file-last-write-time property.
     */
    @Generated
    private OffsetDateTime xMsFileLastWriteTime;

    private static final HttpHeaderName X_MS_FILE_ID = HttpHeaderName.fromString("x-ms-file-id");

    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString("x-ms-lease-status");

    private static final HttpHeaderName X_MS_FILE_CREATION_TIME = HttpHeaderName.fromString("x-ms-file-creation-time");

    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString("x-ms-lease-state");

    private static final HttpHeaderName X_MS_CONTENT_MD5 = HttpHeaderName.fromString("x-ms-content-md5");

    private static final HttpHeaderName X_MS_STRUCTURED_BODY = HttpHeaderName.fromString("x-ms-structured-body");

    private static final HttpHeaderName X_MS_MODE = HttpHeaderName.fromString("x-ms-mode");

    private static final HttpHeaderName X_MS_FILE_ATTRIBUTES = HttpHeaderName.fromString("x-ms-file-attributes");

    private static final HttpHeaderName X_MS_STRUCTURED_CONTENT_LENGTH
        = HttpHeaderName.fromString("x-ms-structured-content-length");

    private static final HttpHeaderName X_MS_COPY_STATUS_DESCRIPTION
        = HttpHeaderName.fromString("x-ms-copy-status-description");

    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString("x-ms-lease-duration");

    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString("x-ms-owner");

    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString("x-ms-group");

    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");

    private static final HttpHeaderName X_MS_FILE_PERMISSION_KEY
        = HttpHeaderName.fromString("x-ms-file-permission-key");

    private static final HttpHeaderName X_MS_COPY_ID = HttpHeaderName.fromString("x-ms-copy-id");

    private static final HttpHeaderName X_MS_COPY_SOURCE = HttpHeaderName.fromString("x-ms-copy-source");

    private static final HttpHeaderName X_MS_COPY_PROGRESS = HttpHeaderName.fromString("x-ms-copy-progress");

    private static final HttpHeaderName X_MS_COPY_COMPLETION_TIME
        = HttpHeaderName.fromString("x-ms-copy-completion-time");

    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString("x-ms-server-encrypted");

    private static final HttpHeaderName X_MS_LINK_COUNT = HttpHeaderName.fromString("x-ms-link-count");

    private static final HttpHeaderName X_MS_FILE_CHANGE_TIME = HttpHeaderName.fromString("x-ms-file-change-time");

    private static final HttpHeaderName X_MS_FILE_PARENT_ID = HttpHeaderName.fromString("x-ms-file-parent-id");

    private static final HttpHeaderName X_MS_COPY_STATUS = HttpHeaderName.fromString("x-ms-copy-status");

    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME
        = HttpHeaderName.fromString("x-ms-file-last-write-time");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of FilesDownloadHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public FilesDownloadHeaders(HttpHeaders rawHeaders) {
        this.xMsFileId = rawHeaders.getValue(X_MS_FILE_ID);
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        if (xMsLeaseStatus != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(xMsLeaseStatus);
        } else {
            this.xMsLeaseStatus = null;
        }
        String xMsFileCreationTime = rawHeaders.getValue(X_MS_FILE_CREATION_TIME);
        if (xMsFileCreationTime != null) {
            this.xMsFileCreationTime = OffsetDateTime.parse(xMsFileCreationTime);
        } else {
            this.xMsFileCreationTime = null;
        }
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        String xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        if (xMsLeaseState != null) {
            this.xMsLeaseState = LeaseStateType.fromString(xMsLeaseState);
        } else {
            this.xMsLeaseState = null;
        }
        String xMsContentMd5 = rawHeaders.getValue(X_MS_CONTENT_MD5);
        if (xMsContentMd5 != null) {
            this.xMsContentMd5 = Base64.getDecoder().decode(xMsContentMd5);
        } else {
            this.xMsContentMd5 = null;
        }
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        } else {
            this.lastModified = null;
        }
        this.xMsStructuredBody = rawHeaders.getValue(X_MS_STRUCTURED_BODY);
        this.xMsMode = rawHeaders.getValue(X_MS_MODE);
        this.xMsFileAttributes = rawHeaders.getValue(X_MS_FILE_ATTRIBUTES);
        String xMsStructuredContentLength = rawHeaders.getValue(X_MS_STRUCTURED_CONTENT_LENGTH);
        if (xMsStructuredContentLength != null) {
            this.xMsStructuredContentLength = Long.parseLong(xMsStructuredContentLength);
        } else {
            this.xMsStructuredContentLength = null;
        }
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        this.xMsCopyStatusDescription = rawHeaders.getValue(X_MS_COPY_STATUS_DESCRIPTION);
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        if (xMsLeaseDuration != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(xMsLeaseDuration);
        } else {
            this.xMsLeaseDuration = null;
        }
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (contentLength != null) {
            this.contentLength = Long.parseLong(contentLength);
        } else {
            this.contentLength = null;
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsFilePermissionKey = rawHeaders.getValue(X_MS_FILE_PERMISSION_KEY);
        this.xMsCopyId = rawHeaders.getValue(X_MS_COPY_ID);
        this.xMsCopySource = rawHeaders.getValue(X_MS_COPY_SOURCE);
        this.xMsCopyProgress = rawHeaders.getValue(X_MS_COPY_PROGRESS);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        } else {
            this.date = null;
        }
        String contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5);
        if (contentMD5 != null) {
            this.contentMD5 = Base64.getDecoder().decode(contentMD5);
        } else {
            this.contentMD5 = null;
        }
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        String xMsCopyCompletionTime = rawHeaders.getValue(X_MS_COPY_COMPLETION_TIME);
        if (xMsCopyCompletionTime != null) {
            this.xMsCopyCompletionTime = new DateTimeRfc1123(xMsCopyCompletionTime);
        } else {
            this.xMsCopyCompletionTime = null;
        }
        String xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED);
        if (xMsServerEncrypted != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(xMsServerEncrypted);
        } else {
            this.xMsServerEncrypted = null;
        }
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsLinkCount = rawHeaders.getValue(X_MS_LINK_COUNT);
        if (xMsLinkCount != null) {
            this.xMsLinkCount = Long.parseLong(xMsLinkCount);
        } else {
            this.xMsLinkCount = null;
        }
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        String xMsFileChangeTime = rawHeaders.getValue(X_MS_FILE_CHANGE_TIME);
        if (xMsFileChangeTime != null) {
            this.xMsFileChangeTime = OffsetDateTime.parse(xMsFileChangeTime);
        } else {
            this.xMsFileChangeTime = null;
        }
        this.xMsFileParentId = rawHeaders.getValue(X_MS_FILE_PARENT_ID);
        String xMsCopyStatus = rawHeaders.getValue(X_MS_COPY_STATUS);
        if (xMsCopyStatus != null) {
            this.xMsCopyStatus = CopyStatusType.fromString(xMsCopyStatus);
        } else {
            this.xMsCopyStatus = null;
        }
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        String xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME);
        if (xMsFileLastWriteTime != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        } else {
            this.xMsFileLastWriteTime = null;
        }
        Map<String, String> xMsMetaHeaderCollection = new LinkedHashMap<>();

        rawHeaders.stream().forEach(header -> {
            String headerName = header.getName();
            if (headerName.startsWith("x-ms-meta-")) {
                xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
            }
        });
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    /**
     * Get the xMsFileId property: The x-ms-file-id property.
     * 
     * @return the xMsFileId value.
     */
    @Generated
    public String getXMsFileId() {
        return this.xMsFileId;
    }

    /**
     * Set the xMsFileId property: The x-ms-file-id property.
     * 
     * @param xMsFileId the xMsFileId value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    /**
     * Get the xMsLeaseStatus property: The x-ms-lease-status property.
     * 
     * @return the xMsLeaseStatus value.
     */
    @Generated
    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    /**
     * Set the xMsLeaseStatus property: The x-ms-lease-status property.
     * 
     * @param xMsLeaseStatus the xMsLeaseStatus value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    /**
     * Get the xMsFileCreationTime property: The x-ms-file-creation-time property.
     * 
     * @return the xMsFileCreationTime value.
     */
    @Generated
    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    /**
     * Set the xMsFileCreationTime property: The x-ms-file-creation-time property.
     * 
     * @param xMsFileCreationTime the xMsFileCreationTime value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    /**
     * Get the contentRange property: The Content-Range property.
     * 
     * @return the contentRange value.
     */
    @Generated
    public String getContentRange() {
        return this.contentRange;
    }

    /**
     * Set the contentRange property: The Content-Range property.
     * 
     * @param contentRange the contentRange value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    /**
     * Get the xMsLeaseState property: The x-ms-lease-state property.
     * 
     * @return the xMsLeaseState value.
     */
    @Generated
    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    /**
     * Set the xMsLeaseState property: The x-ms-lease-state property.
     * 
     * @param xMsLeaseState the xMsLeaseState value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    /**
     * Get the xMsContentMd5 property: The x-ms-content-md5 property.
     * 
     * @return the xMsContentMd5 value.
     */
    @Generated
    public byte[] getXMsContentMd5() {
        return CoreUtils.clone(this.xMsContentMd5);
    }

    /**
     * Set the xMsContentMd5 property: The x-ms-content-md5 property.
     * 
     * @param xMsContentMd5 the xMsContentMd5 value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsContentMd5(byte[] xMsContentMd5) {
        this.xMsContentMd5 = CoreUtils.clone(xMsContentMd5);
        return this;
    }

    /**
     * Get the lastModified property: The Last-Modified property.
     * 
     * @return the lastModified value.
     */
    @Generated
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The Last-Modified property.
     * 
     * @param lastModified the lastModified value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the xMsStructuredBody property: The x-ms-structured-body property.
     * 
     * @return the xMsStructuredBody value.
     */
    @Generated
    public String getXMsStructuredBody() {
        return this.xMsStructuredBody;
    }

    /**
     * Set the xMsStructuredBody property: The x-ms-structured-body property.
     * 
     * @param xMsStructuredBody the xMsStructuredBody value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsStructuredBody(String xMsStructuredBody) {
        this.xMsStructuredBody = xMsStructuredBody;
        return this;
    }

    /**
     * Get the xMsMode property: The x-ms-mode property.
     * 
     * @return the xMsMode value.
     */
    @Generated
    public String getXMsMode() {
        return this.xMsMode;
    }

    /**
     * Set the xMsMode property: The x-ms-mode property.
     * 
     * @param xMsMode the xMsMode value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsMode(String xMsMode) {
        this.xMsMode = xMsMode;
        return this;
    }

    /**
     * Get the xMsFileAttributes property: The x-ms-file-attributes property.
     * 
     * @return the xMsFileAttributes value.
     */
    @Generated
    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    /**
     * Set the xMsFileAttributes property: The x-ms-file-attributes property.
     * 
     * @param xMsFileAttributes the xMsFileAttributes value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    /**
     * Get the xMsStructuredContentLength property: The x-ms-structured-content-length property.
     * 
     * @return the xMsStructuredContentLength value.
     */
    @Generated
    public Long getXMsStructuredContentLength() {
        return this.xMsStructuredContentLength;
    }

    /**
     * Set the xMsStructuredContentLength property: The x-ms-structured-content-length property.
     * 
     * @param xMsStructuredContentLength the xMsStructuredContentLength value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsStructuredContentLength(Long xMsStructuredContentLength) {
        this.xMsStructuredContentLength = xMsStructuredContentLength;
        return this;
    }

    /**
     * Get the contentEncoding property: The Content-Encoding property.
     * 
     * @return the contentEncoding value.
     */
    @Generated
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    /**
     * Set the contentEncoding property: The Content-Encoding property.
     * 
     * @param contentEncoding the contentEncoding value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    /**
     * Get the xMsCopyStatusDescription property: The x-ms-copy-status-description property.
     * 
     * @return the xMsCopyStatusDescription value.
     */
    @Generated
    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    /**
     * Set the xMsCopyStatusDescription property: The x-ms-copy-status-description property.
     * 
     * @param xMsCopyStatusDescription the xMsCopyStatusDescription value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    /**
     * Get the xMsLeaseDuration property: The x-ms-lease-duration property.
     * 
     * @return the xMsLeaseDuration value.
     */
    @Generated
    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    /**
     * Set the xMsLeaseDuration property: The x-ms-lease-duration property.
     * 
     * @param xMsLeaseDuration the xMsLeaseDuration value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    /**
     * Get the contentLength property: The Content-Length property.
     * 
     * @return the contentLength value.
     */
    @Generated
    public Long getContentLength() {
        return this.contentLength;
    }

    /**
     * Set the contentLength property: The Content-Length property.
     * 
     * @param contentLength the contentLength value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     * 
     * @return the xMsRequestId value.
     */
    @Generated
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     * 
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the xMsOwner property: The x-ms-owner property.
     * 
     * @return the xMsOwner value.
     */
    @Generated
    public String getXMsOwner() {
        return this.xMsOwner;
    }

    /**
     * Set the xMsOwner property: The x-ms-owner property.
     * 
     * @param xMsOwner the xMsOwner value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }

    /**
     * Get the contentType property: The Content-Type property.
     * 
     * @return the contentType value.
     */
    @Generated
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The Content-Type property.
     * 
     * @param contentType the contentType value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the xMsGroup property: The x-ms-group property.
     * 
     * @return the xMsGroup value.
     */
    @Generated
    public String getXMsGroup() {
        return this.xMsGroup;
    }

    /**
     * Set the xMsGroup property: The x-ms-group property.
     * 
     * @param xMsGroup the xMsGroup value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     * 
     * @return the xMsVersion value.
     */
    @Generated
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     * 
     * @param xMsVersion the xMsVersion value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsFilePermissionKey property: The x-ms-file-permission-key property.
     * 
     * @return the xMsFilePermissionKey value.
     */
    @Generated
    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    /**
     * Set the xMsFilePermissionKey property: The x-ms-file-permission-key property.
     * 
     * @param xMsFilePermissionKey the xMsFilePermissionKey value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    /**
     * Get the xMsCopyId property: The x-ms-copy-id property.
     * 
     * @return the xMsCopyId value.
     */
    @Generated
    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    /**
     * Set the xMsCopyId property: The x-ms-copy-id property.
     * 
     * @param xMsCopyId the xMsCopyId value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    /**
     * Get the xMsCopySource property: The x-ms-copy-source property.
     * 
     * @return the xMsCopySource value.
     */
    @Generated
    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    /**
     * Set the xMsCopySource property: The x-ms-copy-source property.
     * 
     * @param xMsCopySource the xMsCopySource value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    /**
     * Get the xMsCopyProgress property: The x-ms-copy-progress property.
     * 
     * @return the xMsCopyProgress value.
     */
    @Generated
    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    /**
     * Set the xMsCopyProgress property: The x-ms-copy-progress property.
     * 
     * @param xMsCopyProgress the xMsCopyProgress value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    /**
     * Get the xMsMeta property: The x-ms-meta- property.
     * 
     * @return the xMsMeta value.
     */
    @Generated
    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    /**
     * Set the xMsMeta property: The x-ms-meta- property.
     * 
     * @param xMsMeta the xMsMeta value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    /**
     * Get the date property: The Date property.
     * 
     * @return the date value.
     */
    @Generated
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     * 
     * @param date the date value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }

    /**
     * Get the contentMD5 property: The Content-MD5 property.
     * 
     * @return the contentMD5 value.
     */
    @Generated
    public byte[] getContentMD5() {
        return CoreUtils.clone(this.contentMD5);
    }

    /**
     * Set the contentMD5 property: The Content-MD5 property.
     * 
     * @param contentMD5 the contentMD5 value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone(contentMD5);
        return this;
    }

    /**
     * Get the acceptRanges property: The Accept-Ranges property.
     * 
     * @return the acceptRanges value.
     */
    @Generated
    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    /**
     * Set the acceptRanges property: The Accept-Ranges property.
     * 
     * @param acceptRanges the acceptRanges value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    /**
     * Get the xMsCopyCompletionTime property: The x-ms-copy-completion-time property.
     * 
     * @return the xMsCopyCompletionTime value.
     */
    @Generated
    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    /**
     * Set the xMsCopyCompletionTime property: The x-ms-copy-completion-time property.
     * 
     * @param xMsCopyCompletionTime the xMsCopyCompletionTime value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        if (xMsCopyCompletionTime == null) {
            this.xMsCopyCompletionTime = null;
        } else {
            this.xMsCopyCompletionTime = new DateTimeRfc1123(xMsCopyCompletionTime);
        }
        return this;
    }

    /**
     * Get the xMsServerEncrypted property: The x-ms-server-encrypted property.
     * 
     * @return the xMsServerEncrypted value.
     */
    @Generated
    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    /**
     * Set the xMsServerEncrypted property: The x-ms-server-encrypted property.
     * 
     * @param xMsServerEncrypted the xMsServerEncrypted value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    /**
     * Get the cacheControl property: The Cache-Control property.
     * 
     * @return the cacheControl value.
     */
    @Generated
    public String getCacheControl() {
        return this.cacheControl;
    }

    /**
     * Set the cacheControl property: The Cache-Control property.
     * 
     * @param cacheControl the cacheControl value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    /**
     * Get the eTag property: The ETag property.
     * 
     * @return the eTag value.
     */
    @Generated
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The ETag property.
     * 
     * @param eTag the eTag value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the xMsLinkCount property: The x-ms-link-count property.
     * 
     * @return the xMsLinkCount value.
     */
    @Generated
    public Long getXMsLinkCount() {
        return this.xMsLinkCount;
    }

    /**
     * Set the xMsLinkCount property: The x-ms-link-count property.
     * 
     * @param xMsLinkCount the xMsLinkCount value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsLinkCount(Long xMsLinkCount) {
        this.xMsLinkCount = xMsLinkCount;
        return this;
    }

    /**
     * Get the contentDisposition property: The Content-Disposition property.
     * 
     * @return the contentDisposition value.
     */
    @Generated
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    /**
     * Set the contentDisposition property: The Content-Disposition property.
     * 
     * @param contentDisposition the contentDisposition value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    /**
     * Get the xMsFileChangeTime property: The x-ms-file-change-time property.
     * 
     * @return the xMsFileChangeTime value.
     */
    @Generated
    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    /**
     * Set the xMsFileChangeTime property: The x-ms-file-change-time property.
     * 
     * @param xMsFileChangeTime the xMsFileChangeTime value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    /**
     * Get the xMsFileParentId property: The x-ms-file-parent-id property.
     * 
     * @return the xMsFileParentId value.
     */
    @Generated
    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    /**
     * Set the xMsFileParentId property: The x-ms-file-parent-id property.
     * 
     * @param xMsFileParentId the xMsFileParentId value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    /**
     * Get the xMsCopyStatus property: The x-ms-copy-status property.
     * 
     * @return the xMsCopyStatus value.
     */
    @Generated
    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    /**
     * Set the xMsCopyStatus property: The x-ms-copy-status property.
     * 
     * @param xMsCopyStatus the xMsCopyStatus value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    /**
     * Get the contentLanguage property: The Content-Language property.
     * 
     * @return the contentLanguage value.
     */
    @Generated
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    /**
     * Set the contentLanguage property: The Content-Language property.
     * 
     * @param contentLanguage the contentLanguage value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    /**
     * Get the xMsFileLastWriteTime property: The x-ms-file-last-write-time property.
     * 
     * @return the xMsFileLastWriteTime value.
     */
    @Generated
    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    /**
     * Set the xMsFileLastWriteTime property: The x-ms-file-last-write-time property.
     * 
     * @param xMsFileLastWriteTime the xMsFileLastWriteTime value to set.
     * @return the FilesDownloadHeaders object itself.
     */
    @Generated
    public FilesDownloadHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }
}
