// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A wrapper around List&lt;ShareSignedIdentifier&gt; which provides top-level metadata for serialization.
 */
public final class ShareSignedIdentifierWrapper implements XmlSerializable<ShareSignedIdentifierWrapper> {
    private final List<ShareSignedIdentifier> signedIdentifiers;

    /**
     * Creates an instance of ShareSignedIdentifierWrapper.
     * 
     * @param signedIdentifiers the list.
     */
    public ShareSignedIdentifierWrapper(List<ShareSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    /**
     * Get the List&lt;ShareSignedIdentifier&gt; contained in this wrapper.
     * 
     * @return the List&lt;ShareSignedIdentifier&gt;.
     */
    public List<ShareSignedIdentifier> items() {
        return signedIdentifiers;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (signedIdentifiers != null) {
            for (ShareSignedIdentifier element : signedIdentifiers) {
                xmlWriter.writeXml(element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    @Generated
    public static ShareSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    @Generated
    public static ShareSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SignedIdentifiers" : rootElementName;
        return xmlReader.readObject(rootElementName, reader -> {
            List<ShareSignedIdentifier> items = null;

            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<>();
                    }

                    items.add(ShareSignedIdentifier.fromXml(reader));
                } else {
                    reader.nextElement();
                }
            }
            return new ShareSignedIdentifierWrapper(items);
        });
    }
}
