/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.NfsFileType;
import java.time.OffsetDateTime;

public final class DirectoriesCreateHeaders {
    private String xMsGroup;
    private String xMsVersion;
    private String xMsFilePermissionKey;
    private String xMsFileId;
    private OffsetDateTime xMsFileCreationTime;
    private NfsFileType xMsFileFileType;
    private DateTimeRfc1123 lastModified;
    private Boolean xMsRequestServerEncrypted;
    private DateTimeRfc1123 date;
    private String xMsMode;
    private String eTag;
    private String xMsFileAttributes;
    private OffsetDateTime xMsFileChangeTime;
    private String xMsFileParentId;
    private String xMsRequestId;
    private OffsetDateTime xMsFileLastWriteTime;
    private String xMsOwner;
    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString((String)"x-ms-group");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_FILE_PERMISSION_KEY = HttpHeaderName.fromString((String)"x-ms-file-permission-key");
    private static final HttpHeaderName X_MS_FILE_ID = HttpHeaderName.fromString((String)"x-ms-file-id");
    private static final HttpHeaderName X_MS_FILE_CREATION_TIME = HttpHeaderName.fromString((String)"x-ms-file-creation-time");
    private static final HttpHeaderName X_MS_FILE_FILE_TYPE = HttpHeaderName.fromString((String)"x-ms-file-file-type");
    private static final HttpHeaderName X_MS_REQUEST_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-request-server-encrypted");
    private static final HttpHeaderName X_MS_MODE = HttpHeaderName.fromString((String)"x-ms-mode");
    private static final HttpHeaderName X_MS_FILE_ATTRIBUTES = HttpHeaderName.fromString((String)"x-ms-file-attributes");
    private static final HttpHeaderName X_MS_FILE_CHANGE_TIME = HttpHeaderName.fromString((String)"x-ms-file-change-time");
    private static final HttpHeaderName X_MS_FILE_PARENT_ID = HttpHeaderName.fromString((String)"x-ms-file-parent-id");
    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME = HttpHeaderName.fromString((String)"x-ms-file-last-write-time");
    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString((String)"x-ms-owner");

    public DirectoriesCreateHeaders(HttpHeaders rawHeaders) {
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsFilePermissionKey = rawHeaders.getValue(X_MS_FILE_PERMISSION_KEY);
        this.xMsFileId = rawHeaders.getValue(X_MS_FILE_ID);
        String xMsFileCreationTime = rawHeaders.getValue(X_MS_FILE_CREATION_TIME);
        this.xMsFileCreationTime = xMsFileCreationTime != null ? OffsetDateTime.parse(xMsFileCreationTime) : null;
        String xMsFileFileType = rawHeaders.getValue(X_MS_FILE_FILE_TYPE);
        this.xMsFileFileType = xMsFileFileType != null ? NfsFileType.fromString(xMsFileFileType) : null;
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        String xMsRequestServerEncrypted = rawHeaders.getValue(X_MS_REQUEST_SERVER_ENCRYPTED);
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted != null ? Boolean.valueOf(Boolean.parseBoolean(xMsRequestServerEncrypted)) : null;
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        this.xMsMode = rawHeaders.getValue(X_MS_MODE);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.xMsFileAttributes = rawHeaders.getValue(X_MS_FILE_ATTRIBUTES);
        String xMsFileChangeTime = rawHeaders.getValue(X_MS_FILE_CHANGE_TIME);
        this.xMsFileChangeTime = xMsFileChangeTime != null ? OffsetDateTime.parse(xMsFileChangeTime) : null;
        this.xMsFileParentId = rawHeaders.getValue(X_MS_FILE_PARENT_ID);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME);
        this.xMsFileLastWriteTime = xMsFileLastWriteTime != null ? OffsetDateTime.parse(xMsFileLastWriteTime) : null;
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
    }

    public String getXMsGroup() {
        return this.xMsGroup;
    }

    public DirectoriesCreateHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public DirectoriesCreateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    public DirectoriesCreateHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    public String getXMsFileId() {
        return this.xMsFileId;
    }

    public DirectoriesCreateHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    public DirectoriesCreateHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    public NfsFileType getXMsFileFileType() {
        return this.xMsFileFileType;
    }

    public DirectoriesCreateHeaders setXMsFileFileType(NfsFileType xMsFileFileType) {
        this.xMsFileFileType = xMsFileFileType;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public DirectoriesCreateHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public DirectoriesCreateHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public DirectoriesCreateHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsMode() {
        return this.xMsMode;
    }

    public DirectoriesCreateHeaders setXMsMode(String xMsMode) {
        this.xMsMode = xMsMode;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public DirectoriesCreateHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    public DirectoriesCreateHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    public DirectoriesCreateHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    public DirectoriesCreateHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public DirectoriesCreateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public DirectoriesCreateHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }

    public String getXMsOwner() {
        return this.xMsOwner;
    }

    public DirectoriesCreateHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }
}

