/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FileRange
implements XmlSerializable<FileRange> {
    private long start;
    private long end;

    public long getStart() {
        return this.start;
    }

    public FileRange setStart(long start) {
        this.start = start;
        return this;
    }

    public long getEnd() {
        return this.end;
    }

    public FileRange setEnd(long end) {
        this.end = end;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Range" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("Start", this.start);
        xmlWriter.writeLongElement("End", this.end);
        return xmlWriter.writeEndElement();
    }

    public static FileRange fromXml(XmlReader xmlReader) throws XMLStreamException {
        return FileRange.fromXml(xmlReader, null);
    }

    public static FileRange fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Range" : rootElementName;
        return (FileRange)xmlReader.readObject(finalRootElementName, reader -> {
            FileRange deserializedFileRange = new FileRange();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedFileRange.start = reader.getLongElement();
                    continue;
                }
                if ("End".equals(elementName.getLocalPart())) {
                    deserializedFileRange.end = reader.getLongElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedFileRange;
        });
    }
}

