/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.implementation.accesshelpers.ShareFileInfoHelper;
import com.azure.storage.file.share.models.FilePosixProperties;
import java.time.OffsetDateTime;

public final class ShareFileInfo {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final Boolean isServerEncrypted;
    private final FileSmbProperties smbProperties;
    private final FilePosixProperties posixProperties;

    public ShareFileInfo(String eTag, OffsetDateTime lastModified, Boolean isServerEncrypted, FileSmbProperties smbProperties) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.isServerEncrypted = isServerEncrypted;
        this.smbProperties = smbProperties;
        this.posixProperties = null;
    }

    private ShareFileInfo(String eTag, OffsetDateTime lastModified, Boolean isServerEncrypted, FileSmbProperties smbProperties, FilePosixProperties posixProperties) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.isServerEncrypted = isServerEncrypted;
        this.smbProperties = smbProperties;
        this.posixProperties = posixProperties;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public FileSmbProperties getSmbProperties() {
        return this.smbProperties;
    }

    public FilePosixProperties getPosixProperties() {
        return this.posixProperties;
    }

    static {
        ShareFileInfoHelper.setAccessor(ShareFileInfo::new);
    }
}

