/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.StorageFileInputStream;
import com.azure.storage.file.share.StorageFileOutputStream;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.ShareFileCopyInfo;
import com.azure.storage.file.share.models.ShareFileDownloadAsyncResponse;
import com.azure.storage.file.share.models.ShareFileDownloadResponse;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ShareFileClient {
    private final ClientLogger logger = new ClientLogger(ShareFileClient.class);
    private final ShareFileAsyncClient shareFileAsyncClient;

    ShareFileClient(ShareFileAsyncClient shareFileAsyncClient) {
        this.shareFileAsyncClient = shareFileAsyncClient;
    }

    public String getFileUrl() {
        return this.shareFileAsyncClient.getFileUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.shareFileAsyncClient.getServiceVersion();
    }

    public final StorageFileInputStream openInputStream() {
        return this.openInputStream(new ShareFileRange(0L));
    }

    public final StorageFileInputStream openInputStream(ShareFileRange range) {
        return new StorageFileInputStream(this.shareFileAsyncClient, range.getStart(), range.getEnd());
    }

    public final StorageFileOutputStream getFileOutputStream() {
        return this.getFileOutputStream(0L);
    }

    public final StorageFileOutputStream getFileOutputStream(long offset) {
        return new StorageFileOutputStream(this.shareFileAsyncClient, offset);
    }

    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.shareFileAsyncClient.existsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileInfo create(long maxSize) {
        return (ShareFileInfo)this.createWithResponse(maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileInfo>> response = this.shareFileAsyncClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, metadata, pollInterval, null);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, FileSmbProperties smbProperties, String filePermission, PermissionCopyModeType filePermissionCopyMode, Boolean ignoreReadOnly, Boolean setArchiveAttribute, Map<String, String> metadata, Duration pollInterval, ShareRequestConditions destinationRequestConditions) {
        return this.shareFileAsyncClient.beginCopy(sourceUrl, smbProperties, filePermission, filePermissionCopyMode, ignoreReadOnly, setArchiveAttribute, metadata, pollInterval, destinationRequestConditions).getSyncPoller();
    }

    public void abortCopy(String copyId) {
        this.abortCopyWithResponse(copyId, null, Context.NONE);
    }

    public Response<Void> abortCopyWithResponse(String copyId, Duration timeout, Context context) {
        return this.abortCopyWithResponse(copyId, null, timeout, context);
    }

    public Response<Void> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareFileAsyncClient.abortCopyWithResponse(copyId, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileProperties downloadToFile(String downloadFilePath) {
        return (ShareFileProperties)this.downloadToFileWithResponse(downloadFilePath, null, null, Context.NONE).getValue();
    }

    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(downloadFilePath, range, null, timeout, context);
    }

    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileProperties>> response = this.shareFileAsyncClient.downloadToFileWithResponse(downloadFilePath, range, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void download(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, Context.NONE);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, range, rangeGetContentMD5, null, timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Objects.requireNonNull(stream, "'stream' cannot be null.");
        Mono download = this.shareFileAsyncClient.downloadWithResponse(range, rangeGetContentMD5, requestConditions, context).flatMap(response -> ((Flux)response.getValue()).reduce((Object)stream, (outputStream, buffer) -> {
            try {
                outputStream.write(FluxUtil.byteBufferToArray((ByteBuffer)buffer));
                return outputStream;
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new UncheckedIOException(ex)));
            }
        }).thenReturn((Object)new ShareFileDownloadResponse((ShareFileDownloadAsyncResponse)((Object)response))));
        return (ShareFileDownloadResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return this.deleteWithResponse(null, timeout, context);
    }

    public Response<Void> deleteWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareFileAsyncClient.deleteWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileProperties getProperties() {
        return (ShareFileProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    public Response<ShareFileProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return this.getPropertiesWithResponse(null, timeout, context);
    }

    public Response<ShareFileProperties> getPropertiesWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileProperties>> response = this.shareFileAsyncClient.getPropertiesWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileInfo setProperties(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return (ShareFileInfo)this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, Context.NONE).getValue();
    }

    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, timeout, context);
    }

    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileInfo>> response = this.shareFileAsyncClient.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileMetadataInfo setMetadata(Map<String, String> metadata) {
        return (ShareFileMetadataInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return this.setMetadataWithResponse(metadata, null, timeout, context);
    }

    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileMetadataInfo>> response = this.shareFileAsyncClient.setMetadataWithResponse(metadata, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileUploadInfo upload(InputStream data, long length) {
        return (ShareFileUploadInfo)this.uploadWithResponse(data, length, 0L, null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, Duration timeout, Context context) {
        return this.uploadWithResponse(data, length, offset, null, timeout, context);
    }

    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadWithResponse((Flux<ByteBuffer>)Utility.convertStreamToByteBuffer((InputStream)data, (long)length, (int)0x400000), length, offset, requestConditions, context), (Duration)timeout);
    }

    public ShareFileUploadRangeFromUrlInfo uploadRangeFromUrl(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return (ShareFileUploadRangeFromUrlInfo)this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, timeout, context);
    }

    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileUploadRangeFromUrlInfo>> response = this.shareFileAsyncClient.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareFileUploadInfo clearRange(long length) {
        return (ShareFileUploadInfo)this.clearRangeWithResponse(length, 0L, null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, Duration timeout, Context context) {
        return this.clearRangeWithResponse(length, offset, null, timeout, context);
    }

    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileUploadInfo>> response = this.shareFileAsyncClient.clearRangeWithResponse(length, offset, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void uploadFromFile(String uploadFilePath) {
        this.uploadFromFile(uploadFilePath, null);
    }

    public void uploadFromFile(String uploadFilePath, ShareRequestConditions requestConditions) {
        this.shareFileAsyncClient.uploadFromFile(uploadFilePath, requestConditions).block();
    }

    public PagedIterable<ShareFileRange> listRanges() {
        return this.listRanges(null, null, null);
    }

    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, Duration timeout, Context context) {
        return this.listRanges(range, null, timeout, context);
    }

    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return new PagedIterable(this.shareFileAsyncClient.listRangesWithOptionalTimeout(range, requestConditions, timeout, context));
    }

    public PagedIterable<HandleItem> listHandles() {
        return this.listHandles(null, null, Context.NONE);
    }

    public PagedIterable<HandleItem> listHandles(Integer maxResultsPerPage, Duration timeout, Context context) {
        return new PagedIterable(this.shareFileAsyncClient.listHandlesWithOptionalTimeout(maxResultsPerPage, timeout, context));
    }

    public CloseHandlesInfo forceCloseHandle(String handleId) {
        return (CloseHandlesInfo)this.forceCloseHandleWithResponse(handleId, null, Context.NONE).getValue();
    }

    public Response<CloseHandlesInfo> forceCloseHandleWithResponse(String handleId, Duration timeout, Context context) {
        Mono<Response<CloseHandlesInfo>> response = this.shareFileAsyncClient.forceCloseHandleWithResponse(handleId, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public CloseHandlesInfo forceCloseAllHandles(Duration timeout, Context context) {
        return new PagedIterable(this.shareFileAsyncClient.forceCloseAllHandlesWithOptionalTimeout(timeout, context)).stream().reduce(new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles()));
    }

    public String getShareSnapshotId() {
        return this.shareFileAsyncClient.getShareSnapshotId();
    }

    public String getShareName() {
        return this.shareFileAsyncClient.getShareName();
    }

    public String getFilePath() {
        return this.shareFileAsyncClient.getFilePath();
    }

    public String getAccountName() {
        return this.shareFileAsyncClient.getAccountName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.shareFileAsyncClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.shareFileAsyncClient.generateSas(shareServiceSasSignatureValues);
    }
}

