/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.FilesAbortCopyResponse;
import com.azure.storage.file.share.implementation.models.FilesAcquireLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesBreakLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesChangeLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesCreateResponse;
import com.azure.storage.file.share.implementation.models.FilesDeleteResponse;
import com.azure.storage.file.share.implementation.models.FilesDownloadResponse;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.FilesGetRangeListResponse;
import com.azure.storage.file.share.implementation.models.FilesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.FilesReleaseLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesSetHTTPHeadersResponse;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.FilesStartCopyResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.SourceModifiedAccessConditions;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FilesImpl {
    private FilesService service;
    private AzureFileStorageImpl client;

    public FilesImpl(AzureFileStorageImpl client) {
        this.service = (FilesService)RestProxy.create(FilesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<FilesCreateResponse> createWithRestResponseAsync(String shareName, String filePath, long fileContentLength, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Context context) {
        Integer timeout = null;
        String fileTypeConstant = "file";
        Map<String, String> metadata = null;
        String filePermission = null;
        String filePermissionKey = null;
        String leaseId = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String cacheControl = null;
        String contentDisposition = null;
        String contentMd5Converted = null;
        return this.service.create(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, "file", metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    public Mono<FilesCreateResponse> createWithRestResponseAsync(String shareName, String filePath, long fileContentLength, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String fileTypeConstant = "file";
        String contentType = null;
        if (shareFileHttpHeaders != null) {
            contentType = shareFileHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (shareFileHttpHeaders != null) {
            contentEncoding = shareFileHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (shareFileHttpHeaders != null) {
            contentLanguage = shareFileHttpHeaders.getContentLanguage();
        }
        String cacheControl = null;
        if (shareFileHttpHeaders != null) {
            cacheControl = shareFileHttpHeaders.getCacheControl();
        }
        byte[] contentMd5 = null;
        if (shareFileHttpHeaders != null) {
            contentMd5 = shareFileHttpHeaders.getContentMd5();
        }
        String contentDisposition = null;
        if (shareFileHttpHeaders != null) {
            contentDisposition = shareFileHttpHeaders.getContentDisposition();
        }
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.create(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, "file", metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    public Mono<FilesDownloadResponse> downloadWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        String range = null;
        Boolean rangeGetContentMD5 = null;
        String leaseId = null;
        return this.service.download(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, context);
    }

    public Mono<FilesDownloadResponse> downloadWithRestResponseAsync(String shareName, String filePath, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        return this.service.download(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, context);
    }

    public Mono<FilesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String filePath, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        String leaseId = null;
        return this.service.getProperties(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), leaseId, context);
    }

    public Mono<FilesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String filePath, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        return this.service.getProperties(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), leaseId, context);
    }

    public Mono<FilesDeleteResponse> deleteWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        String leaseId = null;
        return this.service.delete(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, context);
    }

    public Mono<FilesDeleteResponse> deleteWithRestResponseAsync(String shareName, String filePath, Integer timeout, String leaseId, Context context) {
        return this.service.delete(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, context);
    }

    public Mono<FilesSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String shareName, String filePath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Context context) {
        Integer timeout = null;
        Long fileContentLength = null;
        String filePermission = null;
        String filePermissionKey = null;
        String leaseId = null;
        String comp = "properties";
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String cacheControl = null;
        String contentDisposition = null;
        String contentMd5Converted = null;
        return this.service.setHTTPHeaders(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, "properties", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    public Mono<FilesSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String shareName, String filePath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "properties";
        String contentType = null;
        if (shareFileHttpHeaders != null) {
            contentType = shareFileHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (shareFileHttpHeaders != null) {
            contentEncoding = shareFileHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (shareFileHttpHeaders != null) {
            contentLanguage = shareFileHttpHeaders.getContentLanguage();
        }
        String cacheControl = null;
        if (shareFileHttpHeaders != null) {
            cacheControl = shareFileHttpHeaders.getCacheControl();
        }
        byte[] contentMd5 = null;
        if (shareFileHttpHeaders != null) {
            contentMd5 = shareFileHttpHeaders.getContentMd5();
        }
        String contentDisposition = null;
        if (shareFileHttpHeaders != null) {
            contentDisposition = shareFileHttpHeaders.getContentDisposition();
        }
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.setHTTPHeaders(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, "properties", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    public Mono<FilesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        String comp = "metadata";
        return this.service.setMetadata(shareName, filePath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), leaseId, "metadata", context);
    }

    public Mono<FilesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String filePath, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String comp = "metadata";
        return this.service.setMetadata(shareName, filePath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), leaseId, "metadata", context);
    }

    public Mono<FilesUploadRangeResponse> uploadRangeWithRestResponseAsync(String shareName, String filePath, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Context context) {
        Flux<ByteBuffer> optionalbody = null;
        Integer timeout = null;
        String leaseId = null;
        String comp = "range";
        String contentMD5Converted = null;
        return this.service.uploadRange(shareName, filePath, this.client.getUrl(), optionalbody, timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, "range", context);
    }

    public Mono<FilesUploadRangeResponse> uploadRangeWithRestResponseAsync(String shareName, String filePath, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Flux<ByteBuffer> optionalbody, Integer timeout, byte[] contentMD5, String leaseId, Context context) {
        String comp = "range";
        String contentMD5Converted = Base64Util.encodeToString((byte[])contentMD5);
        return this.service.uploadRange(shareName, filePath, this.client.getUrl(), optionalbody, timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, "range", context);
    }

    public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURLWithRestResponseAsync(String shareName, String filePath, String range, String copySource, long contentLength, Context context) {
        Integer timeout = null;
        String sourceRange = null;
        String fileRangeWriteFromUrl = "update";
        String leaseId = null;
        String comp = "range";
        String sourceContentCrc64Converted = null;
        String sourceIfMatchCrc64Converted = null;
        String sourceIfNoneMatchCrc64Converted = null;
        return this.service.uploadRangeFromURL(shareName, filePath, this.client.getUrl(), timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, this.client.getVersion(), leaseId, "range", sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, context);
    }

    public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURLWithRestResponseAsync(String shareName, String filePath, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String fileRangeWriteFromUrl = "update";
        String comp = "range";
        byte[] sourceIfMatchCrc64 = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64 = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64 = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        String sourceContentCrc64Converted = Base64Util.encodeToString((byte[])sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString((byte[])sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString((byte[])sourceIfNoneMatchCrc64);
        return this.service.uploadRangeFromURL(shareName, filePath, this.client.getUrl(), timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, this.client.getVersion(), leaseId, "range", sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, context);
    }

    public Mono<FilesGetRangeListResponse> getRangeListWithRestResponseAsync(String shareName, String filePath, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        String range = null;
        String leaseId = null;
        String comp = "rangelist";
        return this.service.getRangeList(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), range, leaseId, "rangelist", context);
    }

    public Mono<FilesGetRangeListResponse> getRangeListWithRestResponseAsync(String shareName, String filePath, String sharesnapshot, Integer timeout, String range, String leaseId, Context context) {
        String comp = "rangelist";
        return this.service.getRangeList(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), range, leaseId, "rangelist", context);
    }

    public Mono<FilesStartCopyResponse> startCopyWithRestResponseAsync(String shareName, String filePath, String copySource, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String filePermission = null;
        String filePermissionKey = null;
        String leaseId = null;
        PermissionCopyModeType filePermissionCopyMode = null;
        Boolean ignoreReadOnly = null;
        String fileAttributes = null;
        String fileCreationTime = null;
        String fileLastWriteTime = null;
        Boolean setArchiveAttribute = null;
        return this.service.startCopy(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, leaseId, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, setArchiveAttribute, context);
    }

    public Mono<FilesStartCopyResponse> startCopyWithRestResponseAsync(String shareName, String filePath, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        PermissionCopyModeType filePermissionCopyMode = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyMode = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        Boolean ignoreReadOnly = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnly = copyFileSmbInfo.isIgnoreReadOnly();
        }
        String fileAttributes = null;
        if (copyFileSmbInfo != null) {
            fileAttributes = copyFileSmbInfo.getFileAttributes();
        }
        String fileCreationTime = null;
        if (copyFileSmbInfo != null) {
            fileCreationTime = copyFileSmbInfo.getFileCreationTime();
        }
        String fileLastWriteTime = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTime = copyFileSmbInfo.getFileLastWriteTime();
        }
        Boolean setArchiveAttribute = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttribute = copyFileSmbInfo.isSetArchiveAttribute();
        }
        return this.service.startCopy(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, leaseId, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, setArchiveAttribute, context);
    }

    public Mono<FilesAbortCopyResponse> abortCopyWithRestResponseAsync(String shareName, String filePath, String copyId, Context context) {
        Integer timeout = null;
        String copyActionAbortConstant = "abort";
        String leaseId = null;
        String comp = "copy";
        return this.service.abortCopy(shareName, filePath, this.client.getUrl(), copyId, timeout, "abort", this.client.getVersion(), leaseId, "copy", context);
    }

    public Mono<FilesAbortCopyResponse> abortCopyWithRestResponseAsync(String shareName, String filePath, String copyId, Integer timeout, String leaseId, Context context) {
        String copyActionAbortConstant = "abort";
        String comp = "copy";
        return this.service.abortCopy(shareName, filePath, this.client.getUrl(), copyId, timeout, "abort", this.client.getVersion(), leaseId, "copy", context);
    }

    public Mono<FilesListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String filePath, Context context) {
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String sharesnapshot = null;
        String comp = "listhandles";
        return this.service.listHandles(shareName, filePath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), "listhandles", context);
    }

    public Mono<FilesListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String filePath, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        return this.service.listHandles(shareName, filePath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), "listhandles", context);
    }

    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String filePath, String handleId, Context context) {
        Integer timeout = null;
        String marker = null;
        String sharesnapshot = null;
        String comp = "forceclosehandles";
        return this.service.forceCloseHandles(shareName, filePath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, this.client.getVersion(), "forceclosehandles", context);
    }

    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String filePath, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        return this.service.forceCloseHandles(shareName, filePath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, this.client.getVersion(), "forceclosehandles", context);
    }

    public Mono<FilesAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        Integer duration = null;
        String proposedLeaseId = null;
        String requestId = null;
        String comp = "lease";
        String action = "acquire";
        return this.service.acquireLease(shareName, filePath, this.client.getUrl(), timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, "lease", "acquire", context);
    }

    public Mono<FilesAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String shareName, String filePath, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        return this.service.acquireLease(shareName, filePath, this.client.getUrl(), timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, "lease", "acquire", context);
    }

    public Mono<FilesReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "lease";
        String action = "release";
        return this.service.releaseLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "lease", "release", context);
    }

    public Mono<FilesReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Integer timeout, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        return this.service.releaseLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "lease", "release", context);
    }

    public Mono<FilesChangeLeaseResponse> changeLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Context context) {
        Integer timeout = null;
        String proposedLeaseId = null;
        String requestId = null;
        String comp = "lease";
        String action = "change";
        return this.service.changeLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, "lease", "change", context);
    }

    public Mono<FilesChangeLeaseResponse> changeLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        return this.service.changeLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, "lease", "change", context);
    }

    public Mono<FilesBreakLeaseResponse> breakLeaseWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String requestId = null;
        String comp = "lease";
        String action = "break";
        return this.service.breakLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "lease", "break", context);
    }

    public Mono<FilesBreakLeaseResponse> breakLeaseWithRestResponseAsync(String shareName, String filePath, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        return this.service.breakLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "lease", "break", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageFiles")
    private static interface FilesService {
        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesCreateResponse> create(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-content-length") long var6, @HeaderParam(value="x-ms-type") String var8, @HeaderParam(value="x-ms-meta-") Map<String, String> var9, @HeaderParam(value="x-ms-file-permission") String var10, @HeaderParam(value="x-ms-file-permission-key") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-content-type") String var16, @HeaderParam(value="x-ms-content-encoding") String var17, @HeaderParam(value="x-ms-content-language") String var18, @HeaderParam(value="x-ms-cache-control") String var19, @HeaderParam(value="x-ms-content-md5") String var20, @HeaderParam(value="x-ms-content-disposition") String var21, Context var22);

        @Get(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesDownloadResponse> download(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var7, @HeaderParam(value="x-ms-lease-id") String var8, Context var9);

        @Head(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        public Mono<FilesGetPropertiesResponse> getProperties(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, Context var8);

        @Delete(value="{shareName}/{filePath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesDeleteResponse> delete(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-lease-id") String var6, Context var7);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesSetHTTPHeadersResponse> setHTTPHeaders(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-content-length") Long var6, @HeaderParam(value="x-ms-file-permission") String var7, @HeaderParam(value="x-ms-file-permission-key") String var8, @HeaderParam(value="x-ms-file-attributes") String var9, @HeaderParam(value="x-ms-file-creation-time") String var10, @HeaderParam(value="x-ms-file-last-write-time") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @QueryParam(value="comp") String var13, @HeaderParam(value="x-ms-content-type") String var14, @HeaderParam(value="x-ms-content-encoding") String var15, @HeaderParam(value="x-ms-content-language") String var16, @HeaderParam(value="x-ms-cache-control") String var17, @HeaderParam(value="x-ms-content-md5") String var18, @HeaderParam(value="x-ms-content-disposition") String var19, Context var20);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesSetMetadataResponse> setMetadata(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesUploadRangeResponse> uploadRange(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @QueryParam(value="comp") String var13, Context var14);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURL(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-range") String var5, @HeaderParam(value="x-ms-copy-source") String var6, @HeaderParam(value="x-ms-source-range") String var7, @HeaderParam(value="x-ms-write") String var8, @HeaderParam(value="Content-Length") long var9, @HeaderParam(value="x-ms-source-content-crc64") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-lease-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-source-if-match-crc64") String var15, @HeaderParam(value="x-ms-source-if-none-match-crc64") String var16, Context var17);

        @Get(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesGetRangeListResponse> getRangeList(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesStartCopyResponse> startCopy(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-file-permission-copy-mode") PermissionCopyModeType var11, @HeaderParam(value="x-ms-file-copy-ignore-read-only") Boolean var12, @HeaderParam(value="x-ms-file-attributes") String var13, @HeaderParam(value="x-ms-file-creation-time") String var14, @HeaderParam(value="x-ms-file-last-write-time") String var15, @HeaderParam(value="x-ms-file-copy-set-archive") Boolean var16, Context var17);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesAbortCopyResponse> abortCopy(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="copyid") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-copy-action") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Get(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesListHandlesResponse> listHandles(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="timeout") Integer var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesForceCloseHandlesResponse> forceCloseHandles(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="marker") String var5, @QueryParam(value="sharesnapshot") String var6, @HeaderParam(value="x-ms-handle-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesAcquireLeaseResponse> acquireLease(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-duration") Integer var5, @HeaderParam(value="x-ms-proposed-lease-id") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-action") String var10, Context var11);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesReleaseLeaseResponse> releaseLease(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-action") String var9, Context var10);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesChangeLeaseResponse> changeLease(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-proposed-lease-id") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-action") String var10, Context var11);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesBreakLeaseResponse> breakLease(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-action") String var9, Context var10);
    }
}

