/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.specialized.ShareLeaseAsyncClient;
import java.time.Duration;

public final class ShareLeaseClient {
    private final ShareLeaseAsyncClient client;

    ShareLeaseClient(ShareLeaseAsyncClient client) {
        this.client = client;
    }

    public String getFileUrl() {
        return this.client.getFileUrl();
    }

    public String getLeaseId() {
        return this.client.getLeaseId();
    }

    public String acquireLease() {
        return (String)this.acquireLeaseWithResponse(null, Context.NONE).getValue();
    }

    public Response<String> acquireLeaseWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.acquireLeaseWithResponse(context), (Duration)timeout);
    }

    public void releaseLease() {
        this.releaseLeaseWithResponse(null, Context.NONE);
    }

    public Response<Void> releaseLeaseWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.releaseLeaseWithResponse(context), (Duration)timeout);
    }

    public void breakLease() {
        this.breakLeaseWithResponse(null, Context.NONE).getValue();
    }

    public Response<Void> breakLeaseWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.breakLeaseWithResponse(context), (Duration)timeout);
    }

    public String changeLease(String proposedId) {
        return (String)this.changeLeaseWithResponse(proposedId, null, Context.NONE).getValue();
    }

    public Response<String> changeLeaseWithResponse(String proposedId, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.changeLeaseWithResponse(proposedId, context), (Duration)timeout);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }
}

