// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.FilesAbortCopyResponse;
import com.azure.storage.file.share.implementation.models.FilesAcquireLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesBreakLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesChangeLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesCreateResponse;
import com.azure.storage.file.share.implementation.models.FilesDeleteResponse;
import com.azure.storage.file.share.implementation.models.FilesDownloadResponse;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.FilesGetRangeListResponse;
import com.azure.storage.file.share.implementation.models.FilesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.FilesReleaseLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesSetHTTPHeadersResponse;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.FilesStartCopyResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.SourceModifiedAccessConditions;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * Files.
 */
public final class FilesImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private FilesService service;

    /**
     * The service client containing this operation class.
     */
    private AzureFileStorageImpl client;

    /**
     * Initializes an instance of FilesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    public FilesImpl(AzureFileStorageImpl client) {
        this.service = RestProxy.create(FilesService.class, client.getHttpPipeline());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureFileStorageFiles to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureFileStorageFiles")
    private interface FilesService {
        @Put("{shareName}/{filePath}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesCreateResponse> create(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-content-length") long fileContentLength, @HeaderParam("x-ms-type") String fileTypeConstant, @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-file-permission") String filePermission, @HeaderParam("x-ms-file-permission-key") String filePermissionKey, @HeaderParam("x-ms-file-attributes") String fileAttributes, @HeaderParam("x-ms-file-creation-time") String fileCreationTime, @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime, @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-content-type") String contentType, @HeaderParam("x-ms-content-encoding") String contentEncoding, @HeaderParam("x-ms-content-language") String contentLanguage, @HeaderParam("x-ms-cache-control") String cacheControl, @HeaderParam("x-ms-content-md5") String contentMd5, @HeaderParam("x-ms-content-disposition") String contentDisposition, Context context);

        @Get("{shareName}/{filePath}")
        @ExpectedResponses({200, 206})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesDownloadResponse> download(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-range-get-content-md5") Boolean rangeGetContentMD5, @HeaderParam("x-ms-lease-id") String leaseId, Context context);

        @Head("{shareName}/{filePath}")
        @ExpectedResponses({200})
        Mono<FilesGetPropertiesResponse> getProperties(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId, Context context);

        @Delete("{shareName}/{filePath}")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesDeleteResponse> delete(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesSetHTTPHeadersResponse> setHTTPHeaders(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-content-length") Long fileContentLength, @HeaderParam("x-ms-file-permission") String filePermission, @HeaderParam("x-ms-file-permission-key") String filePermissionKey, @HeaderParam("x-ms-file-attributes") String fileAttributes, @HeaderParam("x-ms-file-creation-time") String fileCreationTime, @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime, @HeaderParam("x-ms-lease-id") String leaseId, @QueryParam("comp") String comp, @HeaderParam("x-ms-content-type") String contentType, @HeaderParam("x-ms-content-encoding") String contentEncoding, @HeaderParam("x-ms-content-language") String contentLanguage, @HeaderParam("x-ms-cache-control") String cacheControl, @HeaderParam("x-ms-content-md5") String contentMd5, @HeaderParam("x-ms-content-disposition") String contentDisposition, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesSetMetadataResponse> setMetadata(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId, @QueryParam("comp") String comp, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesUploadRangeResponse> uploadRange(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @BodyParam("application/octet-stream") Flux<ByteBuffer> optionalbody, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-write") ShareFileRangeWriteType fileRangeWrite, @HeaderParam("Content-Length") long contentLength, @HeaderParam("Content-MD5") String contentMD5, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId, @QueryParam("comp") String comp, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURL(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-copy-source") String copySource, @HeaderParam("x-ms-source-range") String sourceRange, @HeaderParam("x-ms-write") String fileRangeWriteFromUrl, @HeaderParam("Content-Length") long contentLength, @HeaderParam("x-ms-source-content-crc64") String sourceContentCrc64, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId, @QueryParam("comp") String comp, @HeaderParam("x-ms-source-if-match-crc64") String sourceIfMatchCrc64, @HeaderParam("x-ms-source-if-none-match-crc64") String sourceIfNoneMatchCrc64, Context context);

        @Get("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesGetRangeListResponse> getRangeList(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("sharesnapshot") String sharesnapshot, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId, @QueryParam("comp") String comp, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesStartCopyResponse> startCopy(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-copy-source") String copySource, @HeaderParam("x-ms-file-permission") String filePermission, @HeaderParam("x-ms-file-permission-key") String filePermissionKey, @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-file-permission-copy-mode") PermissionCopyModeType filePermissionCopyMode, @HeaderParam("x-ms-file-copy-ignore-read-only") Boolean ignoreReadOnly, @HeaderParam("x-ms-file-attributes") String fileAttributes, @HeaderParam("x-ms-file-creation-time") String fileCreationTime, @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime, @HeaderParam("x-ms-file-copy-set-archive") Boolean setArchiveAttribute, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesAbortCopyResponse> abortCopy(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("copyid") String copyId, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-copy-action") String copyActionAbortConstant, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-lease-id") String leaseId, @QueryParam("comp") String comp, Context context);

        @Get("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesListHandlesResponse> listHandles(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults, @QueryParam("timeout") Integer timeout, @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-version") String version, @QueryParam("comp") String comp, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesForceCloseHandlesResponse> forceCloseHandles(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @QueryParam("marker") String marker, @QueryParam("sharesnapshot") String sharesnapshot, @HeaderParam("x-ms-handle-id") String handleId, @HeaderParam("x-ms-version") String version, @QueryParam("comp") String comp, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesAcquireLeaseResponse> acquireLease(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration, @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp, @HeaderParam("x-ms-lease-action") String action, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesReleaseLeaseResponse> releaseLease(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp, @HeaderParam("x-ms-lease-action") String action, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesChangeLeaseResponse> changeLease(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp, @HeaderParam("x-ms-lease-action") String action, Context context);

        @Put("{shareName}/{filePath}")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<FilesBreakLeaseResponse> breakLease(@PathParam("shareName") String shareName, @PathParam("filePath") String filePath, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp, @HeaderParam("x-ms-lease-action") String action, Context context);
    }

    /**
     * Creates a new file or replaces a file. Note it only initializes the file with no content.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param fileContentLength Specifies the maximum size for the file, up to 1 TB.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesCreateResponse> createWithRestResponseAsync(String shareName, String filePath, long fileContentLength, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Context context) {
        final Integer timeout = null;
        final String fileTypeConstant = "file";
        final Map<String, String> metadata = null;
        final String filePermission = null;
        final String filePermissionKey = null;
        final String leaseId = null;
        final String contentType = null;
        final String contentEncoding = null;
        final String contentLanguage = null;
        final String cacheControl = null;
        final String contentDisposition = null;
        String contentMd5Converted = null;
        return service.create(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, fileTypeConstant, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    /**
     * Creates a new file or replaces a file. Note it only initializes the file with no content.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param fileContentLength Specifies the maximum size for the file, up to 1 TB.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareFileHttpHeaders Additional parameters for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesCreateResponse> createWithRestResponseAsync(String shareName, String filePath, long fileContentLength, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        final String fileTypeConstant = "file";
        String contentType = null;
        if (shareFileHttpHeaders != null) {
            contentType = shareFileHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (shareFileHttpHeaders != null) {
            contentEncoding = shareFileHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (shareFileHttpHeaders != null) {
            contentLanguage = shareFileHttpHeaders.getContentLanguage();
        }
        String cacheControl = null;
        if (shareFileHttpHeaders != null) {
            cacheControl = shareFileHttpHeaders.getCacheControl();
        }
        byte[] contentMd5 = null;
        if (shareFileHttpHeaders != null) {
            contentMd5 = shareFileHttpHeaders.getContentMd5();
        }
        String contentDisposition = null;
        if (shareFileHttpHeaders != null) {
            contentDisposition = shareFileHttpHeaders.getContentDisposition();
        }
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return service.create(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, fileTypeConstant, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    /**
     * Reads or downloads a file from the system, including its metadata and properties.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesDownloadResponse> downloadWithRestResponseAsync(String shareName, String filePath, Context context) {
        final Integer timeout = null;
        final String range = null;
        final Boolean rangeGetContentMD5 = null;
        final String leaseId = null;
        return service.download(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, context);
    }

    /**
     * Reads or downloads a file from the system, including its metadata and properties.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param range Return file data only from the specified byte range.
     * @param rangeGetContentMD5 When this header is set to true and specified together with the Range header, the service returns the MD5 hash for the range, as long as the range is less than or equal to 4 MB in size.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesDownloadResponse> downloadWithRestResponseAsync(String shareName, String filePath, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        return service.download(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, context);
    }

    /**
     * Returns all user-defined metadata, standard HTTP properties, and system properties for the file. It does not return the content of the file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String filePath, Context context) {
        final String sharesnapshot = null;
        final Integer timeout = null;
        final String leaseId = null;
        return service.getProperties(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), leaseId, context);
    }

    /**
     * Returns all user-defined metadata, standard HTTP properties, and system properties for the file. It does not return the content of the file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String filePath, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        return service.getProperties(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), leaseId, context);
    }

    /**
     * removes the file from the storage account.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesDeleteResponse> deleteWithRestResponseAsync(String shareName, String filePath, Context context) {
        final Integer timeout = null;
        final String leaseId = null;
        return service.delete(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, context);
    }

    /**
     * removes the file from the storage account.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesDeleteResponse> deleteWithRestResponseAsync(String shareName, String filePath, Integer timeout, String leaseId, Context context) {
        return service.delete(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, context);
    }

    /**
     * Sets HTTP headers on the file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String shareName, String filePath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Context context) {
        final Integer timeout = null;
        final Long fileContentLength = null;
        final String filePermission = null;
        final String filePermissionKey = null;
        final String leaseId = null;
        final String comp = "properties";
        final String contentType = null;
        final String contentEncoding = null;
        final String contentLanguage = null;
        final String cacheControl = null;
        final String contentDisposition = null;
        String contentMd5Converted = null;
        return service.setHTTPHeaders(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, comp, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    /**
     * Sets HTTP headers on the file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param fileContentLength Resizes a file to the specified size. If the specified byte value is less than the current size of the file, then all ranges above the specified byte value are cleared.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param shareFileHttpHeaders Additional parameters for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String shareName, String filePath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        final String comp = "properties";
        String contentType = null;
        if (shareFileHttpHeaders != null) {
            contentType = shareFileHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (shareFileHttpHeaders != null) {
            contentEncoding = shareFileHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (shareFileHttpHeaders != null) {
            contentLanguage = shareFileHttpHeaders.getContentLanguage();
        }
        String cacheControl = null;
        if (shareFileHttpHeaders != null) {
            cacheControl = shareFileHttpHeaders.getCacheControl();
        }
        byte[] contentMd5 = null;
        if (shareFileHttpHeaders != null) {
            contentMd5 = shareFileHttpHeaders.getContentMd5();
        }
        String contentDisposition = null;
        if (shareFileHttpHeaders != null) {
            contentDisposition = shareFileHttpHeaders.getContentDisposition();
        }
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return service.setHTTPHeaders(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, leaseId, comp, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, context);
    }

    /**
     * Updates user-defined metadata for the specified file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String filePath, Context context) {
        final Integer timeout = null;
        final Map<String, String> metadata = null;
        final String leaseId = null;
        final String comp = "metadata";
        return service.setMetadata(shareName, filePath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), leaseId, comp, context);
    }

    /**
     * Updates user-defined metadata for the specified file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String filePath, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        final String comp = "metadata";
        return service.setMetadata(shareName, filePath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), leaseId, comp, context);
    }

    /**
     * Upload a range of bytes to a file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param range Specifies the range of bytes to be written. Both the start and end of the range must be specified. For an update operation, the range can be up to 4 MB in size. For a clear operation, the range can be up to the value of the file's full size. The File service accepts only a single byte range for the Range and 'x-ms-range' headers, and the byte range must be specified in the following format: bytes=startByte-endByte.
     * @param fileRangeWrite Specify one of the following options: - Update: Writes the bytes specified by the request body into the specified range. The Range and Content-Length headers must match to perform the update. - Clear: Clears the specified range and releases the space used in storage for that range. To clear a range, set the Content-Length header to zero, and set the Range header to a value that indicates the range to clear, up to maximum file size. Possible values include: 'update', 'clear'.
     * @param contentLength Specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set to clear, the value of this header must be set to zero.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesUploadRangeResponse> uploadRangeWithRestResponseAsync(String shareName, String filePath, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Context context) {
        final Flux<ByteBuffer> optionalbody = null;
        final Integer timeout = null;
        final String leaseId = null;
        final String comp = "range";
        String contentMD5Converted = null;
        return service.uploadRange(shareName, filePath, this.client.getUrl(), optionalbody, timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, comp, context);
    }

    /**
     * Upload a range of bytes to a file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param range Specifies the range of bytes to be written. Both the start and end of the range must be specified. For an update operation, the range can be up to 4 MB in size. For a clear operation, the range can be up to the value of the file's full size. The File service accepts only a single byte range for the Range and 'x-ms-range' headers, and the byte range must be specified in the following format: bytes=startByte-endByte.
     * @param fileRangeWrite Specify one of the following options: - Update: Writes the bytes specified by the request body into the specified range. The Range and Content-Length headers must match to perform the update. - Clear: Clears the specified range and releases the space used in storage for that range. To clear a range, set the Content-Length header to zero, and set the Range header to a value that indicates the range to clear, up to maximum file size. Possible values include: 'update', 'clear'.
     * @param contentLength Specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set to clear, the value of this header must be set to zero.
     * @param optionalbody Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param contentMD5 An MD5 hash of the content. This hash is used to verify the integrity of the data during transport. When the Content-MD5 header is specified, the File service compares the hash of the content that has arrived with the header value that was sent. If the two hashes do not match, the operation will fail with error code 400 (Bad Request).
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesUploadRangeResponse> uploadRangeWithRestResponseAsync(String shareName, String filePath, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Flux<ByteBuffer> optionalbody, Integer timeout, byte[] contentMD5, String leaseId, Context context) {
        final String comp = "range";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return service.uploadRange(shareName, filePath, this.client.getUrl(), optionalbody, timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, comp, context);
    }

    /**
     * Upload a range of bytes to a file where the contents are read from a URL.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param range Writes data to the specified byte range in the file.
     * @param copySource Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file within the same storage account, you may use Shared Key to authenticate the source file. If you are copying a file from another storage account, or if you are copying a blob from the same storage account or another storage account, then you must authenticate the source file or blob using a shared access signature. If the source is a public blob, no authentication is required to perform the copy operation. A file in a share snapshot can also be specified as a copy source.
     * @param contentLength Specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set to clear, the value of this header must be set to zero.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURLWithRestResponseAsync(String shareName, String filePath, String range, String copySource, long contentLength, Context context) {
        final Integer timeout = null;
        final String sourceRange = null;
        final String fileRangeWriteFromUrl = "update";
        final String leaseId = null;
        final String comp = "range";
        String sourceContentCrc64Converted = null;
        String sourceIfMatchCrc64Converted = null;
        String sourceIfNoneMatchCrc64Converted = null;
        return service.uploadRangeFromURL(shareName, filePath, this.client.getUrl(), timeout, range, copySource, sourceRange, fileRangeWriteFromUrl, contentLength, sourceContentCrc64Converted, this.client.getVersion(), leaseId, comp, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, context);
    }

    /**
     * Upload a range of bytes to a file where the contents are read from a URL.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param range Writes data to the specified byte range in the file.
     * @param copySource Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file within the same storage account, you may use Shared Key to authenticate the source file. If you are copying a file from another storage account, or if you are copying a blob from the same storage account or another storage account, then you must authenticate the source file or blob using a shared access signature. If the source is a public blob, no authentication is required to perform the copy operation. A file in a share snapshot can also be specified as a copy source.
     * @param contentLength Specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set to clear, the value of this header must be set to zero.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentCrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy source.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceModifiedAccessConditions Additional parameters for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURLWithRestResponseAsync(String shareName, String filePath, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        final String fileRangeWriteFromUrl = "update";
        final String comp = "range";
        byte[] sourceIfMatchCrc64 = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64 = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64 = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return service.uploadRangeFromURL(shareName, filePath, this.client.getUrl(), timeout, range, copySource, sourceRange, fileRangeWriteFromUrl, contentLength, sourceContentCrc64Converted, this.client.getVersion(), leaseId, comp, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, context);
    }

    /**
     * Returns the list of valid ranges for a file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesGetRangeListResponse> getRangeListWithRestResponseAsync(String shareName, String filePath, Context context) {
        final String sharesnapshot = null;
        final Integer timeout = null;
        final String range = null;
        final String leaseId = null;
        final String comp = "rangelist";
        return service.getRangeList(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), range, leaseId, comp, context);
    }

    /**
     * Returns the list of valid ranges for a file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param range Specifies the range of bytes over which to list ranges, inclusively.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesGetRangeListResponse> getRangeListWithRestResponseAsync(String shareName, String filePath, String sharesnapshot, Integer timeout, String range, String leaseId, Context context) {
        final String comp = "rangelist";
        return service.getRangeList(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), range, leaseId, comp, context);
    }

    /**
     * Copies a blob or file to a destination file within the storage account.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param copySource Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file within the same storage account, you may use Shared Key to authenticate the source file. If you are copying a file from another storage account, or if you are copying a blob from the same storage account or another storage account, then you must authenticate the source file or blob using a shared access signature. If the source is a public blob, no authentication is required to perform the copy operation. A file in a share snapshot can also be specified as a copy source.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesStartCopyResponse> startCopyWithRestResponseAsync(String shareName, String filePath, String copySource, Context context) {
        final Integer timeout = null;
        final Map<String, String> metadata = null;
        final String filePermission = null;
        final String filePermissionKey = null;
        final String leaseId = null;
        final PermissionCopyModeType filePermissionCopyMode = null;
        final Boolean ignoreReadOnly = null;
        final String fileAttributes = null;
        final String fileCreationTime = null;
        final String fileLastWriteTime = null;
        final Boolean setArchiveAttribute = null;
        return service.startCopy(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, leaseId, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, setArchiveAttribute, context);
    }

    /**
     * Copies a blob or file to a destination file within the storage account.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param copySource Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file within the same storage account, you may use Shared Key to authenticate the source file. If you are copying a file from another storage account, or if you are copying a blob from the same storage account or another storage account, then you must authenticate the source file or blob using a shared access signature. If the source is a public blob, no authentication is required to perform the copy operation. A file in a share snapshot can also be specified as a copy source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param copyFileSmbInfo Additional parameters for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesStartCopyResponse> startCopyWithRestResponseAsync(String shareName, String filePath, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        PermissionCopyModeType filePermissionCopyMode = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyMode = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        Boolean ignoreReadOnly = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnly = copyFileSmbInfo.isIgnoreReadOnly();
        }
        String fileAttributes = null;
        if (copyFileSmbInfo != null) {
            fileAttributes = copyFileSmbInfo.getFileAttributes();
        }
        String fileCreationTime = null;
        if (copyFileSmbInfo != null) {
            fileCreationTime = copyFileSmbInfo.getFileCreationTime();
        }
        String fileLastWriteTime = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTime = copyFileSmbInfo.getFileLastWriteTime();
        }
        Boolean setArchiveAttribute = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttribute = copyFileSmbInfo.isSetArchiveAttribute();
        }
        return service.startCopy(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, leaseId, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, setArchiveAttribute, context);
    }

    /**
     * Aborts a pending Copy File operation, and leaves a destination file with zero length and full metadata.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy File operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesAbortCopyResponse> abortCopyWithRestResponseAsync(String shareName, String filePath, String copyId, Context context) {
        final Integer timeout = null;
        final String copyActionAbortConstant = "abort";
        final String leaseId = null;
        final String comp = "copy";
        return service.abortCopy(shareName, filePath, this.client.getUrl(), copyId, timeout, copyActionAbortConstant, this.client.getVersion(), leaseId, comp, context);
    }

    /**
     * Aborts a pending Copy File operation, and leaves a destination file with zero length and full metadata.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy File operation.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesAbortCopyResponse> abortCopyWithRestResponseAsync(String shareName, String filePath, String copyId, Integer timeout, String leaseId, Context context) {
        final String copyActionAbortConstant = "abort";
        final String comp = "copy";
        return service.abortCopy(shareName, filePath, this.client.getUrl(), copyId, timeout, copyActionAbortConstant, this.client.getVersion(), leaseId, comp, context);
    }

    /**
     * Lists handles for file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String filePath, Context context) {
        final String marker = null;
        final Integer maxresults = null;
        final Integer timeout = null;
        final String sharesnapshot = null;
        final String comp = "listhandles";
        return service.listHandles(shareName, filePath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), comp, context);
    }

    /**
     * Lists handles for file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation. The operation returns a marker value within the response body if the list returned was not complete. The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults, or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String filePath, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        final String comp = "listhandles";
        return service.listHandles(shareName, filePath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), comp, context);
    }

    /**
     * Closes all handles open for given file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterix (‘*’) is a wildcard that specifies all handles.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String filePath, String handleId, Context context) {
        final Integer timeout = null;
        final String marker = null;
        final String sharesnapshot = null;
        final String comp = "forceclosehandles";
        return service.forceCloseHandles(shareName, filePath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, this.client.getVersion(), comp, context);
    }

    /**
     * Closes all handles open for given file.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterix (‘*’) is a wildcard that specifies all handles.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation. The operation returns a marker value within the response body if the list returned was not complete. The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to the client.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String filePath, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        final String comp = "forceclosehandles";
        return service.forceCloseHandles(shareName, filePath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, this.client.getVersion(), comp, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String shareName, String filePath, Context context) {
        final Integer timeout = null;
        final Integer duration = null;
        final String proposedLeaseId = null;
        final String requestId = null;
        final String comp = "lease";
        final String action = "acquire";
        return service.acquireLease(shareName, filePath, this.client.getUrl(), timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID string formats.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String shareName, String filePath, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        final String comp = "lease";
        final String action = "acquire";
        return service.acquireLease(shareName, filePath, this.client.getUrl(), timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Context context) {
        final Integer timeout = null;
        final String requestId = null;
        final String comp = "lease";
        final String action = "release";
        return service.releaseLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Integer timeout, String requestId, Context context) {
        final String comp = "lease";
        final String action = "release";
        return service.releaseLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesChangeLeaseResponse> changeLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Context context) {
        final Integer timeout = null;
        final String proposedLeaseId = null;
        final String requestId = null;
        final String comp = "lease";
        final String action = "change";
        return service.changeLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID string formats.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesChangeLeaseResponse> changeLeaseWithRestResponseAsync(String shareName, String filePath, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        final String comp = "lease";
        final String action = "change";
        return service.changeLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesBreakLeaseResponse> breakLeaseWithRestResponseAsync(String shareName, String filePath, Context context) {
        final Integer timeout = null;
        final String leaseId = null;
        final String requestId = null;
        final String comp = "lease";
        final String action = "break";
        return service.breakLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, comp, action, context);
    }

    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations.
     *
     * @param shareName The name of the target share.
     * @param filePath The path of the target file.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @return a Mono which performs the network request upon subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilesBreakLeaseResponse> breakLeaseWithRestResponseAsync(String shareName, String filePath, Integer timeout, String leaseId, String requestId, Context context) {
        final String comp = "lease";
        final String action = "break";
        return service.breakLease(shareName, filePath, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, comp, action, context);
    }
}
