// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Properties of a share.
 */
@JacksonXmlRootElement(localName = "ShareProperties")
@Fluent
public final class ShareProperties {
    /*
     * The lastModified property.
     */
    @JsonProperty(value = "Last-Modified", required = true)
    private DateTimeRfc1123 lastModified;

    /*
     * The eTag property.
     */
    @JsonProperty(value = "Etag", required = true)
    private String eTag;

    /*
     * The quota property.
     */
    @JsonProperty(value = "Quota", required = true)
    private int quota;

    /*
     * The provisionedIops property.
     */
    @JsonProperty(value = "ProvisionedIops")
    private Integer provisionedIops;

    /*
     * The provisionedIngressMBps property.
     */
    @JsonProperty(value = "ProvisionedIngressMBps")
    private Integer provisionedIngressMBps;

    /*
     * The provisionedEgressMBps property.
     */
    @JsonProperty(value = "ProvisionedEgressMBps")
    private Integer provisionedEgressMBps;

    /*
     * The nextAllowedQuotaDowngradeTime property.
     */
    @JsonProperty(value = "NextAllowedQuotaDowngradeTime")
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;

    /*
     * The deletedTime property.
     */
    @JsonProperty(value = "DeletedTime")
    private DateTimeRfc1123 deletedTime;

    /*
     * The remainingRetentionDays property.
     */
    @JsonProperty(value = "RemainingRetentionDays")
    private Integer remainingRetentionDays;

    /*
     * The metadata property.
     */
    @JsonProperty(value = "Metadata")
    private Map<String, String> metadata;

    /**
     * Get the lastModified property: The lastModified property.
     *
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The lastModified property.
     *
     * @param lastModified the lastModified value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the eTag property: The eTag property.
     *
     * @return the eTag value.
     */
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The eTag property.
     *
     * @param eTag the eTag value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the quota property: The quota property.
     *
     * @return the quota value.
     */
    public int getQuota() {
        return this.quota;
    }

    /**
     * Set the quota property: The quota property.
     *
     * @param quota the quota value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    /**
     * Get the provisionedIops property: The provisionedIops property.
     *
     * @return the provisionedIops value.
     */
    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    /**
     * Set the provisionedIops property: The provisionedIops property.
     *
     * @param provisionedIops the provisionedIops value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    /**
     * Get the provisionedIngressMBps property: The provisionedIngressMBps
     * property.
     *
     * @return the provisionedIngressMBps value.
     */
    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    /**
     * Set the provisionedIngressMBps property: The provisionedIngressMBps
     * property.
     *
     * @param provisionedIngressMBps the provisionedIngressMBps value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    /**
     * Get the provisionedEgressMBps property: The provisionedEgressMBps
     * property.
     *
     * @return the provisionedEgressMBps value.
     */
    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    /**
     * Set the provisionedEgressMBps property: The provisionedEgressMBps
     * property.
     *
     * @param provisionedEgressMBps the provisionedEgressMBps value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    /**
     * Get the nextAllowedQuotaDowngradeTime property: The
     * nextAllowedQuotaDowngradeTime property.
     *
     * @return the nextAllowedQuotaDowngradeTime value.
     */
    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    /**
     * Set the nextAllowedQuotaDowngradeTime property: The
     * nextAllowedQuotaDowngradeTime property.
     *
     * @param nextAllowedQuotaDowngradeTime the nextAllowedQuotaDowngradeTime
     * value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        if (nextAllowedQuotaDowngradeTime == null) {
            this.nextAllowedQuotaDowngradeTime = null;
        } else {
            this.nextAllowedQuotaDowngradeTime = new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        }
        return this;
    }

    /**
     * Get the deletedTime property: The deletedTime property.
     *
     * @return the deletedTime value.
     */
    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    /**
     * Set the deletedTime property: The deletedTime property.
     *
     * @param deletedTime the deletedTime value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setDeletedTime(OffsetDateTime deletedTime) {
        if (deletedTime == null) {
            this.deletedTime = null;
        } else {
            this.deletedTime = new DateTimeRfc1123(deletedTime);
        }
        return this;
    }

    /**
     * Get the remainingRetentionDays property: The remainingRetentionDays
     * property.
     *
     * @return the remainingRetentionDays value.
     */
    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    /**
     * Set the remainingRetentionDays property: The remainingRetentionDays
     * property.
     *
     * @param remainingRetentionDays the remainingRetentionDays value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    /**
     * Get the metadata property: The metadata property.
     *
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The metadata property.
     *
     * @param metadata the metadata value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}
