/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareDirectoryAsyncClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.ShareCreatePermissionHeaders;
import com.azure.storage.file.share.implementation.models.ShareCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.ShareGetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.ShareGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotResponse;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsResponse;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareInfo;
import com.azure.storage.file.share.models.ShareProperties;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareSnapshotInfo;
import com.azure.storage.file.share.models.ShareStatistics;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class ShareAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareAsyncClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;

    ShareAsyncClient(AzureFileStorageImpl client, String shareName, String snapshot, String accountName, ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        this.shareName = shareName;
        this.snapshot = snapshot;
        this.accountName = accountName;
        this.azureFileStorageClient = client;
        this.serviceVersion = serviceVersion;
    }

    public String getShareUrl() {
        StringBuilder shareUrlString = new StringBuilder(this.azureFileStorageClient.getUrl()).append("/").append(this.shareName);
        if (this.snapshot != null) {
            shareUrlString.append("?snapshot=").append(this.snapshot);
        }
        return shareUrlString.toString();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareDirectoryAsyncClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public ShareDirectoryAsyncClient getDirectoryClient(String directoryName) {
        return new ShareDirectoryAsyncClient(this.azureFileStorageClient, this.shareName, directoryName, this.snapshot, this.accountName, this.serviceVersion);
    }

    public ShareFileAsyncClient getFileClient(String filePath) {
        return new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, this.snapshot, this.accountName, this.serviceVersion);
    }

    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.existsWithResponse((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof ShareStorageException && ((ShareStorageException)((Object)((Object)t))).getStatusCode() == 404 && ((ShareStorageException)((Object)((Object)t))).getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND, t -> {
            HttpResponse response = ((ShareStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    public Mono<ShareInfo> create() {
        try {
            return this.createWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareInfo>> createWithResponse(Map<String, String> metadata, Integer quotaInGB) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(metadata, quotaInGB, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> createWithResponse(Map<String, String> metadata, Integer quotaInGB, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().createWithRestResponseAsync(this.shareName, null, metadata, quotaInGB, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    public Mono<ShareSnapshotInfo> createSnapshot() {
        try {
            return this.createSnapshotWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareSnapshotInfo>> createSnapshotWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createSnapshotWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareSnapshotInfo>> createSnapshotWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().createSnapshotWithRestResponseAsync(this.shareName, null, metadata, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapCreateSnapshotResponse);
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().deleteWithRestResponseAsync(this.shareName, this.snapshot, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<ShareProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().getPropertiesWithRestResponseAsync(this.shareName, this.snapshot, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapGetPropertiesResponse);
    }

    public Mono<ShareInfo> setQuota(int quotaInGB) {
        try {
            return this.setQuotaWithResponse(quotaInGB).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareInfo>> setQuotaWithResponse(int quotaInGB) {
        try {
            return FluxUtil.withContext(context -> this.setQuotaWithResponse(quotaInGB, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> setQuotaWithResponse(int quotaInGB, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().setQuotaWithRestResponseAsync(this.shareName, null, quotaInGB, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    public Mono<ShareInfo> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareInfo>> setMetadataWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> setMetadataWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().setMetadataWithRestResponseAsync(this.shareName, null, metadata, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    public PagedFlux<ShareSignedIdentifier> getAccessPolicy() {
        try {
            Function<String, Mono> retriever = marker -> this.azureFileStorageClient.shares().getAccessPolicyWithRestResponseAsync(this.shareName, Context.NONE).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, (Object)((ShareGetAccessPolicyHeaders)response.getDeserializedHeaders())));
            return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<ShareInfo> setAccessPolicy(List<ShareSignedIdentifier> permissions) {
        try {
            return this.setAccessPolicyWithResponse(permissions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareInfo>> setAccessPolicyWithResponse(List<ShareSignedIdentifier> permissions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(permissions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareInfo>> setAccessPolicyWithResponse(List<ShareSignedIdentifier> permissions, Context context) {
        if (permissions != null) {
            for (ShareSignedIdentifier permission : permissions) {
                if (permission.getAccessPolicy() != null && permission.getAccessPolicy().getStartsOn() != null) {
                    permission.getAccessPolicy().setStartsOn(permission.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (permission.getAccessPolicy() == null || permission.getAccessPolicy().getExpiresOn() == null) continue;
                permission.getAccessPolicy().setExpiresOn(permission.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().setAccessPolicyWithRestResponseAsync(this.shareName, permissions, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapToShareInfoResponse);
    }

    public Mono<ShareStatistics> getStatistics() {
        try {
            return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareStatistics>> getStatisticsWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.getStatisticsWithResponse((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareStatistics>> getStatisticsWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.shares().getStatisticsWithRestResponseAsync(this.shareName, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::mapGetStatisticsResponse);
    }

    public Mono<ShareDirectoryAsyncClient> createDirectory(String directoryName) {
        try {
            return this.createDirectoryWithResponse(directoryName, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createDirectoryWithResponse(directoryName, smbProperties, filePermission, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Context context) {
        ShareDirectoryAsyncClient shareDirectoryAsyncClient = this.getDirectoryClient(directoryName);
        return shareDirectoryAsyncClient.createWithResponse(smbProperties, filePermission, metadata).map(response -> new SimpleResponse(response, (Object)shareDirectoryAsyncClient));
    }

    public Mono<ShareFileAsyncClient> createFile(String fileName, long maxSize) {
        try {
            return this.createFileWithResponse(fileName, maxSize, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null);
    }

    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        ShareFileAsyncClient shareFileAsyncClient = this.getFileClient(fileName);
        return shareFileAsyncClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, context).map(response -> new SimpleResponse(response, (Object)shareFileAsyncClient));
    }

    public Mono<Void> deleteDirectory(String directoryName) {
        try {
            return this.deleteDirectoryWithResponse(directoryName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName) {
        try {
            return FluxUtil.withContext(context -> this.deleteDirectoryWithResponse(directoryName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName, Context context) {
        return this.getDirectoryClient(directoryName).deleteWithResponse(context);
    }

    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteFileWithResponse(String fileName) {
        return this.deleteFileWithResponse(fileName, null);
    }

    public Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteFileWithResponse(fileName, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, context);
    }

    public Mono<String> createPermission(String filePermission) {
        try {
            return this.createPermissionWithResponse(filePermission).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> createPermissionWithResponse(String filePermission) {
        try {
            return FluxUtil.withContext(context -> this.createPermissionWithResponse(filePermission, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> createPermissionWithResponse(String filePermission, Context context) {
        SharePermission sharePermission = new SharePermission().setPermission(filePermission);
        return this.azureFileStorageClient.shares().createPermissionWithRestResponseAsync(this.shareName, sharePermission, null, context).map(response -> new SimpleResponse((Response)response, (Object)((ShareCreatePermissionHeaders)response.getDeserializedHeaders()).getFilePermissionKey()));
    }

    public Mono<String> getPermission(String filePermissionKey) {
        try {
            return this.getPermissionWithResponse(filePermissionKey).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> getPermissionWithResponse(String filePermissionKey) {
        try {
            return FluxUtil.withContext(context -> this.getPermissionWithResponse(filePermissionKey, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> getPermissionWithResponse(String filePermissionKey, Context context) {
        return this.azureFileStorageClient.shares().getPermissionWithRestResponseAsync(this.shareName, filePermissionKey, null, context).map(response -> new SimpleResponse((Response)response, (Object)response.getValue().getPermission()));
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }

    private Response<ShareInfo> mapToShareInfoResponse(Response<?> response) {
        String eTag = response.getHeaders().getValue("ETag");
        OffsetDateTime lastModified = new DateTimeRfc1123(response.getHeaders().getValue("Last-Modified")).getDateTime();
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new ShareInfo(eTag, lastModified));
    }

    private Response<ShareSnapshotInfo> mapCreateSnapshotResponse(SharesCreateSnapshotResponse response) {
        ShareCreateSnapshotHeaders headers = (ShareCreateSnapshotHeaders)response.getDeserializedHeaders();
        ShareSnapshotInfo snapshotInfo = new ShareSnapshotInfo(headers.getSnapshot(), headers.getETag(), headers.getLastModified());
        return new SimpleResponse((Response)response, (Object)snapshotInfo);
    }

    private Response<ShareProperties> mapGetPropertiesResponse(SharesGetPropertiesResponse response) {
        ShareGetPropertiesHeaders headers = (ShareGetPropertiesHeaders)response.getDeserializedHeaders();
        ShareProperties shareProperties = new ShareProperties().setQuota(headers.getQuota()).setETag(headers.getETag()).setLastModified(headers.getLastModified()).setMetadata(headers.getMetadata()).setQuota(headers.getQuota()).setNextAllowedQuotaDowngradeTime(headers.getNextAllowedQuotaDowngradeTime()).setProvisionedEgressMBps(headers.getProvisionedEgressMBps()).setProvisionedIngressMBps(headers.getProvisionedIngressMBps()).setProvisionedIops(headers.getProvisionedIops());
        return new SimpleResponse((Response)response, (Object)shareProperties);
    }

    private Response<ShareStatistics> mapGetStatisticsResponse(SharesGetStatisticsResponse response) {
        ShareStatistics shareStatistics = new ShareStatistics(response.getValue().getShareUsageBytes());
        return new SimpleResponse((Response)response, (Object)shareStatistics);
    }
}

