/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DirectoryCreateHeaders;
import com.azure.storage.file.share.implementation.models.DirectoryForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoryGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoryListFilesAndDirectoriesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.DirectoryListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectorySetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.DirectorySetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectorysCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectorysGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectorysListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectorysSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectorysSetPropertiesResponse;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.azure.storage.file.share.models.ShareDirectoryProperties;
import com.azure.storage.file.share.models.ShareDirectorySetMetadataInfo;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class ShareDirectoryAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareDirectoryAsyncClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String directoryPath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;

    ShareDirectoryAsyncClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String directoryPath, String snapshot, String accountName, ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(directoryPath);
        this.shareName = shareName;
        this.directoryPath = directoryPath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
    }

    public String getDirectoryUrl() {
        StringBuilder directoryUrlString = new StringBuilder(this.azureFileStorageClient.getUrl()).append("/").append(this.shareName).append("/").append(this.directoryPath);
        if (this.snapshot != null) {
            directoryUrlString.append("?snapshot=").append(this.snapshot);
        }
        return directoryUrlString.toString();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareFileAsyncClient getFileClient(String fileName) {
        String filePath = this.directoryPath + "/" + fileName;
        if (this.directoryPath.isEmpty()) {
            filePath = fileName;
        }
        return new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, null, this.accountName, this.serviceVersion);
    }

    public ShareDirectoryAsyncClient getSubdirectoryClient(String subdirectoryName) {
        String directoryPath = this.directoryPath + "/" + subdirectoryName;
        return new ShareDirectoryAsyncClient(this.azureFileStorageClient, this.shareName, directoryPath, this.snapshot, this.accountName, this.serviceVersion);
    }

    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(this::checkDoesNotExistStatusCode, t -> {
            HttpResponse response = ((ShareStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    private boolean checkDoesNotExistStatusCode(Throwable t) {
        return t instanceof ShareStorageException && ((ShareStorageException)((Object)t)).getStatusCode() == 404 && (((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.RESOURCE_NOT_FOUND || ((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND);
    }

    public Mono<ShareDirectoryInfo> create() {
        try {
            return this.createWithResponse(null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareDirectoryInfo>> createWithResponse(FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(smbProperties, filePermission, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryInfo>> createWithResponse(FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Context context) {
        FileSmbProperties properties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        this.validateFilePermissionAndKey(filePermission, properties.getFilePermissionKey());
        filePermission = properties.setFilePermission(filePermission, "Inherit");
        String filePermissionKey = properties.getFilePermissionKey();
        String fileAttributes = properties.setNtfsFileAttributes("None");
        String fileCreationTime = properties.setFileCreationTime("Now");
        String fileLastWriteTime = properties.setFileLastWriteTime("Now");
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.directorys().createWithRestResponseAsync(this.shareName, this.directoryPath, fileAttributes, fileCreationTime, fileLastWriteTime, null, metadata, filePermission, filePermissionKey, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::createWithRestResponse);
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse() {
        try {
            return FluxUtil.withContext(this::deleteWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.directorys().deleteWithRestResponseAsync(this.shareName, this.directoryPath, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<ShareDirectoryProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareDirectoryProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.directorys().getPropertiesWithRestResponseAsync(this.shareName, this.directoryPath, this.snapshot, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::getPropertiesResponse);
    }

    public Mono<ShareDirectoryInfo> setProperties(FileSmbProperties smbProperties, String filePermission) {
        try {
            return this.setPropertiesWithResponse(smbProperties, filePermission).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareDirectoryInfo>> setPropertiesWithResponse(FileSmbProperties smbProperties, String filePermission) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(smbProperties, filePermission, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryInfo>> setPropertiesWithResponse(FileSmbProperties smbProperties, String filePermission, Context context) {
        FileSmbProperties properties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        this.validateFilePermissionAndKey(filePermission, properties.getFilePermissionKey());
        filePermission = properties.setFilePermission(filePermission, "Preserve");
        String filePermissionKey = properties.getFilePermissionKey();
        String fileAttributes = properties.setNtfsFileAttributes("Preserve");
        String fileCreationTime = properties.setFileCreationTime("Preserve");
        String fileLastWriteTime = properties.setFileLastWriteTime("Preserve");
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.directorys().setPropertiesWithRestResponseAsync(this.shareName, this.directoryPath, fileAttributes, fileCreationTime, fileLastWriteTime, null, filePermission, filePermissionKey, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::setPropertiesResponse);
    }

    public Mono<ShareDirectorySetMetadataInfo> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareDirectorySetMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectorySetMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.directorys().setMetadataWithRestResponseAsync(this.shareName, this.directoryPath, null, metadata, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::setMetadataResponse);
    }

    public PagedFlux<ShareFileItem> listFilesAndDirectories() {
        try {
            return this.listFilesAndDirectories(null, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<ShareFileItem> listFilesAndDirectories(String prefix, Integer maxResultsPerPage) {
        try {
            return this.listFilesAndDirectoriesWithOptionalTimeout(prefix, maxResultsPerPage, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<ShareFileItem> listFilesAndDirectoriesWithOptionalTimeout(String prefix, Integer maxResultsPerPage, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.directorys().listFilesAndDirectoriesSegmentWithRestResponseAsync(this.shareName, this.directoryPath, prefix, this.snapshot, (String)marker, maxResultsPerPage, null, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), this.convertResponseAndGetNumOfResults((DirectorysListFilesAndDirectoriesSegmentResponse)((Object)((Object)response))), response.getValue().getNextMarker(), (Object)((DirectoryListFilesAndDirectoriesSegmentHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public PagedFlux<HandleItem> listHandles(Integer maxResultPerPage, boolean recursive) {
        try {
            return this.listHandlesWithOptionalTimeout(maxResultPerPage, recursive, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<HandleItem> listHandlesWithOptionalTimeout(Integer maxResultPerPage, boolean recursive, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.directorys().listHandlesWithRestResponseAsync(this.shareName, this.directoryPath, (String)marker, maxResultPerPage, null, this.snapshot, recursive, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().getHandleList(), response.getValue().getNextMarker(), (Object)((DirectoryListHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public Mono<CloseHandlesInfo> forceCloseHandle(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId, Context context) {
        return this.azureFileStorageClient.directorys().forceCloseHandlesWithRestResponseAsync(this.shareName, this.directoryPath, handleId, null, null, this.snapshot, false, context).map(response -> new SimpleResponse((Response)response, (Object)new CloseHandlesInfo(((DirectoryForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesClosed(), ((DirectoryForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesFailedToClose())));
    }

    public Mono<CloseHandlesInfo> forceCloseAllHandles(boolean recursive) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseAllHandlesWithTimeout(recursive, null, (Context)context).reduce((Object)new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<CloseHandlesInfo> forceCloseAllHandlesWithTimeout(boolean recursive, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.directorys().forceCloseHandlesWithRestResponseAsync(this.shareName, this.directoryPath, "*", null, (String)marker, this.snapshot, recursive, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((DirectoryForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesClosed(), ((DirectoryForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesFailedToClose())), ((DirectoryForceCloseHandlesHeaders)response.getDeserializedHeaders()).getMarker(), (Object)((DirectoryForceCloseHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public Mono<ShareDirectoryAsyncClient> createSubdirectory(String subdirectoryName) {
        try {
            return this.createSubdirectoryWithResponse(subdirectoryName, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareDirectoryAsyncClient>> createSubdirectoryWithResponse(String subdirectoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createSubdirectoryWithResponse(subdirectoryName, smbProperties, filePermission, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryAsyncClient>> createSubdirectoryWithResponse(String subdirectoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Context context) {
        ShareDirectoryAsyncClient createSubClient = this.getSubdirectoryClient(subdirectoryName);
        return createSubClient.createWithResponse(smbProperties, filePermission, metadata, context).map(response -> new SimpleResponse(response, (Object)createSubClient));
    }

    public Mono<Void> deleteSubdirectory(String subdirectoryName) {
        try {
            return this.deleteSubdirectoryWithResponse(subdirectoryName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteSubdirectoryWithResponse(String subdirectoryName) {
        try {
            return FluxUtil.withContext(context -> this.deleteSubdirectoryWithResponse(subdirectoryName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteSubdirectoryWithResponse(String subdirectoryName, Context context) {
        ShareDirectoryAsyncClient deleteSubClient = this.getSubdirectoryClient(subdirectoryName);
        return deleteSubClient.deleteWithResponse(context);
    }

    public Mono<ShareFileAsyncClient> createFile(String fileName, long maxSize) {
        try {
            return this.createFileWithResponse(fileName, maxSize, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null);
    }

    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        ShareFileAsyncClient shareFileAsyncClient = this.getFileClient(fileName);
        return shareFileAsyncClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, context).map(response -> new SimpleResponse(response, (Object)shareFileAsyncClient));
    }

    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteFileWithResponse(String fileName) {
        return this.deleteFileWithResponse(fileName, null);
    }

    public Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteFileWithResponse(fileName, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Context context) {
        ShareFileAsyncClient shareFileAsyncClient = this.getFileClient(fileName);
        return shareFileAsyncClient.deleteWithResponse(requestConditions, context);
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getDirectoryPath()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }

    private Response<ShareDirectoryInfo> createWithRestResponse(DirectorysCreateResponse response) {
        String eTag = ((DirectoryCreateHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((DirectoryCreateHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareDirectoryInfo shareDirectoryInfo = new ShareDirectoryInfo(eTag, lastModified, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareDirectoryInfo);
    }

    private Response<ShareDirectoryProperties> getPropertiesResponse(DirectorysGetPropertiesResponse response) {
        Map<String, String> metadata = ((DirectoryGetPropertiesHeaders)response.getDeserializedHeaders()).getMetadata();
        String eTag = ((DirectoryGetPropertiesHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime offsetDateTime = ((DirectoryGetPropertiesHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((DirectoryGetPropertiesHeaders)response.getDeserializedHeaders()).isServerEncrypted();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareDirectoryProperties shareDirectoryProperties = new ShareDirectoryProperties(metadata, eTag, offsetDateTime, isServerEncrypted, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareDirectoryProperties);
    }

    private Response<ShareDirectoryInfo> setPropertiesResponse(DirectorysSetPropertiesResponse response) {
        String eTag = ((DirectorySetPropertiesHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((DirectorySetPropertiesHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareDirectoryInfo shareDirectoryInfo = new ShareDirectoryInfo(eTag, lastModified, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareDirectoryInfo);
    }

    private Response<ShareDirectorySetMetadataInfo> setMetadataResponse(DirectorysSetMetadataResponse response) {
        String eTag = ((DirectorySetMetadataHeaders)response.getDeserializedHeaders()).getETag();
        boolean isServerEncrypted = ((DirectorySetMetadataHeaders)response.getDeserializedHeaders()).isServerEncrypted();
        ShareDirectorySetMetadataInfo shareDirectorySetMetadataInfo = new ShareDirectorySetMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)shareDirectorySetMetadataInfo);
    }

    private List<ShareFileItem> convertResponseAndGetNumOfResults(DirectorysListFilesAndDirectoriesSegmentResponse response) {
        TreeSet<ShareFileItem> shareFileItems = new TreeSet<ShareFileItem>(Comparator.comparing(ShareFileItem::getName));
        if (response.getValue().getSegment() != null) {
            response.getValue().getSegment().getDirectoryItems().forEach(directoryItem -> shareFileItems.add(new ShareFileItem(directoryItem.getName(), true, null)));
            response.getValue().getSegment().getFileItems().forEach(fileItem -> shareFileItems.add(new ShareFileItem(fileItem.getName(), false, fileItem.getProperties().getContentLength())));
        }
        return new ArrayList<ShareFileItem>(shareFileItems);
    }

    private void validateFilePermissionAndKey(String filePermission, String filePermissionKey) {
        if (filePermission != null && filePermissionKey != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key cannot both be set"));
        }
        if (filePermission != null) {
            StorageImplUtils.assertInBounds((String)"filePermission", (long)filePermission.getBytes(StandardCharsets.UTF_8).length, (long)0L, (long)8192L);
        }
    }
}

