/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.file.share.ShareAsyncClient;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareServiceAsyncClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.models.ListSharesOptions;
import com.azure.storage.file.share.models.ShareItem;
import com.azure.storage.file.share.models.ShareServiceProperties;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class ShareServiceClient {
    private final ShareServiceAsyncClient shareServiceAsyncClient;

    ShareServiceClient(ShareServiceAsyncClient client) {
        this.shareServiceAsyncClient = client;
    }

    public String getFileServiceUrl() {
        return this.shareServiceAsyncClient.getFileServiceUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.shareServiceAsyncClient.getServiceVersion();
    }

    public ShareClient getShareClient(String shareName) {
        return new ShareClient(this.shareServiceAsyncClient.getShareAsyncClient(shareName));
    }

    public PagedIterable<ShareItem> listShares() {
        return this.listShares(null, null, null);
    }

    public PagedIterable<ShareItem> listShares(ListSharesOptions options, Duration timeout, Context context) {
        return new PagedIterable(this.shareServiceAsyncClient.listSharesWithOptionalTimeout(null, options, timeout, context));
    }

    public ShareServiceProperties getProperties() {
        return (ShareServiceProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    public Response<ShareServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Mono<Response<ShareServiceProperties>> response = this.shareServiceAsyncClient.getPropertiesWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void setProperties(ShareServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    public Response<Void> setPropertiesWithResponse(ShareServiceProperties properties, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareServiceAsyncClient.setPropertiesWithResponse(properties, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareClient createShare(String shareName) {
        return (ShareClient)this.createShareWithResponse(shareName, null, null, null, Context.NONE).getValue();
    }

    public Response<ShareClient> createShareWithResponse(String shareName, Map<String, String> metadata, Integer quotaInGB, Duration timeout, Context context) {
        ShareClient shareClient = this.getShareClient(shareName);
        return new SimpleResponse(shareClient.createWithResponse(metadata, quotaInGB, null, context), (Object)shareClient);
    }

    public void deleteShare(String shareName) {
        this.deleteShareWithResponse(shareName, null, null, Context.NONE);
    }

    public Response<Void> deleteShareWithResponse(String shareName, String snapshot, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareServiceAsyncClient.deleteShareWithResponse(shareName, snapshot, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String getAccountName() {
        return this.shareServiceAsyncClient.getAccountName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.shareServiceAsyncClient.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.shareServiceAsyncClient.generateAccountSas(accountSasSignatureValues);
    }

    public ShareClient undeleteShare(String deletedShareName, String deletedShareVersion) {
        return (ShareClient)this.undeleteShareWithResponse(deletedShareName, deletedShareVersion, null, Context.NONE).getValue();
    }

    public Response<ShareClient> undeleteShareWithResponse(String deletedShareName, String deletedShareVersion, Duration timeout, Context context) {
        Mono response = this.shareServiceAsyncClient.undeleteShareWithResponse(deletedShareName, deletedShareVersion, context).map(r -> new SimpleResponse(r, (Object)this.getShareClient(((ShareAsyncClient)r.getValue()).getShareName())));
        return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)response, (Duration)timeout);
    }
}

