/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Directory-GetProperties-Headers")
public final class DirectoryGetPropertiesHeaders {
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-file-attributes")
    private String fileAttributes;
    @JsonProperty(value="x-ms-file-creation-time")
    private OffsetDateTime fileCreationTime;
    @JsonProperty(value="x-ms-file-last-write-time")
    private OffsetDateTime fileLastWriteTime;
    @JsonProperty(value="x-ms-file-change-time")
    private OffsetDateTime fileChangeTime;
    @JsonProperty(value="x-ms-file-permission-key")
    private String filePermissionKey;
    @JsonProperty(value="x-ms-file-id")
    private String fileId;
    @JsonProperty(value="x-ms-file-parent-id")
    private String fileParentId;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public DirectoryGetPropertiesHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public DirectoryGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public DirectoryGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public DirectoryGetPropertiesHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public DirectoryGetPropertiesHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public DirectoryGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public DirectoryGetPropertiesHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String getFileAttributes() {
        return this.fileAttributes;
    }

    public DirectoryGetPropertiesHeaders setFileAttributes(String fileAttributes) {
        this.fileAttributes = fileAttributes;
        return this;
    }

    public OffsetDateTime getFileCreationTime() {
        return this.fileCreationTime;
    }

    public DirectoryGetPropertiesHeaders setFileCreationTime(OffsetDateTime fileCreationTime) {
        this.fileCreationTime = fileCreationTime;
        return this;
    }

    public OffsetDateTime getFileLastWriteTime() {
        return this.fileLastWriteTime;
    }

    public DirectoryGetPropertiesHeaders setFileLastWriteTime(OffsetDateTime fileLastWriteTime) {
        this.fileLastWriteTime = fileLastWriteTime;
        return this;
    }

    public OffsetDateTime getFileChangeTime() {
        return this.fileChangeTime;
    }

    public DirectoryGetPropertiesHeaders setFileChangeTime(OffsetDateTime fileChangeTime) {
        this.fileChangeTime = fileChangeTime;
        return this;
    }

    public String getFilePermissionKey() {
        return this.filePermissionKey;
    }

    public DirectoryGetPropertiesHeaders setFilePermissionKey(String filePermissionKey) {
        this.filePermissionKey = filePermissionKey;
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public DirectoryGetPropertiesHeaders setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String getFileParentId() {
        return this.fileParentId;
    }

    public DirectoryGetPropertiesHeaders setFileParentId(String fileParentId) {
        this.fileParentId = fileParentId;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public DirectoryGetPropertiesHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

