/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="File-UploadRangeFromURL-Headers")
public final class FileUploadRangeFromURLHeaders {
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] xMsContentCrc64;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public String getETag() {
        return this.eTag;
    }

    public FileUploadRangeFromURLHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FileUploadRangeFromURLHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone((byte[])this.xMsContentCrc64);
    }

    public FileUploadRangeFromURLHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone((byte[])xMsContentCrc64);
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public FileUploadRangeFromURLHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public FileUploadRangeFromURLHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public FileUploadRangeFromURLHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public FileUploadRangeFromURLHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public FileUploadRangeFromURLHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

