/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="ShareProperties")
public final class ShareProperties {
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String eTag;
    @JsonProperty(value="Quota", required=true)
    private int quota;
    @JsonProperty(value="ProvisionedIops")
    private Integer provisionedIops;
    @JsonProperty(value="ProvisionedIngressMBps")
    private Integer provisionedIngressMBps;
    @JsonProperty(value="ProvisionedEgressMBps")
    private Integer provisionedEgressMBps;
    @JsonProperty(value="NextAllowedQuotaDowngradeTime")
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    @JsonProperty(value="DeletedTime")
    private DateTimeRfc1123 deletedTime;
    @JsonProperty(value="RemainingRetentionDays")
    private Integer remainingRetentionDays;
    @JsonProperty(value="Metadata")
    private Map<String, String> metadata;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ShareProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ShareProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public int getQuota() {
        return this.quota;
    }

    public ShareProperties setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    public ShareProperties setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    public ShareProperties setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    public ShareProperties setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public ShareProperties setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        this.nextAllowedQuotaDowngradeTime = nextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public ShareProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

