/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.file.share.implementation.AzureFileStorageBuilder;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.FileAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FileChangeLeaseHeaders;
import reactor.core.publisher.Mono;

public final class ShareLeaseAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareLeaseAsyncClient.class);
    private final String leaseId;
    private final AzureFileStorageImpl client;
    private final String accountName;

    ShareLeaseAsyncClient(HttpPipeline pipeline, String url, String leaseId, String accountName, String serviceVersion) {
        this.leaseId = leaseId;
        this.client = new AzureFileStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion).build();
        this.accountName = accountName;
    }

    public String getFileUrl() {
        return this.client.getUrl();
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public Mono<String> acquireLease() {
        try {
            return this.acquireLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> acquireLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::acquireLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> acquireLeaseWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.files().acquireLeaseWithRestResponseAsync(null, null, null, -1, this.leaseId, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((FileAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<Void> releaseLease() {
        try {
            return this.releaseLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> releaseLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::releaseLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> releaseLeaseWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.files().releaseLeaseWithRestResponseAsync(null, null, this.leaseId, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> breakLease() {
        try {
            return this.breakLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> breakLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::breakLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> breakLeaseWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.files().breakLeaseWithRestResponseAsync(null, null, null, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, null));
    }

    public Mono<String> changeLease(String proposedId) {
        try {
            return this.changeLeaseWithResponse(proposedId).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> changeLeaseWithResponse(String proposedId) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(proposedId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> changeLeaseWithResponse(String proposedId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.files().changeLeaseWithRestResponseAsync(null, null, this.leaseId, null, proposedId, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((FileChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public String getAccountName() {
        return this.accountName;
    }
}

