/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.ListSharesIncludeType;
import com.azure.storage.file.share.implementation.models.ServicesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentResponse;
import com.azure.storage.file.share.implementation.models.ServicesSetPropertiesResponse;
import com.azure.storage.file.share.models.ShareServiceProperties;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private ServicesService service;
    private AzureFileStorageImpl client;

    public ServicesImpl(AzureFileStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(ShareServiceProperties shareServiceProperties, Context context) {
        Integer timeout = null;
        String restype = "service";
        String comp = "properties";
        return this.service.setProperties(this.client.getUrl(), shareServiceProperties, timeout, this.client.getVersion(), "service", "properties", context);
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout, Context context) {
        String restype = "service";
        String comp = "properties";
        return this.service.setProperties(this.client.getUrl(), shareServiceProperties, timeout, this.client.getVersion(), "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String restype = "service";
        String comp = "properties";
        return this.service.getProperties(this.client.getUrl(), timeout, this.client.getVersion(), "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Integer timeout, Context context) {
        String restype = "service";
        String comp = "properties";
        return this.service.getProperties(this.client.getUrl(), timeout, this.client.getVersion(), "service", "properties", context);
    }

    public Mono<ServicesListSharesSegmentResponse> listSharesSegmentWithRestResponseAsync(Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String comp = "list";
        String includeConverted = null;
        return this.service.listSharesSegment(this.client.getUrl(), prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), "list", context);
    }

    public Mono<ServicesListSharesSegmentResponse> listSharesSegmentWithRestResponseAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        String comp = "list";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listSharesSegment(this.client.getUrl(), prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), "list", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageServices")
    private static interface ServicesService {
        @Put(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ServicesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") ShareServiceProperties var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ServicesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, Context var6);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ServicesListSharesSegmentResponse> listSharesSegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="marker") String var3, @QueryParam(value="maxresults") Integer var4, @QueryParam(value="include") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @QueryParam(value="comp") String var8, Context var9);
    }
}

