/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.FileCreateHeaders;
import com.azure.storage.file.share.implementation.models.FileForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FileGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.FileListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FileSetHTTPHeadersHeaders;
import com.azure.storage.file.share.implementation.models.FileSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.FileStartCopyHeaders;
import com.azure.storage.file.share.implementation.models.FileUploadRangeFromURLHeaders;
import com.azure.storage.file.share.implementation.models.FileUploadRangeHeaders;
import com.azure.storage.file.share.implementation.models.FilesCreateResponse;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.FilesSetHTTPHeadersResponse;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.Range;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileCopyInfo;
import com.azure.storage.file.share.models.ShareFileDownloadAsyncResponse;
import com.azure.storage.file.share.models.ShareFileDownloadHeaders;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileListRangesDiffOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ShareFileAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareFileAsyncClient.class);
    static final long FILE_DEFAULT_BLOCK_SIZE = 0x400000L;
    private static final long DOWNLOAD_UPLOAD_CHUNK_TIMEOUT = 300L;
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String filePath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;

    ShareFileAsyncClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String filePath, String snapshot, String accountName, ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(filePath, "'filePath' cannot be null.");
        this.shareName = shareName;
        this.filePath = filePath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
    }

    public String getFileUrl() {
        StringBuilder fileUrlstring = new StringBuilder(this.azureFileStorageClient.getUrl()).append("/").append(this.shareName).append("/").append(this.filePath);
        if (this.snapshot != null) {
            fileUrlstring.append("?sharesnapshot=").append(this.snapshot);
        }
        return fileUrlstring.toString();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(null, context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(this::checkDoesNotExistStatusCode, t -> {
            HttpResponse response = t instanceof ShareStorageException ? ((ShareStorageException)((Object)((Object)t))).getResponse() : ((HttpResponseException)t).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    private boolean checkDoesNotExistStatusCode(Throwable t) {
        return t instanceof ShareStorageException && ((ShareStorageException)((Object)t)).getStatusCode() == 404 && (((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.RESOURCE_NOT_FOUND || ((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND) || t instanceof HttpResponseException && ((HttpResponseException)t).getResponse().getStatusCode() == 404 && (((HttpResponseException)t).getResponse().getHeaderValue("x-ms-error-code").equals(ShareErrorCode.RESOURCE_NOT_FOUND.toString()) || ((HttpResponseException)t).getResponse().getHeaderValue("x-ms-error-code").equals(ShareErrorCode.SHARE_NOT_FOUND.toString()));
    }

    public Mono<ShareFileInfo> create(long maxSize) {
        try {
            return this.createWithResponse(maxSize, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileInfo>> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileInfo>> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileInfo>> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        this.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        filePermission = smbProperties.setFilePermission(filePermission, "Inherit");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("None");
        String fileCreationTime = smbProperties.setFileCreationTime("Now");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Now");
        return this.azureFileStorageClient.files().createWithRestResponseAsync(this.shareName, this.filePath, maxSize, fileAttributes, fileCreationTime, fileLastWriteTime, null, metadata, filePermission, filePermissionKey, requestConditions.getLeaseId(), httpHeaders, context).map(this::createFileInfoResponse);
    }

    public PollerFlux<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, metadata, pollInterval, null);
    }

    public PollerFlux<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, FileSmbProperties smbProperties, String filePermission, PermissionCopyModeType filePermissionCopyMode, Boolean ignoreReadOnly, Boolean setArchiveAttribute, Map<String, String> metadata, Duration pollInterval, ShareRequestConditions destinationRequestConditions) {
        ShareRequestConditions finalRequestConditions = destinationRequestConditions == null ? new ShareRequestConditions() : destinationRequestConditions;
        AtomicReference copyId = new AtomicReference();
        Duration interval = pollInterval != null ? pollInterval : Duration.ofSeconds(1L);
        FileSmbProperties tempSmbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        String filePermissionKey = tempSmbProperties.getFilePermissionKey();
        String fileAttributes = NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
        String fileCreationTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
        String fileLastWriteTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
        if (filePermissionCopyMode == null || filePermissionCopyMode == PermissionCopyModeType.SOURCE) {
            if (filePermission != null || filePermissionKey != null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key can not be set when PermissionCopyModeType is source or null"));
            }
        } else if (filePermissionCopyMode == PermissionCopyModeType.OVERRIDE) {
            this.validateFilePermissionAndKey(filePermission, tempSmbProperties.getFilePermissionKey());
        }
        CopyFileSmbInfo copyFileSmbInfo = new CopyFileSmbInfo().setFilePermissionCopyMode(filePermissionCopyMode).setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setIgnoreReadOnly(ignoreReadOnly).setSetArchiveAttribute(setArchiveAttribute);
        String copySource = Utility.encodeUrlPath((String)sourceUrl);
        return new PollerFlux(interval, pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.azureFileStorageClient.files().startCopyWithRestResponseAsync(this.shareName, this.filePath, copySource, null, metadata, filePermission, tempSmbProperties.getFilePermissionKey(), finalRequestConditions.getLeaseId(), copyFileSmbInfo, (Context)context)).map(response -> {
                    FileStartCopyHeaders headers = (FileStartCopyHeaders)response.getDeserializedHeaders();
                    copyId.set(headers.getCopyId());
                    return new ShareFileCopyInfo(sourceUrl, headers.getCopyId(), headers.getCopyStatus(), headers.getETag(), headers.getLastModified(), headers.getErrorCode());
                });
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        }, pollingContext -> {
            try {
                return this.onPoll((PollResponse<ShareFileCopyInfo>)pollingContext.getLatestResponse(), finalRequestConditions);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        }, (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started.")));
            }
            String copyIdentifier = ((ShareFileCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)copyIdentifier)) {
                this.logger.info("Cancelling copy operation for copy id: {}", new Object[]{copyIdentifier});
                return this.abortCopyWithResponse(copyIdentifier, finalRequestConditions).thenReturn((Object)((ShareFileCopyInfo)firstResponse.getValue()));
            }
            return Mono.empty();
        }, pollingContext -> Mono.empty());
    }

    private Mono<PollResponse<ShareFileCopyInfo>> onPoll(PollResponse<ShareFileCopyInfo> pollResponse, ShareRequestConditions requestConditions) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.just(pollResponse);
        }
        ShareFileCopyInfo lastInfo = (ShareFileCopyInfo)pollResponse.getValue();
        if (lastInfo == null) {
            this.logger.warning("ShareFileCopyInfo does not exist. Activation operation failed.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"COPY_START_FAILED", (boolean)true), null));
        }
        return this.getPropertiesWithResponse(requestConditions).map(response -> {
            LongRunningOperationStatus operationStatus;
            ShareFileProperties value = (ShareFileProperties)response.getValue();
            CopyStatusType status = value.getCopyStatus();
            ShareFileCopyInfo result = new ShareFileCopyInfo(value.getCopySource(), value.getCopyId(), status, value.getETag(), value.getCopyCompletionTime(), value.getCopyStatusDescription());
            switch (status) {
                case SUCCESS: {
                    operationStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                    break;
                }
                case FAILED: {
                    operationStatus = LongRunningOperationStatus.FAILED;
                    break;
                }
                case ABORTED: {
                    operationStatus = LongRunningOperationStatus.USER_CANCELLED;
                    break;
                }
                case PENDING: {
                    operationStatus = LongRunningOperationStatus.IN_PROGRESS;
                    break;
                }
                default: {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("CopyStatusType is not supported. Status: " + (Object)((Object)status)));
                }
            }
            return new PollResponse(operationStatus, (Object)result);
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true), (Object)lastInfo));
    }

    public Mono<Void> abortCopy(String copyId) {
        try {
            return this.abortCopyWithResponse(copyId).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> abortCopyWithResponse(String copyId) {
        return this.abortCopyWithResponse(copyId, null);
    }

    public Mono<Response<Void>> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.abortCopyWithResponse(copyId, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        return this.azureFileStorageClient.files().abortCopyWithRestResponseAsync(this.shareName, this.filePath, copyId, null, requestConditions.getLeaseId(), context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<ShareFileProperties> downloadToFile(String downloadFilePath) {
        try {
            return this.downloadToFileWithResponse(downloadFilePath, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileProperties>> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range) {
        return this.downloadToFileWithResponse(downloadFilePath, range, null);
    }

    public Mono<Response<ShareFileProperties>> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.downloadToFileWithResponse(downloadFilePath, range, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileProperties>> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions, Context context) {
        return Mono.using(() -> this.channelSetup(downloadFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), channel -> this.getPropertiesWithResponse(requestConditions, context).flatMap(response -> this.downloadResponseInChunk((Response<ShareFileProperties>)response, (AsynchronousFileChannel)channel, range, requestConditions, context)), this::channelCleanUp);
    }

    private Mono<Response<ShareFileProperties>> downloadResponseInChunk(Response<ShareFileProperties> response, AsynchronousFileChannel channel, ShareFileRange range, ShareRequestConditions requestConditions, Context context) {
        return Mono.justOrEmpty((Object)range).switchIfEmpty(Mono.just((Object)new ShareFileRange(0L, ((ShareFileProperties)response.getValue()).getContentLength()))).map(currentRange -> {
            ArrayList<ShareFileRange> chunks = new ArrayList<ShareFileRange>();
            for (long pos = currentRange.getStart(); pos < currentRange.getEnd(); pos += 0x400000L) {
                long count = 0x400000L;
                if (pos + count > currentRange.getEnd()) {
                    count = currentRange.getEnd() - pos;
                }
                chunks.add(new ShareFileRange(pos, pos + count - 1L));
            }
            return chunks;
        }).flatMapMany(Flux::fromIterable).flatMap(chunk -> this.downloadWithResponse((ShareFileRange)chunk, false, requestConditions, context).map(ResponseBase::getValue).subscribeOn(Schedulers.elastic()).flatMap(fbb -> FluxUtil.writeFile((Flux)fbb, (AsynchronousFileChannel)channel, (long)(chunk.getStart() - (range == null ? 0L : range.getStart()))).subscribeOn(Schedulers.elastic()).timeout(Duration.ofSeconds(300L)).retry(3L, throwable -> throwable instanceof IOException || throwable instanceof TimeoutException))).then(Mono.just(response));
    }

    private AsynchronousFileChannel channelSetup(String filePath, OpenOption ... options) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), options);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    private void channelCleanUp(AsynchronousFileChannel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new UncheckedIOException(e)));
        }
    }

    public Flux<ByteBuffer> download() {
        try {
            return this.downloadWithResponse(null, null).flatMapMany(ResponseBase::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileRange range, Boolean rangeGetContentMD5) {
        return this.downloadWithResponse(range, rangeGetContentMD5, null);
    }

    public Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.downloadWithResponse(range, rangeGetContentMD5, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<ShareFileDownloadAsyncResponse> downloadWithResponse(ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        String rangeString = range == null ? null : range.toString();
        return this.azureFileStorageClient.files().downloadWithRestResponseAsync(this.shareName, this.filePath, null, rangeString, rangeGetContentMD5, requestConditions.getLeaseId(), context).map(response -> new ShareFileDownloadAsyncResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue(), (ShareFileDownloadHeaders)response.getDeserializedHeaders()));
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse() {
        return this.deleteWithResponse(null);
    }

    public Mono<Response<Void>> deleteWithResponse(ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        return this.azureFileStorageClient.files().deleteWithRestResponseAsync(this.shareName, this.filePath, null, requestConditions.getLeaseId(), context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<ShareFileProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileProperties>> getPropertiesWithResponse() {
        return this.getPropertiesWithResponse(null);
    }

    public Mono<Response<ShareFileProperties>> getPropertiesWithResponse(ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileProperties>> getPropertiesWithResponse(ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.files().getPropertiesWithRestResponseAsync(this.shareName, this.filePath, this.snapshot, null, requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::getPropertiesResponse);
    }

    public Mono<ShareFileInfo> setProperties(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        try {
            return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileInfo>> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null);
    }

    public Mono<Response<ShareFileInfo>> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileInfo>> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        this.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        filePermission = smbProperties.setFilePermission(filePermission, "Preserve");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("Preserve");
        String fileCreationTime = smbProperties.setFileCreationTime("Preserve");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Preserve");
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.files().setHTTPHeadersWithRestResponseAsync(this.shareName, this.filePath, fileAttributes, fileCreationTime, fileLastWriteTime, null, newFileSize, filePermission, filePermissionKey, requestConditions.getLeaseId(), httpHeaders, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::setPropertiesResponse);
    }

    public Mono<ShareFileMetadataInfo> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null);
    }

    public Mono<Response<ShareFileMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        try {
            return this.azureFileStorageClient.files().setMetadataWithRestResponseAsync(this.shareName, this.filePath, null, metadata, requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::setMetadataResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<ShareFileUploadInfo> upload(Flux<ByteBuffer> data, long length) {
        try {
            return this.uploadWithResponse(data, length, 0L).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileUploadInfo>> uploadWithResponse(Flux<ByteBuffer> data, long length, Long offset) {
        return this.uploadWithResponse(data, length, offset, null);
    }

    public Mono<Response<ShareFileUploadInfo>> uploadWithResponse(Flux<ByteBuffer> data, long length, Long offset, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadWithResponse(data, length, offset, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadInfo>> uploadWithResponse(Flux<ByteBuffer> data, long length, Long offset, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        long rangeOffset = offset == null ? 0L : offset;
        ShareFileRange range = new ShareFileRange(rangeOffset, rangeOffset + length - 1L);
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.files().uploadRangeWithRestResponseAsync(this.shareName, this.filePath, range.toString(), ShareFileRangeWriteType.UPDATE, length, data, null, null, requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::uploadResponse);
    }

    public Mono<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrl(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        try {
            return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null);
    }

    public Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions destinationRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, destinationRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadRangeFromUrlInfo>> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions destinationRequestConditions, Context context) {
        destinationRequestConditions = destinationRequestConditions == null ? new ShareRequestConditions() : destinationRequestConditions;
        ShareFileRange destinationRange = new ShareFileRange(destinationOffset, destinationOffset + length - 1L);
        ShareFileRange sourceRange = new ShareFileRange(sourceOffset, sourceOffset + length - 1L);
        context = context == null ? Context.NONE : context;
        String copySource = Utility.encodeUrlPath((String)sourceUrl);
        return this.azureFileStorageClient.files().uploadRangeFromURLWithRestResponseAsync(this.shareName, this.filePath, destinationRange.toString(), copySource, 0L, null, sourceRange.toString(), null, destinationRequestConditions.getLeaseId(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::uploadRangeFromUrlResponse);
    }

    public Mono<ShareFileUploadInfo> clearRange(long length) {
        try {
            return this.clearRangeWithResponse(length, 0L).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileUploadInfo>> clearRangeWithResponse(long length, long offset) {
        return this.clearRangeWithResponse(length, offset, null);
    }

    public Mono<Response<ShareFileUploadInfo>> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.clearRangeWithResponse(length, offset, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileUploadInfo>> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        ShareFileRange range = new ShareFileRange(offset, offset + length - 1L);
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.files().uploadRangeWithRestResponseAsync(this.shareName, this.filePath, range.toString(), ShareFileRangeWriteType.CLEAR, 0L, null, null, null, requestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::uploadResponse);
    }

    public Mono<Void> uploadFromFile(String uploadFilePath) {
        return this.uploadFromFile(uploadFilePath, null);
    }

    public Mono<Void> uploadFromFile(String uploadFilePath, ShareRequestConditions requestConditions) {
        try {
            return Mono.using(() -> this.channelSetup(uploadFilePath, StandardOpenOption.READ), channel -> Flux.fromIterable(this.sliceFile(uploadFilePath)).flatMap(chunk -> this.uploadWithResponse((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)channel, (long)chunk.getStart(), (long)(chunk.getEnd() - chunk.getStart() + 1L)), chunk.getEnd() - chunk.getStart() + 1L, chunk.getStart(), requestConditions).timeout(Duration.ofSeconds(300L)).retry(3L, throwable -> throwable instanceof IOException || throwable instanceof TimeoutException)).then(), this::channelCleanUp);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private List<ShareFileRange> sliceFile(String path) {
        File file = new File(path);
        assert (file.exists());
        ArrayList<ShareFileRange> ranges = new ArrayList<ShareFileRange>();
        for (long pos = 0L; pos < file.length(); pos += 0x400000L) {
            long count = 0x400000L;
            if (pos + count > file.length()) {
                count = file.length() - pos;
            }
            ranges.add(new ShareFileRange(pos, pos + count - 1L));
        }
        return ranges;
    }

    public PagedFlux<ShareFileRange> listRanges() {
        try {
            return this.listRanges(null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<ShareFileRange> listRanges(ShareFileRange range) {
        return this.listRanges(range, null);
    }

    public PagedFlux<ShareFileRange> listRanges(ShareFileRange range, ShareRequestConditions requestConditions) {
        try {
            return this.listRangesWithOptionalTimeout(range, requestConditions, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<ShareFileRangeList> listRangesDiff(String previousSnapshot) {
        try {
            return this.listRangesDiffWithResponse(new ShareFileListRangesDiffOptions(previousSnapshot)).map(Response::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<ShareFileRangeList>> listRangesDiffWithResponse(ShareFileListRangesDiffOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return this.listRangesWithResponse(options.getRange(), options.getRequestConditions(), options.getPreviousSnapshot(), Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<ShareFileRange> listRangesWithOptionalTimeout(ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.listRangesWithResponse(range, requestConditions, null, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ShareFileRangeList)response.getValue()).getRanges().stream().map(r -> new Range().setStart(r.getStart()).setEnd(r.getEnd())).map(ShareFileRange::new).collect(Collectors.toList()), null, (Object)response.getHeaders()));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    Mono<Response<ShareFileRangeList>> listRangesWithResponse(ShareFileRange range, ShareRequestConditions requestConditions, String previousSnapshot, Context context) {
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        String rangeString = range == null ? null : range.toString();
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.files().getRangeListWithRestResponseAsync(this.shareName, this.filePath, this.snapshot, previousSnapshot, null, rangeString, finalRequestConditions.getLeaseId(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public PagedFlux<HandleItem> listHandles() {
        try {
            return this.listHandles(null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<HandleItem> listHandles(Integer maxResultsPerPage) {
        try {
            return this.listHandlesWithOptionalTimeout(maxResultsPerPage, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<HandleItem> listHandlesWithOptionalTimeout(Integer maxResultsPerPage, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.files().listHandlesWithRestResponseAsync(this.shareName, this.filePath, (String)marker, maxResultsPerPage, null, this.snapshot, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().getHandleList(), response.getValue().getNextMarker(), (Object)((FileListHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public Mono<CloseHandlesInfo> forceCloseHandle(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.files().forceCloseHandlesWithRestResponseAsync(this.shareName, this.filePath, handleId, null, null, this.snapshot, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new CloseHandlesInfo(((FileForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesClosed(), ((FileForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesFailedToClose())));
    }

    public Mono<CloseHandlesInfo> forceCloseAllHandles() {
        try {
            return FluxUtil.withContext(context -> this.forceCloseAllHandlesWithOptionalTimeout(null, (Context)context).reduce((Object)new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<CloseHandlesInfo> forceCloseAllHandlesWithOptionalTimeout(Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.files().forceCloseHandlesWithRestResponseAsync(this.shareName, this.filePath, "*", null, (String)marker, this.snapshot, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((FileForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesClosed(), ((FileForceCloseHandlesHeaders)response.getDeserializedHeaders()).getNumberOfHandlesFailedToClose())), ((FileForceCloseHandlesHeaders)response.getDeserializedHeaders()).getMarker(), (Object)((FileForceCloseHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getFilePath()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }

    private Response<ShareFileInfo> createFileInfoResponse(FilesCreateResponse response) {
        String eTag = ((FileCreateHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FileCreateHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((FileCreateHeaders)response.getDeserializedHeaders()).isServerEncrypted();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareFileInfo shareFileInfo = new ShareFileInfo(eTag, lastModified, isServerEncrypted, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareFileInfo);
    }

    private Response<ShareFileInfo> setPropertiesResponse(FilesSetHTTPHeadersResponse response) {
        String eTag = ((FileSetHTTPHeadersHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FileSetHTTPHeadersHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((FileSetHTTPHeadersHeaders)response.getDeserializedHeaders()).isServerEncrypted();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareFileInfo shareFileInfo = new ShareFileInfo(eTag, lastModified, isServerEncrypted, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareFileInfo);
    }

    private Response<ShareFileProperties> getPropertiesResponse(FilesGetPropertiesResponse response) {
        byte[] contentMD5;
        FileGetPropertiesHeaders headers = (FileGetPropertiesHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        Map<String, String> metadata = headers.getMetadata();
        String fileType = headers.getFileType();
        Long contentLength = headers.getContentLength();
        String contentType = headers.getContentType();
        try {
            contentMD5 = headers.getContentMD5();
        }
        catch (NullPointerException e) {
            contentMD5 = null;
        }
        String contentEncoding = headers.getContentEncoding();
        String cacheControl = headers.getCacheControl();
        String contentDisposition = headers.getContentDisposition();
        LeaseStatusType leaseStatusType = headers.getLeaseStatus();
        LeaseStateType leaseStateType = headers.getLeaseState();
        LeaseDurationType leaseDurationType = headers.getLeaseDuration();
        OffsetDateTime copyCompletionTime = headers.getCopyCompletionTime();
        String copyStatusDescription = headers.getCopyStatusDescription();
        String copyId = headers.getCopyId();
        String copyProgress = headers.getCopyProgress();
        String copySource = headers.getCopySource();
        CopyStatusType copyStatus = headers.getCopyStatus();
        Boolean isServerEncrpted = headers.isServerEncrypted();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareFileProperties shareFileProperties = new ShareFileProperties(eTag, lastModified, metadata, fileType, contentLength, contentType, contentMD5, contentEncoding, cacheControl, contentDisposition, leaseStatusType, leaseStateType, leaseDurationType, copyCompletionTime, copyStatusDescription, copyId, copyProgress, copySource, copyStatus, isServerEncrpted, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareFileProperties);
    }

    private Response<ShareFileUploadInfo> uploadResponse(FilesUploadRangeResponse response) {
        byte[] contentMD5;
        FileUploadRangeHeaders headers = (FileUploadRangeHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        try {
            contentMD5 = headers.getContentMD5();
        }
        catch (NullPointerException e) {
            contentMD5 = null;
        }
        Boolean isServerEncrypted = headers.isServerEncrypted();
        ShareFileUploadInfo shareFileUploadInfo = new ShareFileUploadInfo(eTag, lastModified, contentMD5, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)shareFileUploadInfo);
    }

    private Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlResponse(FilesUploadRangeFromURLResponse response) {
        FileUploadRangeFromURLHeaders headers = (FileUploadRangeFromURLHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        Boolean isServerEncrypted = headers.isServerEncrypted();
        ShareFileUploadRangeFromUrlInfo shareFileUploadRangeFromUrlInfo = new ShareFileUploadRangeFromUrlInfo(eTag, lastModified, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)shareFileUploadRangeFromUrlInfo);
    }

    private Response<ShareFileMetadataInfo> setMetadataResponse(FilesSetMetadataResponse response) {
        String eTag = ((FileSetMetadataHeaders)response.getDeserializedHeaders()).getETag();
        Boolean isServerEncrypted = ((FileSetMetadataHeaders)response.getDeserializedHeaders()).isServerEncrypted();
        ShareFileMetadataInfo shareFileMetadataInfo = new ShareFileMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)shareFileMetadataInfo);
    }

    private void validateFilePermissionAndKey(String filePermission, String filePermissionKey) {
        if (filePermission != null && filePermissionKey != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key cannot both be set"));
        }
        if (filePermission != null) {
            StorageImplUtils.assertInBounds((String)"filePermission", (long)filePermission.getBytes(StandardCharsets.UTF_8).length, (long)0L, (long)8192L);
        }
    }
}

