// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

/** Initializes a new instance of the AzureFileStorage type. */
public final class AzureFileStorageImpl {
    /** Specifies the version of the operation to use for this request. */
    private final String version;

    /**
     * Gets Specifies the version of the operation to use for this request.
     *
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /** The URL of the service account, share, directory or file that is the target of the desired operation. */
    private final String url;

    /**
     * Gets The URL of the service account, share, directory or file that is the target of the desired operation.
     *
     * @return the url value.
     */
    public String getUrl() {
        return this.url;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The ServicesImpl object to access its operations. */
    private final ServicesImpl services;

    /**
     * Gets the ServicesImpl object to access its operations.
     *
     * @return the ServicesImpl object.
     */
    public ServicesImpl getServices() {
        return this.services;
    }

    /** The SharesImpl object to access its operations. */
    private final SharesImpl shares;

    /**
     * Gets the SharesImpl object to access its operations.
     *
     * @return the SharesImpl object.
     */
    public SharesImpl getShares() {
        return this.shares;
    }

    /** The DirectoriesImpl object to access its operations. */
    private final DirectoriesImpl directories;

    /**
     * Gets the DirectoriesImpl object to access its operations.
     *
     * @return the DirectoriesImpl object.
     */
    public DirectoriesImpl getDirectories() {
        return this.directories;
    }

    /** The FilesImpl object to access its operations. */
    private final FilesImpl files;

    /**
     * Gets the FilesImpl object to access its operations.
     *
     * @return the FilesImpl object.
     */
    public FilesImpl getFiles() {
        return this.files;
    }

    /**
     * Initializes an instance of AzureFileStorage client.
     *
     * @param version Specifies the version of the operation to use for this request.
     * @param url The URL of the service account, share, directory or file that is the target of the desired operation.
     */
    AzureFileStorageImpl(String version, String url) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                version,
                url);
    }

    /**
     * Initializes an instance of AzureFileStorage client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param version Specifies the version of the operation to use for this request.
     * @param url The URL of the service account, share, directory or file that is the target of the desired operation.
     */
    AzureFileStorageImpl(HttpPipeline httpPipeline, String version, String url) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), version, url);
    }

    /**
     * Initializes an instance of AzureFileStorage client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param version Specifies the version of the operation to use for this request.
     * @param url The URL of the service account, share, directory or file that is the target of the desired operation.
     */
    AzureFileStorageImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String version, String url) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.version = version;
        this.url = url;
        this.services = new ServicesImpl(this);
        this.shares = new SharesImpl(this);
        this.directories = new DirectoriesImpl(this);
        this.files = new FilesImpl(this);
    }
}
