// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesDeleteResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.StorageErrorException;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Directories. */
public final class DirectoriesImpl {
    /** The proxy service used to perform REST calls. */
    private final DirectoriesService service;

    /** The service client containing this operation class. */
    private final AzureFileStorageImpl client;

    /**
     * Initializes an instance of DirectoriesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectoriesImpl(AzureFileStorageImpl client) {
        this.service =
                RestProxy.create(DirectoriesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureFileStorageDirectories to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureFileStorageDire")
    public interface DirectoriesService {
        @Put("/{shareName}/{directoryPath}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesCreateResponse> create(
                @HostParam("url") String url,
                @QueryParam("restype") String restype,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-file-permission") String filePermission,
                @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
                @HeaderParam("x-ms-file-attributes") String fileAttributes,
                @HeaderParam("x-ms-file-creation-time") String fileCreationTime,
                @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{shareName}/{directoryPath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesGetPropertiesResponse> getProperties(
                @HostParam("url") String url,
                @QueryParam("restype") String restype,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/{shareName}/{directoryPath}")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesDeleteResponse> delete(
                @HostParam("url") String url,
                @QueryParam("restype") String restype,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directoryPath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesSetPropertiesResponse> setProperties(
                @HostParam("url") String url,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-file-permission") String filePermission,
                @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
                @HeaderParam("x-ms-file-attributes") String fileAttributes,
                @HeaderParam("x-ms-file-creation-time") String fileCreationTime,
                @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directoryPath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesSetMetadataResponse> setMetadata(
                @HostParam("url") String url,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{shareName}/{directoryPath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegment(
                @HostParam("url") String url,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("prefix") String prefix,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @QueryParam("marker") String marker,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{shareName}/{directoryPath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesListHandlesResponse> listHandles(
                @HostParam("url") String url,
                @QueryParam("comp") String comp,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("marker") String marker,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("timeout") Integer timeout,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @HeaderParam("x-ms-recursive") Boolean recursive,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directoryPath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(com.azure.storage.file.share.models.ShareStorageException.class)
        Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandles(
                @HostParam("url") String url,
                @QueryParam("comp") String comp,
                @PathParam("shareName") String shareName,
                @PathParam("directoryPath") String directoryPath,
                @QueryParam("timeout") Integer timeout,
                @QueryParam("marker") String marker,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @HeaderParam("x-ms-handle-id") String handleId,
                @HeaderParam("x-ms-recursive") Boolean recursive,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Creates a new directory under the specified share or parent directory.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file
     *     and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This
     *     header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used.
     *     Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of
     *     the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the
     *     x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesCreateResponse> createWithResponseAsync(
            String shareName,
            String directoryPath,
            String fileAttributes,
            String fileCreationTime,
            String fileLastWriteTime,
            Integer timeout,
            Map<String, String> metadata,
            String filePermission,
            String filePermissionKey,
            Context context) {
        final String restype = "directory";
        final String accept = "application/xml";
        return service.create(
                this.client.getUrl(),
                restype,
                shareName,
                directoryPath,
                timeout,
                metadata,
                this.client.getVersion(),
                filePermission,
                filePermissionKey,
                fileAttributes,
                fileCreationTime,
                fileLastWriteTime,
                accept,
                context);
    }

    /**
     * Returns all system properties for the specified directory, and can also be used to check the existence of a
     * directory. The data returned does not include the files in the directory or any subdirectories.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesGetPropertiesResponse> getPropertiesWithResponseAsync(
            String shareName, String directoryPath, String sharesnapshot, Integer timeout, Context context) {
        final String restype = "directory";
        final String accept = "application/xml";
        return service.getProperties(
                this.client.getUrl(),
                restype,
                shareName,
                directoryPath,
                sharesnapshot,
                timeout,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Removes the specified empty directory. Note that the directory must be empty before it can be deleted.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesDeleteResponse> deleteWithResponseAsync(
            String shareName, String directoryPath, Integer timeout, Context context) {
        final String restype = "directory";
        final String accept = "application/xml";
        return service.delete(
                this.client.getUrl(),
                restype,
                shareName,
                directoryPath,
                timeout,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Sets properties on the directory.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file
     *     and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This
     *     header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used.
     *     Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of
     *     the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the
     *     x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesSetPropertiesResponse> setPropertiesWithResponseAsync(
            String shareName,
            String directoryPath,
            String fileAttributes,
            String fileCreationTime,
            String fileLastWriteTime,
            Integer timeout,
            String filePermission,
            String filePermissionKey,
            Context context) {
        final String restype = "directory";
        final String comp = "properties";
        final String accept = "application/xml";
        return service.setProperties(
                this.client.getUrl(),
                restype,
                comp,
                shareName,
                directoryPath,
                timeout,
                this.client.getVersion(),
                filePermission,
                filePermissionKey,
                fileAttributes,
                fileCreationTime,
                fileLastWriteTime,
                accept,
                context);
    }

    /**
     * Updates user defined metadata for the specified directory.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesSetMetadataResponse> setMetadataWithResponseAsync(
            String shareName, String directoryPath, Integer timeout, Map<String, String> metadata, Context context) {
        final String restype = "directory";
        final String comp = "metadata";
        final String accept = "application/xml";
        return service.setMetadata(
                this.client.getUrl(),
                restype,
                comp,
                shareName,
                directoryPath,
                timeout,
                metadata,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Returns a list of files or directories under the specified share or directory. It lists the contents only for a
     * single level of the directory hierarchy.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     *     The operation returns a marker value within the response body if the list returned was not complete. The
     *     marker value may then be used in a subsequent call to request the next set of list items. The marker value is
     *     opaque to the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     *     or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of directories and files.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithResponseAsync(
            String shareName,
            String directoryPath,
            String prefix,
            String sharesnapshot,
            String marker,
            Integer maxresults,
            Integer timeout,
            Context context) {
        final String restype = "directory";
        final String comp = "list";
        final String accept = "application/xml";
        return service.listFilesAndDirectoriesSegment(
                this.client.getUrl(),
                restype,
                comp,
                shareName,
                directoryPath,
                prefix,
                sharesnapshot,
                marker,
                maxresults,
                timeout,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Lists handles for directory.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     *     The operation returns a marker value within the response body if the list returned was not complete. The
     *     marker value may then be used in a subsequent call to request the next set of list items. The marker value is
     *     opaque to the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     *     or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param recursive Specifies operation should apply to the directory specified in the URI, its files, its
     *     subdirectories and their files.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of handles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesListHandlesResponse> listHandlesWithResponseAsync(
            String shareName,
            String directoryPath,
            String marker,
            Integer maxresults,
            Integer timeout,
            String sharesnapshot,
            Boolean recursive,
            Context context) {
        final String comp = "listhandles";
        final String accept = "application/xml";
        return service.listHandles(
                this.client.getUrl(),
                comp,
                shareName,
                directoryPath,
                marker,
                maxresults,
                timeout,
                sharesnapshot,
                recursive,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Closes all handles open for given directory.
     *
     * @param shareName The name of the target share.
     * @param directoryPath The path of the target directory.
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterisk (‘*’) is a wildcard
     *     that specifies all handles.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     *     The operation returns a marker value within the response body if the list returned was not complete. The
     *     marker value may then be used in a subsequent call to request the next set of list items. The marker value is
     *     opaque to the client.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param recursive Specifies operation should apply to the directory specified in the URI, its files, its
     *     subdirectories and their files.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws StorageErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandlesWithResponseAsync(
            String shareName,
            String directoryPath,
            String handleId,
            Integer timeout,
            String marker,
            String sharesnapshot,
            Boolean recursive,
            Context context) {
        final String comp = "forceclosehandles";
        final String accept = "application/xml";
        return service.forceCloseHandles(
                this.client.getUrl(),
                comp,
                shareName,
                directoryPath,
                timeout,
                marker,
                sharesnapshot,
                handleId,
                recursive,
                this.client.getVersion(),
                accept,
                context);
    }
}
