/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesDeleteResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesResponse;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DirectoriesImpl {
    private final DirectoriesService service;
    private final AzureFileStorageImpl client;

    DirectoriesImpl(AzureFileStorageImpl client) {
        this.service = (DirectoriesService)RestProxy.create(DirectoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesCreateResponse> createWithResponseAsync(String shareName, String directoryPath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), "directory", shareName, directoryPath, timeout, metadata, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesGetPropertiesResponse> getPropertiesWithResponseAsync(String shareName, String directoryPath, String sharesnapshot, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "directory", shareName, directoryPath, sharesnapshot, timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesDeleteResponse> deleteWithResponseAsync(String shareName, String directoryPath, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), "directory", shareName, directoryPath, timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesSetPropertiesResponse> setPropertiesWithResponseAsync(String shareName, String directoryPath, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, String filePermission, String filePermissionKey, Context context) {
        String restype = "directory";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "directory", "properties", shareName, directoryPath, timeout, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesSetMetadataResponse> setMetadataWithResponseAsync(String shareName, String directoryPath, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "directory";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), "directory", "metadata", shareName, directoryPath, timeout, metadata, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithResponseAsync(String shareName, String directoryPath, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, Context context) {
        String restype = "directory";
        String comp = "list";
        String accept = "application/xml";
        return this.service.listFilesAndDirectoriesSegment(this.client.getUrl(), "directory", "list", shareName, directoryPath, prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesListHandlesResponse> listHandlesWithResponseAsync(String shareName, String directoryPath, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandles(this.client.getUrl(), "listhandles", shareName, directoryPath, marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandlesWithResponseAsync(String shareName, String directoryPath, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandles(this.client.getUrl(), "forceclosehandles", shareName, directoryPath, timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageDire")
    public static interface DirectoriesService {
        @Put(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesCreateResponse> create(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @PathParam(value="shareName") String var3, @PathParam(value="directoryPath") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-attributes") String var10, @HeaderParam(value="x-ms-file-creation-time") String var11, @HeaderParam(value="x-ms-file-last-write-time") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @PathParam(value="shareName") String var3, @PathParam(value="directoryPath") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesDeleteResponse> delete(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @PathParam(value="shareName") String var3, @PathParam(value="directoryPath") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @PathParam(value="shareName") String var4, @PathParam(value="directoryPath") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-attributes") String var10, @HeaderParam(value="x-ms-file-creation-time") String var11, @HeaderParam(value="x-ms-file-last-write-time") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @PathParam(value="shareName") String var4, @PathParam(value="directoryPath") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegment(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @PathParam(value="shareName") String var4, @PathParam(value="directoryPath") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesListHandlesResponse> listHandles(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="shareName") String var3, @PathParam(value="directoryPath") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directoryPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandles(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="shareName") String var3, @PathParam(value="directoryPath") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);
    }
}

