/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.sas;

import java.util.Locale;

public final class ShareFileSasPermission {
    private boolean readPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;

    public static ShareFileSasPermission parse(String permString) {
        ShareFileSasPermission permissions = new ShareFileSasPermission();
        block6: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block6;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block6;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block6;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public ShareFileSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public ShareFileSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public ShareFileSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public ShareFileSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        return builder.toString();
    }
}

