// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.queue.implementation.models.QueuesCreateResponse;
import com.azure.storage.queue.implementation.models.QueuesDeleteResponse;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyResponse;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesResponse;
import com.azure.storage.queue.implementation.models.QueuesSetAccessPolicyResponse;
import com.azure.storage.queue.implementation.models.QueuesSetMetadataResponse;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Queues. */
public final class QueuesImpl {
    /** The proxy service used to perform REST calls. */
    private final QueuesService service;

    /** The service client containing this operation class. */
    private final AzureQueueStorageImpl client;

    /**
     * Initializes an instance of QueuesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    QueuesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(QueuesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureQueueStorageQueues to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureQueueStorageQue")
    public interface QueuesService {
        @Put("/{queueName}")
        @ExpectedResponses({201, 204})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<QueuesCreateResponse> create(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/{queueName}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<QueuesDeleteResponse> delete(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{queueName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<QueuesGetPropertiesResponse> getProperties(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{queueName}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<QueuesSetMetadataResponse> setMetadata(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{queueName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<QueuesGetAccessPolicyResponse> getAccessPolicy(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{queueName}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<QueuesSetAccessPolicyResponse> setAccessPolicy(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @BodyParam("application/xml") SignedIdentifiersWrapper queueAcl,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     *     response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     *     restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all
     *     metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueuesCreateResponse> createWithResponseAsync(
            String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        final String accept = "application/xml";
        return service.create(
                this.client.getUrl(),
                queueName,
                timeout,
                metadata,
                this.client.getVersion(),
                requestId,
                accept,
                context);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueuesDeleteResponse> deleteWithResponseAsync(
            String queueName, Integer timeout, String requestId, Context context) {
        final String accept = "application/xml";
        return service.delete(
                this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, accept, context);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueuesGetPropertiesResponse> getPropertiesWithResponseAsync(
            String queueName, Integer timeout, String requestId, Context context) {
        final String comp = "metadata";
        final String accept = "application/xml";
        return service.getProperties(
                this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(), requestId, accept, context);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     *     response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     *     restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all
     *     metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueuesSetMetadataResponse> setMetadataWithResponseAsync(
            String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        final String comp = "metadata";
        final String accept = "application/xml";
        return service.setMetadata(
                this.client.getUrl(),
                queueName,
                comp,
                timeout,
                metadata,
                this.client.getVersion(),
                requestId,
                accept,
                context);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueuesGetAccessPolicyResponse> getAccessPolicyWithResponseAsync(
            String queueName, Integer timeout, String requestId, Context context) {
        final String comp = "acl";
        final String accept = "application/xml";
        return service.getAccessPolicy(
                this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(), requestId, accept, context);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueuesSetAccessPolicyResponse> setAccessPolicyWithResponseAsync(
            String queueName,
            Integer timeout,
            String requestId,
            List<QueueSignedIdentifier> queueAcl,
            Context context) {
        final String comp = "acl";
        final String accept = "application/xml";
        SignedIdentifiersWrapper queueAclConverted = new SignedIdentifiersWrapper(queueAcl);
        return service.setAccessPolicy(
                this.client.getUrl(),
                queueName,
                comp,
                timeout,
                this.client.getVersion(),
                requestId,
                queueAclConverted,
                accept,
                context);
    }
}
