/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueMessageDecodingError;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueServiceStatistics;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=QueueServiceClientBuilder.class, isAsync=true)
public final class QueueServiceAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(QueueServiceAsyncClient.class);
    private final AzureQueueStorageImpl client;
    private final String accountName;
    private final QueueServiceVersion serviceVersion;
    private final QueueMessageEncoding messageEncoding;
    private final Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler;
    private final Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler;

    QueueServiceAsyncClient(AzureQueueStorageImpl azureQueueStorage, String accountName, QueueServiceVersion serviceVersion, QueueMessageEncoding messageEncoding, Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler, Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler) {
        this.client = azureQueueStorage;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.messageEncoding = messageEncoding;
        this.processMessageDecodingErrorAsyncHandler = processMessageDecodingErrorAsyncHandler;
        this.processMessageDecodingErrorHandler = processMessageDecodingErrorHandler;
    }

    public String getQueueServiceUrl() {
        return this.client.getUrl();
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.messageEncoding;
    }

    public QueueAsyncClient getQueueAsyncClient(String queueName) {
        return new QueueAsyncClient(this.client, queueName, this.accountName, this.serviceVersion, this.messageEncoding, this.processMessageDecodingErrorAsyncHandler, this.processMessageDecodingErrorHandler);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueAsyncClient> createQueue(String queueName) {
        return this.createQueueWithResponse(queueName, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueAsyncClient>> createQueueWithResponse(String queueName, Map<String, String> metadata) {
        try {
            Objects.requireNonNull(queueName, "'queueName' cannot be null.");
            return FluxUtil.withContext(context -> this.createQueueWithResponse(queueName, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueAsyncClient>> createQueueWithResponse(String queueName, Map<String, String> metadata, Context context) {
        QueueAsyncClient queueAsyncClient = new QueueAsyncClient(this.client, queueName, this.accountName, this.serviceVersion, this.messageEncoding, this.processMessageDecodingErrorAsyncHandler, this.processMessageDecodingErrorHandler);
        return queueAsyncClient.createWithResponse(metadata, context).map(response -> new SimpleResponse(response, (Object)queueAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteQueue(String queueName) {
        return this.deleteQueueWithResponse(queueName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteQueueWithResponse(String queueName) {
        try {
            return FluxUtil.withContext(context -> this.deleteQueueWithResponse(queueName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteQueueWithResponse(String queueName, Context context) {
        return new QueueAsyncClient(this.client, queueName, this.accountName, this.serviceVersion, this.messageEncoding, this.processMessageDecodingErrorAsyncHandler, this.processMessageDecodingErrorHandler).deleteWithResponse(context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueues() {
        try {
            return this.listQueuesWithOptionalTimeout(null, null, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueues(QueuesSegmentOptions options) {
        try {
            return this.listQueuesWithOptionalTimeout(null, options, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<QueueItem> listQueuesWithOptionalTimeout(String marker, QueuesSegmentOptions options, Duration timeout, Context context) {
        String prefix = options != null ? options.getPrefix() : null;
        Integer maxResultsPerPage = options != null ? options.getMaxResultsPerPage() : null;
        ArrayList<String> include = new ArrayList<String>();
        if (options != null && options.isIncludeMetadata()) {
            include.add("metadata");
        }
        BiFunction<String, Integer, Mono> retriever = (nextMarker, pageSize) -> StorageImplUtils.applyOptionalTimeout(this.client.getServices().listQueuesSegmentSinglePageAsync(prefix, (String)nextMarker, pageSize == null ? maxResultsPerPage : pageSize, (List<String>)include, null, null, context), (Duration)timeout);
        return new PagedFlux(pageSize -> (Mono)retriever.apply(marker, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueServiceProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueServiceProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getServices().getPropertiesWithResponseAsync(null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setProperties(QueueServiceProperties properties) {
        return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesWithResponse(QueueServiceProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setPropertiesWithResponse(QueueServiceProperties properties, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getServices().setPropertiesWithResponseAsync(properties, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceStatistics> getStatistics() {
        return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueServiceStatistics>> getStatisticsWithResponse() {
        try {
            return FluxUtil.withContext(this::getStatisticsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueServiceStatistics>> getStatisticsWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getServices().getStatisticsWithResponseAsync(null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return new AccountSasImplUtil(accountSasSignatureValues, null).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }
}

