// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

/** The MessageIdsUpdateHeaders model. */
@JacksonXmlRootElement(localName = "null")
@Fluent
public final class MessageIdsUpdateHeaders {
    /*
     * The x-ms-version property.
     */
    @JsonProperty(value = "x-ms-version")
    private String xMsVersion;

    /*
     * The x-ms-time-next-visible property.
     */
    @JsonProperty(value = "x-ms-time-next-visible")
    private DateTimeRfc1123 xMsTimeNextVisible;

    /*
     * The x-ms-request-id property.
     */
    @JsonProperty(value = "x-ms-request-id")
    private String xMsRequestId;

    /*
     * The x-ms-popreceipt property.
     */
    @JsonProperty(value = "x-ms-popreceipt")
    private String xMsPopreceipt;

    /*
     * The Date property.
     */
    @JsonProperty(value = "Date")
    private DateTimeRfc1123 date;

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of MessageIdsUpdateHeaders class.
     *
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public MessageIdsUpdateHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        String xMsTimeNextVisible = rawHeaders.getValue("x-ms-time-next-visible");
        if (xMsTimeNextVisible != null) {
            this.xMsTimeNextVisible = new DateTimeRfc1123(xMsTimeNextVisible);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsPopreceipt = rawHeaders.getValue("x-ms-popreceipt");
        String date = rawHeaders.getValue("Date");
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     *
     * @return the xMsVersion value.
     */
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     *
     * @param xMsVersion the xMsVersion value to set.
     * @return the MessageIdsUpdateHeaders object itself.
     */
    public MessageIdsUpdateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsTimeNextVisible property: The x-ms-time-next-visible property.
     *
     * @return the xMsTimeNextVisible value.
     */
    public OffsetDateTime getXMsTimeNextVisible() {
        if (this.xMsTimeNextVisible == null) {
            return null;
        }
        return this.xMsTimeNextVisible.getDateTime();
    }

    /**
     * Set the xMsTimeNextVisible property: The x-ms-time-next-visible property.
     *
     * @param xMsTimeNextVisible the xMsTimeNextVisible value to set.
     * @return the MessageIdsUpdateHeaders object itself.
     */
    public MessageIdsUpdateHeaders setXMsTimeNextVisible(OffsetDateTime xMsTimeNextVisible) {
        if (xMsTimeNextVisible == null) {
            this.xMsTimeNextVisible = null;
        } else {
            this.xMsTimeNextVisible = new DateTimeRfc1123(xMsTimeNextVisible);
        }
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     *
     * @return the xMsRequestId value.
     */
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     *
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the MessageIdsUpdateHeaders object itself.
     */
    public MessageIdsUpdateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the xMsPopreceipt property: The x-ms-popreceipt property.
     *
     * @return the xMsPopreceipt value.
     */
    public String getXMsPopreceipt() {
        return this.xMsPopreceipt;
    }

    /**
     * Set the xMsPopreceipt property: The x-ms-popreceipt property.
     *
     * @param xMsPopreceipt the xMsPopreceipt value to set.
     * @return the MessageIdsUpdateHeaders object itself.
     */
    public MessageIdsUpdateHeaders setXMsPopreceipt(String xMsPopreceipt) {
        this.xMsPopreceipt = xMsPopreceipt;
        return this;
    }

    /**
     * Get the date property: The Date property.
     *
     * @return the date value.
     */
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     *
     * @param date the date value to set.
     * @return the MessageIdsUpdateHeaders object itself.
     */
    public MessageIdsUpdateHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }
}
