/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessageIdsDeleteHeaders;
import com.azure.storage.queue.implementation.models.MessageIdsUpdateHeaders;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.models.QueueStorageException;
import reactor.core.publisher.Mono;

public final class MessageIdsImpl {
    private final MessageIdsService service;
    private final AzureQueueStorageImpl client;

    MessageIdsImpl(AzureQueueStorageImpl client) {
        this.service = (MessageIdsService)RestProxy.create(MessageIdsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessageIdsUpdateHeaders, Void>> updateWithResponseAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Integer timeout, String requestId, QueueMessage queueMessage) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.update(this.client.getUrl(), queueName, messageid, popReceipt, visibilitytimeout, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessageIdsUpdateHeaders, Void>> updateWithResponseAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Integer timeout, String requestId, QueueMessage queueMessage, Context context) {
        String accept = "application/xml";
        return this.service.update(this.client.getUrl(), queueName, messageid, popReceipt, visibilitytimeout, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Integer timeout, String requestId, QueueMessage queueMessage) {
        return this.updateWithResponseAsync(queueName, messageid, popReceipt, visibilitytimeout, timeout, requestId, queueMessage).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Integer timeout, String requestId, QueueMessage queueMessage, Context context) {
        return this.updateWithResponseAsync(queueName, messageid, popReceipt, visibilitytimeout, timeout, requestId, queueMessage, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateNoCustomHeadersWithResponseAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Integer timeout, String requestId, QueueMessage queueMessage) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.updateNoCustomHeaders(this.client.getUrl(), queueName, messageid, popReceipt, visibilitytimeout, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateNoCustomHeadersWithResponseAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Integer timeout, String requestId, QueueMessage queueMessage, Context context) {
        String accept = "application/xml";
        return this.service.updateNoCustomHeaders(this.client.getUrl(), queueName, messageid, popReceipt, visibilitytimeout, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessageIdsDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), queueName, messageid, popReceipt, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessageIdsDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), queueName, messageid, popReceipt, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId) {
        return this.deleteWithResponseAsync(queueName, messageid, popReceipt, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId, Context context) {
        return this.deleteWithResponseAsync(queueName, messageid, popReceipt, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.deleteNoCustomHeaders(this.client.getUrl(), queueName, messageid, popReceipt, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), queueName, messageid, popReceipt, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageMes")
    public static interface MessageIdsService {
        @Put(value="/{queueName}/messages/{messageid}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessageIdsUpdateHeaders, Void>> update(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @PathParam(value="messageid") String var3, @QueryParam(value="popreceipt") String var4, @QueryParam(value="visibilitytimeout") int var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") QueueMessage var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{queueName}/messages/{messageid}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<Void>> updateNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @PathParam(value="messageid") String var3, @QueryParam(value="popreceipt") String var4, @QueryParam(value="visibilitytimeout") int var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") QueueMessage var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{queueName}/messages/{messageid}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessageIdsDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @PathParam(value="messageid") String var3, @QueryParam(value="popreceipt") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{queueName}/messages/{messageid}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @PathParam(value="messageid") String var3, @QueryParam(value="popreceipt") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

