// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.queue.implementation.models.MessagesClearHeaders;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesEnqueueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternal;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternal;
import com.azure.storage.queue.models.QueueStorageException;
import com.azure.storage.queue.models.SendMessageResult;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Messages. */
public final class MessagesImpl {
    /** The proxy service used to perform REST calls. */
    private final MessagesService service;

    /** The service client containing this operation class. */
    private final AzureQueueStorageImpl client;

    /**
     * Initializes an instance of MessagesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    MessagesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(MessagesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureQueueStorageMessages to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureQueueStorageMes")
    public interface MessagesService {
        @Get("/{queueName}/messages")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>>> dequeue(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("numofmessages") Integer numberOfMessages,
                @QueryParam("visibilitytimeout") Integer visibilitytimeout,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<Response<List<QueueMessageItemInternal>>> dequeueNoCustomHeaders(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("numofmessages") Integer numberOfMessages,
                @QueryParam("visibilitytimeout") Integer visibilitytimeout,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/{queueName}/messages")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<ResponseBase<MessagesClearHeaders, Void>> clear(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/{queueName}/messages")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<Response<Void>> clearNoCustomHeaders(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/{queueName}/messages")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<ResponseBase<MessagesEnqueueHeaders, List<SendMessageResult>>> enqueue(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("visibilitytimeout") Integer visibilitytimeout,
                @QueryParam("messagettl") Integer messageTimeToLive,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @BodyParam("application/xml") QueueMessage queueMessage,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/{queueName}/messages")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<Response<List<SendMessageResult>>> enqueueNoCustomHeaders(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("visibilitytimeout") Integer visibilitytimeout,
                @QueryParam("messagettl") Integer messageTimeToLive,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @BodyParam("application/xml") QueueMessage queueMessage,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>>> peek(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("peekonly") String peekonly,
                @QueryParam("numofmessages") Integer numberOfMessages,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(QueueStorageException.class)
        Mono<Response<List<PeekedMessageItemInternal>>> peekNoCustomHeaders(
                @HostParam("url") String url,
                @PathParam("queueName") String queueName,
                @QueryParam("peekonly") String peekonly,
                @QueryParam("numofmessages") Integer numberOfMessages,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     *     time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot
     *     be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The
     *     visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link ResponseBase} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>>> dequeueWithResponseAsync(
            String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.dequeue(
                                this.client.getUrl(),
                                queueName,
                                numberOfMessages,
                                visibilitytimeout,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                accept,
                                context));
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     *     time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot
     *     be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The
     *     visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link ResponseBase} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>>> dequeueWithResponseAsync(
            String queueName,
            Integer numberOfMessages,
            Integer visibilitytimeout,
            Integer timeout,
            String requestId,
            Context context) {
        final String accept = "application/xml";
        return service.dequeue(
                this.client.getUrl(),
                queueName,
                numberOfMessages,
                visibilitytimeout,
                timeout,
                this.client.getVersion(),
                requestId,
                accept,
                context);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     *     time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot
     *     be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The
     *     visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<QueueMessageItemInternal>> dequeueAsync(
            String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        return dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     *     time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot
     *     be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The
     *     visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<QueueMessageItemInternal>> dequeueAsync(
            String queueName,
            Integer numberOfMessages,
            Integer visibilitytimeout,
            Integer timeout,
            String requestId,
            Context context) {
        return dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     *     time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot
     *     be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The
     *     visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<QueueMessageItemInternal>>> dequeueNoCustomHeadersWithResponseAsync(
            String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.dequeueNoCustomHeaders(
                                this.client.getUrl(),
                                queueName,
                                numberOfMessages,
                                visibilitytimeout,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                accept,
                                context));
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     *     time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot
     *     be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The
     *     visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<QueueMessageItemInternal>>> dequeueNoCustomHeadersWithResponseAsync(
            String queueName,
            Integer numberOfMessages,
            Integer visibilitytimeout,
            Integer timeout,
            String requestId,
            Context context) {
        final String accept = "application/xml";
        return service.dequeueNoCustomHeaders(
                this.client.getUrl(),
                queueName,
                numberOfMessages,
                visibilitytimeout,
                timeout,
                this.client.getVersion(),
                requestId,
                accept,
                context);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(
            String queueName, Integer timeout, String requestId) {
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.clear(
                                this.client.getUrl(),
                                queueName,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                accept,
                                context));
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(
            String queueName, Integer timeout, String requestId, Context context) {
        final String accept = "application/xml";
        return service.clear(
                this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, accept, context);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId) {
        return clearWithResponseAsync(queueName, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId, Context context) {
        return clearWithResponseAsync(queueName, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> clearNoCustomHeadersWithResponseAsync(
            String queueName, Integer timeout, String requestId) {
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.clearNoCustomHeaders(
                                this.client.getUrl(),
                                queueName,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                accept,
                                context));
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> clearNoCustomHeadersWithResponseAsync(
            String queueName, Integer timeout, String requestId, Context context) {
        final String accept = "application/xml";
        return service.clearNoCustomHeaders(
                this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, accept, context);
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     *     later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds,
     *     relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days.
     *     The visibility timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout
     *     should be set to a value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     *     version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     *     time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     *     parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link ResponseBase} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, List<SendMessageResult>>> enqueueWithResponseAsync(
            String queueName,
            QueueMessage queueMessage,
            Integer visibilitytimeout,
            Integer messageTimeToLive,
            Integer timeout,
            String requestId) {
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.enqueue(
                                this.client.getUrl(),
                                queueName,
                                visibilitytimeout,
                                messageTimeToLive,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                queueMessage,
                                accept,
                                context));
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     *     later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds,
     *     relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days.
     *     The visibility timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout
     *     should be set to a value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     *     version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     *     time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     *     parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link ResponseBase} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, List<SendMessageResult>>> enqueueWithResponseAsync(
            String queueName,
            QueueMessage queueMessage,
            Integer visibilitytimeout,
            Integer messageTimeToLive,
            Integer timeout,
            String requestId,
            Context context) {
        final String accept = "application/xml";
        return service.enqueue(
                this.client.getUrl(),
                queueName,
                visibilitytimeout,
                messageTimeToLive,
                timeout,
                this.client.getVersion(),
                requestId,
                queueMessage,
                accept,
                context);
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     *     later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds,
     *     relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days.
     *     The visibility timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout
     *     should be set to a value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     *     version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     *     time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     *     parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<SendMessageResult>> enqueueAsync(
            String queueName,
            QueueMessage queueMessage,
            Integer visibilitytimeout,
            Integer messageTimeToLive,
            Integer timeout,
            String requestId) {
        return enqueueWithResponseAsync(
                        queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     *     later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds,
     *     relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days.
     *     The visibility timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout
     *     should be set to a value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     *     version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     *     time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     *     parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<SendMessageResult>> enqueueAsync(
            String queueName,
            QueueMessage queueMessage,
            Integer visibilitytimeout,
            Integer messageTimeToLive,
            Integer timeout,
            String requestId,
            Context context) {
        return enqueueWithResponseAsync(
                        queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     *     later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds,
     *     relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days.
     *     The visibility timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout
     *     should be set to a value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     *     version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     *     time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     *     parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<SendMessageResult>>> enqueueNoCustomHeadersWithResponseAsync(
            String queueName,
            QueueMessage queueMessage,
            Integer visibilitytimeout,
            Integer messageTimeToLive,
            Integer timeout,
            String requestId) {
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.enqueueNoCustomHeaders(
                                this.client.getUrl(),
                                queueName,
                                visibilitytimeout,
                                messageTimeToLive,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                queueMessage,
                                accept,
                                context));
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     *     later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds,
     *     relative to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days.
     *     The visibility timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout
     *     should be set to a value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     *     version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     *     time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     *     parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<SendMessageResult>>> enqueueNoCustomHeadersWithResponseAsync(
            String queueName,
            QueueMessage queueMessage,
            Integer visibilitytimeout,
            Integer messageTimeToLive,
            Integer timeout,
            String requestId,
            Context context) {
        final String accept = "application/xml";
        return service.enqueueNoCustomHeaders(
                this.client.getUrl(),
                queueName,
                visibilitytimeout,
                messageTimeToLive,
                timeout,
                this.client.getVersion(),
                requestId,
                queueMessage,
                accept,
                context);
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link ResponseBase} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>>> peekWithResponseAsync(
            String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        final String peekonly = "true";
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.peek(
                                this.client.getUrl(),
                                queueName,
                                peekonly,
                                numberOfMessages,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                accept,
                                context));
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link ResponseBase} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>>> peekWithResponseAsync(
            String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        final String peekonly = "true";
        final String accept = "application/xml";
        return service.peek(
                this.client.getUrl(),
                queueName,
                peekonly,
                numberOfMessages,
                timeout,
                this.client.getVersion(),
                requestId,
                accept,
                context);
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<PeekedMessageItemInternal>> peekAsync(
            String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        return peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<PeekedMessageItemInternal>> peekAsync(
            String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        return peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<PeekedMessageItemInternal>>> peekNoCustomHeadersWithResponseAsync(
            String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        final String peekonly = "true";
        final String accept = "application/xml";
        return FluxUtil.withContext(
                context ->
                        service.peekNoCustomHeaders(
                                this.client.getUrl(),
                                queueName,
                                peekonly,
                                numberOfMessages,
                                timeout,
                                this.client.getVersion(),
                                requestId,
                                accept,
                                context));
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     *     the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a
     *     single message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     *     Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     *     analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<PeekedMessageItemInternal>>> peekNoCustomHeadersWithResponseAsync(
            String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        final String peekonly = "true";
        final String accept = "application/xml";
        return service.peekNoCustomHeaders(
                this.client.getUrl(),
                queueName,
                peekonly,
                numberOfMessages,
                timeout,
                this.client.getVersion(),
                requestId,
                accept,
                context);
    }
}
