/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueMessageDecodingError;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueServiceStatistics;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

@ServiceClient(builder=QueueServiceClientBuilder.class)
public final class QueueServiceClient {
    private static final ClientLogger LOGGER = new ClientLogger(QueueServiceClient.class);
    private final AzureQueueStorageImpl azureQueueStorage;
    private final String accountName;
    private final QueueServiceVersion serviceVersion;
    private final QueueMessageEncoding messageEncoding;
    private final Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler;
    private final Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler;

    QueueServiceClient(AzureQueueStorageImpl azureQueueStorage, String accountName, QueueServiceVersion serviceVersion, QueueMessageEncoding messageEncoding, Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler, Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler) {
        this.azureQueueStorage = azureQueueStorage;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.messageEncoding = messageEncoding;
        this.processMessageDecodingErrorAsyncHandler = processMessageDecodingErrorAsyncHandler;
        this.processMessageDecodingErrorHandler = processMessageDecodingErrorHandler;
    }

    public String getQueueServiceUrl() {
        return this.azureQueueStorage.getUrl();
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.messageEncoding;
    }

    public QueueClient getQueueClient(String queueName) {
        QueueAsyncClient queueAsyncClient = new QueueAsyncClient(this.azureQueueStorage, queueName, this.accountName, this.serviceVersion, this.messageEncoding, this.processMessageDecodingErrorAsyncHandler, this.processMessageDecodingErrorHandler, null);
        return new QueueClient(this.azureQueueStorage, queueName, this.accountName, this.serviceVersion, this.messageEncoding, this.processMessageDecodingErrorAsyncHandler, this.processMessageDecodingErrorHandler, queueAsyncClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueClient createQueue(String queueName) {
        return (QueueClient)this.createQueueWithResponse(queueName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueClient> createQueueWithResponse(String queueName, Map<String, String> metadata, Duration timeout, Context context) {
        Objects.requireNonNull(queueName, "'queueName' cannot be null.");
        try {
            QueueClient queueClient = this.getQueueClient(queueName);
            Response<Void> response = queueClient.createWithResponse(metadata, timeout, context);
            return new SimpleResponse(response, (Object)queueClient);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteQueue(String queueName) {
        this.deleteQueueWithResponse(queueName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteQueueWithResponse(String queueName, Duration timeout, Context context) {
        Objects.requireNonNull(queueName, "'queueName' cannot be null.");
        try {
            QueueClient queueClient = this.getQueueClient(queueName);
            return queueClient.deleteWithResponse(timeout, context);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueues() {
        return this.listQueues(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueues(QueuesSegmentOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        String prefix = options != null ? options.getPrefix() : null;
        Integer maxResultsPerPage = options != null ? options.getMaxResultsPerPage() : null;
        ArrayList<String> include = new ArrayList<String>();
        if (options != null && options.isIncludeMetadata()) {
            include.add("metadata");
        }
        BiFunction<String, Integer, PagedResponse> retriever = (nextMarker, pageSize) -> {
            Supplier<PagedResponse> operation = () -> this.azureQueueStorage.getServices().listQueuesSegmentSinglePage(prefix, (String)nextMarker, pageSize == null ? maxResultsPerPage : pageSize, (List<String>)include, null, null, finalContext);
            return (PagedResponse)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        };
        return new PagedIterable(pageSize -> (PagedResponse)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueServiceProperties getProperties() {
        return (QueueServiceProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getServices().getPropertiesWithResponse(null, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(QueueServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(QueueServiceProperties properties, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getServices().setPropertiesWithResponse(properties, null, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueServiceStatistics getStatistics() {
        return (QueueServiceStatistics)this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueServiceStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<ResponseBase> operation = () -> this.azureQueueStorage.getServices().getStatisticsWithResponse(null, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureQueueStorage.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, null);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return new AccountSasImplUtil(accountSasSignatureValues, null).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }
}

