/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueClientBuilder;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessageIdsUpdateHeaders;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternal;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternal;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.util.ModelHelper;
import com.azure.storage.queue.implementation.util.QueueSasImplUtil;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueMessageDecodingError;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueProperties;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.QueueStorageException;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import com.azure.storage.queue.sas.QueueServiceSasSignatureValues;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=QueueClientBuilder.class, isAsync=true)
public final class QueueAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(QueueAsyncClient.class);
    private final AzureQueueStorageImpl client;
    private final String queueName;
    private final String accountName;
    private final QueueServiceVersion serviceVersion;
    private final QueueMessageEncoding messageEncoding;
    private final Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler;
    private final Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler;
    private final QueueClient queueClient;

    QueueAsyncClient(AzureQueueStorageImpl client, String queueName, String accountName, QueueServiceVersion serviceVersion, QueueMessageEncoding messageEncoding, Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler, Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler, QueueClient queueClient) {
        Objects.requireNonNull(queueName, "'queueName' cannot be null.");
        this.queueName = queueName;
        this.client = client;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.messageEncoding = messageEncoding;
        this.processMessageDecodingErrorAsyncHandler = processMessageDecodingErrorAsyncHandler;
        this.processMessageDecodingErrorHandler = processMessageDecodingErrorHandler;
        this.queueClient = queueClient;
    }

    public String getQueueUrl() {
        return this.client.getUrl() + "/" + this.queueName;
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.messageEncoding;
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> create() {
        return this.createWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> createWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getQueues().createWithResponseAsync(this.queueName, null, metadata, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> createIfNotExists() {
        return this.createIfNotExistsWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> createIfNotExistsWithResponse(Map<String, String> metadata) {
        try {
            return this.createIfNotExistsWithResponse(metadata, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> createIfNotExistsWithResponse(Map<String, String> metadata, Context context) {
        try {
            return this.createWithResponse(metadata, context).map(response -> new SimpleResponse(response, (Object)true)).onErrorResume(t -> t instanceof QueueStorageException && ((QueueStorageException)((Object)((Object)t))).getStatusCode() == 409, t -> {
                HttpResponse response = ((QueueStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse() {
        try {
            return FluxUtil.withContext(this::deleteWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getQueues().deleteWithResponseAsync(this.queueName, null, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteIfExists() {
        return this.deleteIfExistsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteIfExistsWithResponse() {
        try {
            return FluxUtil.withContext(this::deleteIfExistsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> deleteIfExistsWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.deleteWithResponse(context).map(response -> new SimpleResponse(response, (Object)true)).onErrorResume(t -> t instanceof QueueStorageException && ((QueueStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
            HttpResponse response = ((QueueStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getQueues().getPropertiesWithResponseAsync(this.queueName, null, null, context).map(response -> new SimpleResponse((Response)response, (Object)ModelHelper.transformQueueProperties((QueuesGetPropertiesHeaders)response.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getQueues().setMetadataWithResponseAsync(this.queueName, null, metadata, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueSignedIdentifier> getAccessPolicy() {
        try {
            Function<String, Mono> retriever = marker -> this.client.getQueues().getAccessPolicyWithResponseAsync(this.queueName, null, null, Context.NONE).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, (Object)((QueuesGetAccessPolicyHeaders)response.getDeserializedHeaders())));
            return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicy(Iterable<QueueSignedIdentifier> permissions) {
        return this.setAccessPolicyWithResponse(permissions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyWithResponse(Iterable<QueueSignedIdentifier> permissions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(permissions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setAccessPolicyWithResponse(Iterable<QueueSignedIdentifier> permissions, Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (permissions != null) {
            for (QueueSignedIdentifier permission : permissions) {
                if (permission.getAccessPolicy() != null && permission.getAccessPolicy().getStartsOn() != null) {
                    permission.getAccessPolicy().setStartsOn(permission.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (permission.getAccessPolicy() == null || permission.getAccessPolicy().getExpiresOn() == null) continue;
                permission.getAccessPolicy().setExpiresOn(permission.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        List<QueueSignedIdentifier> permissionsList = StreamSupport.stream(permissions != null ? permissions.spliterator() : Spliterators.emptySpliterator(), false).collect(Collectors.toList());
        return this.client.getQueues().setAccessPolicyWithResponseAsync(this.queueName, null, null, permissionsList, context).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> clearMessages() {
        return this.clearMessagesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> clearMessagesWithResponse() {
        try {
            return FluxUtil.withContext(this::clearMessagesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> clearMessagesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getMessages().clearWithResponseAsync(this.queueName, null, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendMessageResult> sendMessage(String messageText) {
        return this.sendMessageWithResponse(messageText, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendMessageResult> sendMessage(BinaryData message) {
        return this.sendMessageWithResponse(message, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendMessageResult>> sendMessageWithResponse(String messageText, Duration visibilityTimeout, Duration timeToLive) {
        return this.sendMessageWithResponse(BinaryData.fromString((String)messageText), visibilityTimeout, timeToLive);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendMessageResult>> sendMessageWithResponse(BinaryData message, Duration visibilityTimeout, Duration timeToLive) {
        try {
            return FluxUtil.withContext(context -> this.sendMessageWithResponse(message, visibilityTimeout, timeToLive, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<SendMessageResult>> sendMessageWithResponse(BinaryData message, Duration visibilityTimeout, Duration timeToLive, Context context) {
        Integer visibilityTimeoutInSeconds = visibilityTimeout == null ? null : Integer.valueOf((int)visibilityTimeout.getSeconds());
        Integer timeToLiveInSeconds = timeToLive == null ? null : Integer.valueOf((int)timeToLive.getSeconds());
        Context finalContext = context == null ? Context.NONE : context;
        return Mono.fromCallable(() -> ModelHelper.encodeMessage(message, this.messageEncoding)).flatMap(messageText -> {
            QueueMessage queueMessage = new QueueMessage().setMessageText((String)messageText);
            return this.client.getMessages().enqueueWithResponseAsync(this.queueName, queueMessage, visibilityTimeoutInSeconds, timeToLiveInSeconds, null, null, finalContext).map(response -> new SimpleResponse((Response)response, (Object)((SendMessageResult)((List)response.getValue()).get(0))));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueMessageItem> receiveMessage() {
        try {
            return this.receiveMessagesWithOptionalTimeout(1, null, null, Context.NONE).singleOrEmpty();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueMessageItem> receiveMessages(Integer maxMessages) {
        return this.receiveMessages(maxMessages, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueMessageItem> receiveMessages(Integer maxMessages, Duration visibilityTimeout) {
        try {
            return this.receiveMessagesWithOptionalTimeout(maxMessages, visibilityTimeout, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<QueueMessageItem> receiveMessagesWithOptionalTimeout(Integer maxMessages, Duration visibilityTimeout, Duration timeout, Context context) {
        Integer visibilityTimeoutInSeconds = visibilityTimeout == null ? null : Integer.valueOf((int)visibilityTimeout.getSeconds());
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.client.getMessages().dequeueWithResponseAsync(this.queueName, maxMessages, visibilityTimeoutInSeconds, null, null, context), (Duration)timeout).flatMap(this::transformMessagesDequeueResponse);
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    private Mono<PagedResponseBase<MessagesDequeueHeaders, QueueMessageItem>> transformMessagesDequeueResponse(ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>> response) {
        List queueMessageInternalItems = (List)response.getValue();
        if (queueMessageInternalItems == null) {
            queueMessageInternalItems = Collections.emptyList();
        }
        return Flux.fromIterable(queueMessageInternalItems).flatMapSequential(queueMessageItemInternal -> Mono.fromCallable(() -> ModelHelper.transformQueueMessageItemInternal(queueMessageItemInternal, this.messageEncoding)).onErrorResume(IllegalArgumentException.class, e -> {
            if (this.processMessageDecodingErrorAsyncHandler != null) {
                return Mono.fromCallable(() -> ModelHelper.transformQueueMessageItemInternal(queueMessageItemInternal, QueueMessageEncoding.NONE)).flatMap(messageItem -> this.processMessageDecodingErrorAsyncHandler.apply(new QueueMessageDecodingError(this, this.queueClient, (QueueMessageItem)messageItem, null, (Exception)e))).then(Mono.empty());
            }
            if (this.processMessageDecodingErrorHandler != null) {
                return Mono.fromCallable(() -> ModelHelper.transformQueueMessageItemInternal(queueMessageItemInternal, QueueMessageEncoding.NONE)).flatMap(messageItem -> {
                    try {
                        return Mono.fromRunnable(() -> this.processMessageDecodingErrorHandler.accept(new QueueMessageDecodingError(this, this.queueClient, (QueueMessageItem)messageItem, null, (Exception)e))).subscribeOn(Schedulers.boundedElastic()).then(Mono.empty());
                    }
                    catch (RuntimeException re) {
                        return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)re);
                    }
                }).subscribeOn(Schedulers.boundedElastic());
            }
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        })).collectList().map(queueMessageItems -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), queueMessageItems, null, (Object)((MessagesDequeueHeaders)response.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PeekedMessageItem> peekMessage() {
        return this.peekMessages(null).singleOrEmpty();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PeekedMessageItem> peekMessages(Integer maxMessages) {
        try {
            return this.peekMessagesWithOptionalTimeout(maxMessages, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<PeekedMessageItem> peekMessagesWithOptionalTimeout(Integer maxMessages, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.client.getMessages().peekWithResponseAsync(this.queueName, maxMessages, null, null, context), (Duration)timeout).flatMap(this::transformMessagesPeekResponse);
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    private Mono<PagedResponseBase<MessagesPeekHeaders, PeekedMessageItem>> transformMessagesPeekResponse(ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>> response) {
        List peekedMessageInternalItems = (List)response.getValue();
        if (peekedMessageInternalItems == null) {
            peekedMessageInternalItems = Collections.emptyList();
        }
        return Flux.fromIterable(peekedMessageInternalItems).flatMapSequential(peekedMessageItemInternal -> Mono.fromCallable(() -> ModelHelper.transformPeekedMessageItemInternal(peekedMessageItemInternal, this.messageEncoding)).onErrorResume(IllegalArgumentException.class, e -> {
            if (this.processMessageDecodingErrorAsyncHandler != null) {
                return Mono.fromCallable(() -> ModelHelper.transformPeekedMessageItemInternal(peekedMessageItemInternal, QueueMessageEncoding.NONE)).flatMap(messageItem -> this.processMessageDecodingErrorAsyncHandler.apply(new QueueMessageDecodingError(this, this.queueClient, null, (PeekedMessageItem)messageItem, (Exception)e))).then(Mono.empty());
            }
            if (this.processMessageDecodingErrorHandler != null) {
                return Mono.fromCallable(() -> ModelHelper.transformPeekedMessageItemInternal(peekedMessageItemInternal, QueueMessageEncoding.NONE)).flatMap(messageItem -> {
                    try {
                        return Mono.fromRunnable(() -> this.processMessageDecodingErrorHandler.accept(new QueueMessageDecodingError(this, this.queueClient, null, (PeekedMessageItem)messageItem, (Exception)e))).subscribeOn(Schedulers.boundedElastic()).then(Mono.empty());
                    }
                    catch (RuntimeException re) {
                        return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)re);
                    }
                }).subscribeOn(Schedulers.boundedElastic());
            }
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        })).collectList().map(peekedMessageItems -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), peekedMessageItems, null, (Object)((MessagesPeekHeaders)response.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UpdateMessageResult> updateMessage(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        return this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UpdateMessageResult>> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        try {
            return FluxUtil.withContext(context -> this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<UpdateMessageResult>> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout, Context context) {
        QueueMessage message = messageText == null ? null : new QueueMessage().setMessageText(messageText);
        context = context == null ? Context.NONE : context;
        visibilityTimeout = visibilityTimeout == null ? Duration.ZERO : visibilityTimeout;
        return this.client.getMessageIds().updateWithResponseAsync(this.queueName, messageId, popReceipt, (int)visibilityTimeout.getSeconds(), null, null, message, context).map(response -> {
            UpdateMessageResult result = new UpdateMessageResult(((MessageIdsUpdateHeaders)response.getDeserializedHeaders()).getXMsPopreceipt(), ((MessageIdsUpdateHeaders)response.getDeserializedHeaders()).getXMsTimeNextVisible());
            return new SimpleResponse((Response)response, (Object)result);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMessage(String messageId, String popReceipt) {
        return this.deleteMessageWithResponse(messageId, popReceipt).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMessageWithResponse(String messageId, String popReceipt) {
        try {
            return FluxUtil.withContext(context -> this.deleteMessageWithResponse(messageId, popReceipt, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteMessageWithResponse(String messageId, String popReceipt, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.getMessageIds().deleteWithResponseAsync(this.queueName, messageId, popReceipt, null, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues) {
        return this.generateSas(queueServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues, Context context) {
        return new QueueSasImplUtil(queueServiceSasSignatureValues, this.getQueueName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }

    AzureQueueStorageImpl getAzureQueueStorage() {
        return this.client;
    }
}

