/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

public final class QueuesGetPropertiesHeaders {
    private String xMsVersion;
    private Integer xMsApproximateMessagesCount;
    private Map<String, String> xMsMeta;
    private String xMsRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_APPROXIMATE_MESSAGES_COUNT = HttpHeaderName.fromString((String)"x-ms-approximate-messages-count");

    public QueuesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsApproximateMessagesCount = rawHeaders.getValue(X_MS_APPROXIMATE_MESSAGES_COUNT);
        if (xMsApproximateMessagesCount != null) {
            this.xMsApproximateMessagesCount = Integer.parseInt(xMsApproximateMessagesCount);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        HashMap<String, String> xMsMetaHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public QueuesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Integer getXMsApproximateMessagesCount() {
        return this.xMsApproximateMessagesCount;
    }

    public QueuesGetPropertiesHeaders setXMsApproximateMessagesCount(Integer xMsApproximateMessagesCount) {
        this.xMsApproximateMessagesCount = xMsApproximateMessagesCount;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public QueuesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public QueuesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public QueuesGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

