/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessagesClearHeaders;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesEnqueueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternalWrapper;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternalWrapper;
import com.azure.storage.queue.implementation.models.SendMessageResultWrapper;
import com.azure.storage.queue.models.QueueStorageException;
import reactor.core.publisher.Mono;

public final class MessagesImpl {
    private final MessagesService service;
    private final AzureQueueStorageImpl client;

    MessagesImpl(AzureQueueStorageImpl client) {
        this.service = (MessagesService)RestProxy.create(MessagesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>> dequeueWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.dequeue(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>> dequeueWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.dequeue(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueMessageItemInternalWrapper> dequeueAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        return this.dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((QueueMessageItemInternalWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueMessageItemInternalWrapper> dequeueAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        return this.dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((QueueMessageItemInternalWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueMessageItemInternalWrapper>> dequeueNoCustomHeadersWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.dequeueNoCustomHeaders(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueMessageItemInternalWrapper>> dequeueNoCustomHeadersWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.dequeueNoCustomHeaders(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper> dequeueWithResponse(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.dequeueSync(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueMessageItemInternalWrapper dequeue(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        return (QueueMessageItemInternalWrapper)this.dequeueWithResponse(queueName, numberOfMessages, visibilitytimeout, timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueMessageItemInternalWrapper> dequeueNoCustomHeadersWithResponse(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.dequeueNoCustomHeadersSync(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(String queueName, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.clear(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.clear(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId) {
        return this.clearWithResponseAsync(queueName, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.clearWithResponseAsync(queueName, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> clearNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.clearNoCustomHeaders(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> clearNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.clearNoCustomHeaders(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<MessagesClearHeaders, Void> clearWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.clearSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void clear(String queueName, Integer timeout, String requestId) {
        this.clearWithResponse(queueName, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> clearNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.clearNoCustomHeadersSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper>> enqueueWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.enqueue(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper>> enqueueWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.enqueue(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendMessageResultWrapper> enqueueAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        return this.enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((SendMessageResultWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendMessageResultWrapper> enqueueAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        return this.enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((SendMessageResultWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendMessageResultWrapper>> enqueueNoCustomHeadersWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.enqueueNoCustomHeaders(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendMessageResultWrapper>> enqueueNoCustomHeadersWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.enqueueNoCustomHeaders(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper> enqueueWithResponse(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.enqueueSync(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendMessageResultWrapper enqueue(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        return (SendMessageResultWrapper)this.enqueueWithResponse(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendMessageResultWrapper> enqueueNoCustomHeadersWithResponse(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.enqueueNoCustomHeadersSync(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>> peekWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        String peekonly = "true";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.peek(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>> peekWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        String accept = "application/xml";
        return this.service.peek(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PeekedMessageItemInternalWrapper> peekAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        return this.peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((PeekedMessageItemInternalWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PeekedMessageItemInternalWrapper> peekAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        return this.peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((PeekedMessageItemInternalWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PeekedMessageItemInternalWrapper>> peekNoCustomHeadersWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        String peekonly = "true";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.peekNoCustomHeaders(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PeekedMessageItemInternalWrapper>> peekNoCustomHeadersWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        String accept = "application/xml";
        return this.service.peekNoCustomHeaders(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper> peekWithResponse(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        String accept = "application/xml";
        return this.service.peekSync(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PeekedMessageItemInternalWrapper peek(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        return (PeekedMessageItemInternalWrapper)this.peekWithResponse(queueName, numberOfMessages, timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PeekedMessageItemInternalWrapper> peekNoCustomHeadersWithResponse(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        String accept = "application/xml";
        return this.service.peekNoCustomHeadersSync(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageMes")
    public static interface MessagesService {
        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>> dequeue(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<QueueMessageItemInternalWrapper>> dequeueNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper> dequeueSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<QueueMessageItemInternalWrapper> dequeueNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesClearHeaders, Void>> clear(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<Void>> clearNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<MessagesClearHeaders, Void> clearSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<Void> clearNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper>> enqueue(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="visibilitytimeout") Integer var3, @QueryParam(value="messagettl") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @BodyParam(value="application/xml") QueueMessage var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<SendMessageResultWrapper>> enqueueNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="visibilitytimeout") Integer var3, @QueryParam(value="messagettl") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @BodyParam(value="application/xml") QueueMessage var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper> enqueueSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="visibilitytimeout") Integer var3, @QueryParam(value="messagettl") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @BodyParam(value="application/xml") QueueMessage var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<SendMessageResultWrapper> enqueueNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="visibilitytimeout") Integer var3, @QueryParam(value="messagettl") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @BodyParam(value="application/xml") QueueMessage var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>> peek(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="peekonly") String var3, @QueryParam(value="numofmessages") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<PeekedMessageItemInternalWrapper>> peekNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="peekonly") String var3, @QueryParam(value="numofmessages") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper> peekSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="peekonly") String var3, @QueryParam(value="numofmessages") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<PeekedMessageItemInternalWrapper> peekNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="peekonly") String var3, @QueryParam(value="numofmessages") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

