/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.queue.models.QueueAnalyticsLogging;
import com.azure.storage.queue.models.QueueCorsRule;
import com.azure.storage.queue.models.QueueMetrics;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueServiceProperties
implements XmlSerializable<QueueServiceProperties> {
    private QueueAnalyticsLogging analyticsLogging;
    private QueueMetrics hourMetrics;
    private QueueMetrics minuteMetrics;
    private List<QueueCorsRule> cors;

    public QueueAnalyticsLogging getAnalyticsLogging() {
        return this.analyticsLogging;
    }

    public QueueServiceProperties setAnalyticsLogging(QueueAnalyticsLogging analyticsLogging) {
        this.analyticsLogging = analyticsLogging;
        return this;
    }

    public QueueMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    public QueueServiceProperties setHourMetrics(QueueMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    public QueueMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    public QueueServiceProperties setMinuteMetrics(QueueMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    public List<QueueCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new ArrayList<QueueCorsRule>();
        }
        return this.cors;
    }

    public QueueServiceProperties setCors(List<QueueCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.analyticsLogging, "Logging");
        xmlWriter.writeXml((XmlSerializable)this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml((XmlSerializable)this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (QueueCorsRule element : this.cors) {
                xmlWriter.writeXml((XmlSerializable)element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static QueueServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueServiceProperties.fromXml(xmlReader, null);
    }

    public static QueueServiceProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        return (QueueServiceProperties)xmlReader.readObject(finalRootElementName, reader -> {
            QueueServiceProperties deserializedQueueServiceProperties = new QueueServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Logging".equals(elementName.getLocalPart())) {
                    deserializedQueueServiceProperties.analyticsLogging = QueueAnalyticsLogging.fromXml(reader, "Logging");
                    continue;
                }
                if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedQueueServiceProperties.hourMetrics = QueueMetrics.fromXml(reader, "HourMetrics");
                    continue;
                }
                if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedQueueServiceProperties.minuteMetrics = QueueMetrics.fromXml(reader, "MinuteMetrics");
                    continue;
                }
                if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedQueueServiceProperties.cors == null) {
                                deserializedQueueServiceProperties.cors = new ArrayList<QueueCorsRule>();
                            }
                            deserializedQueueServiceProperties.cors.add(QueueCorsRule.fromXml(reader, "CorsRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueServiceProperties;
        });
    }
}

