// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * An Azure Storage Queue.
 */
@Fluent
public final class QueueItem implements XmlSerializable<QueueItem> {
    /*
     * The name of the Queue.
     */
    private String name;

    /*
     * Dictionary of <string>
     */
    private Map<String, String> metadata;

    /**
     * Creates an instance of QueueItem class.
     */
    public QueueItem() {
    }

    /**
     * Get the name property: The name of the Queue.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the Queue.
     * 
     * @param name the name value to set.
     * @return the QueueItem object itself.
     */
    public QueueItem setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @param metadata the metadata value to set.
     * @return the QueueItem object itself.
     */
    public QueueItem setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Queue" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QueueItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QueueItem if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueItem.
     */
    public static QueueItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QueueItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QueueItem if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueItem.
     */
    public static QueueItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Queue" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueItem deserializedQueueItem = new QueueItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedQueueItem.name = reader.getStringElement();
                } else if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedQueueItem.metadata == null) {
                            deserializedQueueItem.metadata = new LinkedHashMap<>();
                        }
                        deserializedQueueItem.metadata.put(reader.getElementName().getLocalPart(),
                            reader.getStringElement());
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQueueItem;
        });
    }
}
