// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.queue.implementation.models.QueueSignedIdentifierWrapper;
import com.azure.storage.queue.implementation.models.QueueStorageExceptionInternal;
import com.azure.storage.queue.implementation.models.QueuesCreateHeaders;
import com.azure.storage.queue.implementation.models.QueuesDeleteHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.QueuesSetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesSetMetadataHeaders;
import com.azure.storage.queue.implementation.util.ModelHelper;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Queues.
 */
public final class QueuesImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final QueuesService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureQueueStorageImpl client;

    /**
     * Initializes an instance of QueuesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    QueuesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(QueuesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureQueueStorageQueues to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureQueueStorageQue")
    public interface QueuesService {

        @Put("/{queueName}")
        @ExpectedResponses({ 201, 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<QueuesCreateHeaders, Void>> create(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 201, 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<Void>> createNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 201, 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<QueuesCreateHeaders, Void> createSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 201, 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<Void> createNoCustomHeadersSync(@HostParam("url") String url, @PathParam("queueName") String queueName,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<QueuesDeleteHeaders, Void>> delete(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<Void>> deleteNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<QueuesDeleteHeaders, Void> deleteSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<Void> deleteNoCustomHeadersSync(@HostParam("url") String url, @PathParam("queueName") String queueName,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getProperties(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<QueuesGetPropertiesHeaders, Void> getPropertiesSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<Void> getPropertiesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadata(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<QueuesSetMetadataHeaders, Void> setMetadataSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<Void> setMetadataNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>> getAccessPolicy(
            @HostParam("url") String url, @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<QueueSignedIdentifierWrapper>> getAccessPolicyNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper> getAccessPolicySync(
            @HostParam("url") String url, @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<QueueSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueSignedIdentifierWrapper queueAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<Void>> setAccessPolicyNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueSignedIdentifierWrapper queueAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<QueuesSetAccessPolicyHeaders, Void> setAccessPolicySync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueSignedIdentifierWrapper queueAcl, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{queueName}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<Void> setAccessPolicyNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueSignedIdentifierWrapper queueAcl, @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesCreateHeaders, Void>> createWithResponseAsync(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId) {
        return FluxUtil
            .withContext(context -> createWithResponseAsync(queueName, timeout, metadata, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesCreateHeaders, Void>> createWithResponseAsync(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .create(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return createWithResponseAsync(queueName, timeout, metadata, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId,
        Context context) {
        return createWithResponseAsync(queueName, timeout, metadata, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId) {
        return FluxUtil
            .withContext(
                context -> createNoCustomHeadersWithResponseAsync(queueName, timeout, metadata, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .createNoCustomHeaders(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<QueuesCreateHeaders, Void> createWithResponse(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.createSync(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(),
                requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void create(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        createWithResponse(queueName, timeout, metadata, requestId, Context.NONE);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.createNoCustomHeadersSync(this.client.getUrl(), queueName, timeout, metadata,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, Integer timeout,
        String requestId) {
        return FluxUtil.withContext(context -> deleteWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, Integer timeout,
        String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .delete(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, Integer timeout, String requestId) {
        return deleteWithResponseAsync(queueName, timeout, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, Integer timeout, String requestId, Context context) {
        return deleteWithResponseAsync(queueName, timeout, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(context -> deleteNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .deleteNoCustomHeaders(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId,
                accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<QueuesDeleteHeaders, Void> deleteWithResponse(String queueName, Integer timeout,
        String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.deleteSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId,
                accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String queueName, Integer timeout, String requestId) {
        deleteWithResponse(queueName, timeout, requestId, Context.NONE);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId,
        Context context) {
        try {
            final String accept = "application/xml";
            return service.deleteNoCustomHeadersSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(),
                requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String queueName,
        Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> getPropertiesWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String queueName,
        Integer timeout, String requestId, Context context) {
        final String comp = "metadata";
        final String accept = "application/xml";
        return service
            .getProperties(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String queueName, Integer timeout, String requestId) {
        return getPropertiesWithResponseAsync(queueName, timeout, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String queueName, Integer timeout, String requestId, Context context) {
        return getPropertiesWithResponseAsync(queueName, timeout, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(
                context -> getPropertiesNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId, Context context) {
        final String comp = "metadata";
        final String accept = "application/xml";
        return service
            .getPropertiesNoCustomHeaders(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<QueuesGetPropertiesHeaders, Void> getPropertiesWithResponse(String queueName, Integer timeout,
        String requestId, Context context) {
        try {
            final String comp = "metadata";
            final String accept = "application/xml";
            return service.getPropertiesSync(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(),
                requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void getProperties(String queueName, Integer timeout, String requestId) {
        getPropertiesWithResponse(queueName, timeout, requestId, Context.NONE);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the
     * queue as name-values pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId,
        Context context) {
        try {
            final String comp = "metadata";
            final String accept = "application/xml";
            return service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), queueName, comp, timeout,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String queueName,
        Integer timeout, Map<String, String> metadata, String requestId) {
        return FluxUtil
            .withContext(context -> setMetadataWithResponseAsync(queueName, timeout, metadata, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String queueName,
        Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        final String comp = "metadata";
        final String accept = "application/xml";
        return service
            .setMetadata(this.client.getUrl(), queueName, comp, timeout, metadata, this.client.getVersion(), requestId,
                accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String queueName, Integer timeout, Map<String, String> metadata,
        String requestId) {
        return setMetadataWithResponseAsync(queueName, timeout, metadata, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String queueName, Integer timeout, Map<String, String> metadata,
        String requestId, Context context) {
        return setMetadataWithResponseAsync(queueName, timeout, metadata, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId) {
        return FluxUtil.withContext(
            context -> setMetadataNoCustomHeadersWithResponseAsync(queueName, timeout, metadata, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        final String comp = "metadata";
        final String accept = "application/xml";
        return service
            .setMetadataNoCustomHeaders(this.client.getUrl(), queueName, comp, timeout, metadata,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<QueuesSetMetadataHeaders, Void> setMetadataWithResponse(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        try {
            final String comp = "metadata";
            final String accept = "application/xml";
            return service.setMetadataSync(this.client.getUrl(), queueName, comp, timeout, metadata,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setMetadata(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        setMetadataWithResponse(queueName, timeout, metadata, requestId, Context.NONE);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Include this parameter to specify that the queue's metadata be returned as part of the
     * response body. Note that metadata requested with this parameter must be stored in accordance with the naming
     * restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata
     * names must adhere to the naming conventions for C# identifiers.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String queueName, Integer timeout,
        Map<String, String> metadata, String requestId, Context context) {
        try {
            final String comp = "metadata";
            final String accept = "application/xml";
            return service.setMetadataNoCustomHeadersSync(this.client.getUrl(), queueName, comp, timeout, metadata,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>>
        getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> getAccessPolicyWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>>
        getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        final String comp = "acl";
        final String accept = "application/xml";
        return service
            .getAccessPolicy(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(), requestId,
                accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueueSignedIdentifierWrapper> getAccessPolicyAsync(String queueName, Integer timeout,
        String requestId) {
        return getAccessPolicyWithResponseAsync(queueName, timeout, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueueSignedIdentifierWrapper> getAccessPolicyAsync(String queueName, Integer timeout, String requestId,
        Context context) {
        return getAccessPolicyWithResponseAsync(queueName, timeout, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<QueueSignedIdentifierWrapper>>
        getAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(
                context -> getAccessPolicyNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<QueueSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(
        String queueName, Integer timeout, String requestId, Context context) {
        final String comp = "acl";
        final String accept = "application/xml";
        return service
            .getAccessPolicyNoCustomHeaders(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>
        getAccessPolicyWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            final String comp = "acl";
            final String accept = "application/xml";
            return service.getAccessPolicySync(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(),
                requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public QueueSignedIdentifierWrapper getAccessPolicy(String queueName, Integer timeout, String requestId) {
        try {
            return getAccessPolicyWithResponse(queueName, timeout, requestId, Context.NONE).getValue();
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access
     * Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection of signed identifiers along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<QueueSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersWithResponse(String queueName,
        Integer timeout, String requestId, Context context) {
        try {
            final String comp = "acl";
            final String accept = "application/xml";
            return service.getAccessPolicyNoCustomHeadersSync(this.client.getUrl(), queueName, comp, timeout,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String queueName,
        Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        return FluxUtil
            .withContext(context -> setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String queueName,
        Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        final String comp = "acl";
        final String accept = "application/xml";
        QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
        return service
            .setAccessPolicy(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(), requestId,
                queueAclConverted, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String queueName, Integer timeout, String requestId,
        List<QueueSignedIdentifier> queueAcl) {
        return setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String queueName, Integer timeout, String requestId,
        List<QueueSignedIdentifier> queueAcl, Context context) {
        return setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId, List<QueueSignedIdentifier> queueAcl) {
        return FluxUtil
            .withContext(context -> setAccessPolicyNoCustomHeadersWithResponseAsync(queueName, timeout, requestId,
                queueAcl, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        final String comp = "acl";
        final String accept = "application/xml";
        QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
        return service
            .setAccessPolicyNoCustomHeaders(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(),
                requestId, queueAclConverted, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<QueuesSetAccessPolicyHeaders, Void> setAccessPolicyWithResponse(String queueName,
        Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        try {
            final String comp = "acl";
            final String accept = "application/xml";
            QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
            return service.setAccessPolicySync(this.client.getUrl(), queueName, comp, timeout, this.client.getVersion(),
                requestId, queueAclConverted, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setAccessPolicy(String queueName, Integer timeout, String requestId,
        List<QueueSignedIdentifier> queueAcl) {
        setAccessPolicyWithResponse(queueName, timeout, requestId, queueAcl, Context.NONE);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param queueAcl the acls for the queue.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setAccessPolicyNoCustomHeadersWithResponse(String queueName, Integer timeout,
        String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        try {
            final String comp = "acl";
            final String accept = "application/xml";
            QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
            return service.setAccessPolicyNoCustomHeadersSync(this.client.getUrl(), queueName, comp, timeout,
                this.client.getVersion(), requestId, queueAclConverted, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }
}
