// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * signed identifier.
 */
@Fluent
public final class QueueSignedIdentifier implements XmlSerializable<QueueSignedIdentifier> {
    /*
     * a unique id
     */
    private String id;

    /*
     * The access policy
     */
    private QueueAccessPolicy accessPolicy;

    /**
     * Creates an instance of QueueSignedIdentifier class.
     */
    public QueueSignedIdentifier() {
    }

    /**
     * Get the id property: a unique id.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: a unique id.
     * 
     * @param id the id value to set.
     * @return the QueueSignedIdentifier object itself.
     */
    public QueueSignedIdentifier setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the accessPolicy property: The access policy.
     * 
     * @return the accessPolicy value.
     */
    public QueueAccessPolicy getAccessPolicy() {
        return this.accessPolicy;
    }

    /**
     * Set the accessPolicy property: The access policy.
     * 
     * @param accessPolicy the accessPolicy value to set.
     * @return the QueueSignedIdentifier object itself.
     */
    public QueueSignedIdentifier setAccessPolicy(QueueAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifier" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Id", this.id);
        xmlWriter.writeXml(this.accessPolicy, "AccessPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QueueSignedIdentifier from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QueueSignedIdentifier if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueSignedIdentifier.
     */
    public static QueueSignedIdentifier fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QueueSignedIdentifier from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QueueSignedIdentifier if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueSignedIdentifier.
     */
    public static QueueSignedIdentifier fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifier" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueSignedIdentifier deserializedQueueSignedIdentifier = new QueueSignedIdentifier();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Id".equals(elementName.getLocalPart())) {
                    deserializedQueueSignedIdentifier.id = reader.getStringElement();
                } else if ("AccessPolicy".equals(elementName.getLocalPart())) {
                    deserializedQueueSignedIdentifier.accessPolicy = QueueAccessPolicy.fromXml(reader, "AccessPolicy");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQueueSignedIdentifier;
        });
    }
}
