// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.queue.implementation.models.MessagesClearHeaders;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesEnqueueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternalWrapper;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternalWrapper;
import com.azure.storage.queue.implementation.models.QueueStorageExceptionInternal;
import com.azure.storage.queue.implementation.models.SendMessageResultWrapper;
import com.azure.storage.queue.implementation.util.ModelHelper;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Messages.
 */
public final class MessagesImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final MessagesService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureQueueStorageImpl client;

    /**
     * Initializes an instance of MessagesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    MessagesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(MessagesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureQueueStorageMessages to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureQueueStorageMessages")
    public interface MessagesService {

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>> dequeue(
            @HostParam("url") String url, @PathParam("queueName") String queueName,
            @QueryParam("numofmessages") Integer numberOfMessages,
            @QueryParam("visibilitytimeout") Integer visibilitytimeout, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<QueueMessageItemInternalWrapper>> dequeueNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("numofmessages") Integer numberOfMessages,
            @QueryParam("visibilitytimeout") Integer visibilitytimeout, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper> dequeueSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("numofmessages") Integer numberOfMessages,
            @QueryParam("visibilitytimeout") Integer visibilitytimeout, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<QueueMessageItemInternalWrapper> dequeueNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("numofmessages") Integer numberOfMessages,
            @QueryParam("visibilitytimeout") Integer visibilitytimeout, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}/messages")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<MessagesClearHeaders, Void>> clear(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}/messages")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<Void>> clearNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}/messages")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<MessagesClearHeaders, Void> clearSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{queueName}/messages")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<Void> clearNoCustomHeadersSync(@HostParam("url") String url, @PathParam("queueName") String queueName,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/{queueName}/messages")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper>> enqueue(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("visibilitytimeout") Integer visibilitytimeout,
            @QueryParam("messagettl") Integer messageTimeToLive, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueMessage queueMessage, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/{queueName}/messages")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<SendMessageResultWrapper>> enqueueNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("visibilitytimeout") Integer visibilitytimeout,
            @QueryParam("messagettl") Integer messageTimeToLive, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueMessage queueMessage, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/{queueName}/messages")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper> enqueueSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("visibilitytimeout") Integer visibilitytimeout,
            @QueryParam("messagettl") Integer messageTimeToLive, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueMessage queueMessage, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/{queueName}/messages")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<SendMessageResultWrapper> enqueueNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("visibilitytimeout") Integer visibilitytimeout,
            @QueryParam("messagettl") Integer messageTimeToLive, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") QueueMessage queueMessage, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>> peek(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("peekonly") String peekonly,
            @QueryParam("numofmessages") Integer numberOfMessages, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Mono<Response<PeekedMessageItemInternalWrapper>> peekNoCustomHeaders(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("peekonly") String peekonly,
            @QueryParam("numofmessages") Integer numberOfMessages, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper> peekSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("peekonly") String peekonly,
            @QueryParam("numofmessages") Integer numberOfMessages, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{queueName}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(QueueStorageExceptionInternal.class)
        Response<PeekedMessageItemInternalWrapper> peekNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("queueName") String queueName, @QueryParam("peekonly") String peekonly,
            @QueryParam("numofmessages") Integer numberOfMessages, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>> dequeueWithResponseAsync(
        String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout,
                requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>> dequeueWithResponseAsync(
        String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId,
        Context context) {
        final String accept = "application/xml";
        return service
            .dequeue(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueueMessageItemInternalWrapper> dequeueAsync(String queueName, Integer numberOfMessages,
        Integer visibilitytimeout, Integer timeout, String requestId) {
        return dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<QueueMessageItemInternalWrapper> dequeueAsync(String queueName, Integer numberOfMessages,
        Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        return dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<QueueMessageItemInternalWrapper>> dequeueNoCustomHeadersWithResponseAsync(String queueName,
        Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> dequeueNoCustomHeadersWithResponseAsync(queueName, numberOfMessages,
                visibilitytimeout, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<QueueMessageItemInternalWrapper>> dequeueNoCustomHeadersWithResponseAsync(String queueName,
        Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .dequeueNoCustomHeaders(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper> dequeueWithResponse(String queueName,
        Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.dequeueSync(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public QueueMessageItemInternalWrapper dequeue(String queueName, Integer numberOfMessages,
        Integer visibilitytimeout, Integer timeout, String requestId) {
        try {
            return dequeueWithResponse(queueName, numberOfMessages, visibilitytimeout, timeout, requestId, Context.NONE)
                .getValue();
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param visibilitytimeout Optional. Specifies the new visibility timeout value, in seconds, relative to server
     * time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be
     * larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility
     * timeout of a message can be set to a value later than the expiry time.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Get Messages on a Queue along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<QueueMessageItemInternalWrapper> dequeueNoCustomHeadersWithResponse(String queueName,
        Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.dequeueNoCustomHeadersSync(this.client.getUrl(), queueName, numberOfMessages,
                visibilitytimeout, timeout, this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(String queueName, Integer timeout,
        String requestId) {
        return FluxUtil.withContext(context -> clearWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(String queueName, Integer timeout,
        String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .clear(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId) {
        return clearWithResponseAsync(queueName, timeout, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId, Context context) {
        return clearWithResponseAsync(queueName, timeout, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> clearNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(context -> clearNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> clearNoCustomHeadersWithResponseAsync(String queueName, Integer timeout,
        String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .clearNoCustomHeaders(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<MessagesClearHeaders, Void> clearWithResponse(String queueName, Integer timeout,
        String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.clearSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId,
                accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void clear(String queueName, Integer timeout, String requestId) {
        clearWithResponse(queueName, timeout, requestId, Context.NONE);
    }

    /**
     * The Clear operation deletes all messages from the specified queue.
     *
     * @param queueName The queue name.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> clearNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId,
        Context context) {
        try {
            final String accept = "application/xml";
            return service.clearNoCustomHeadersSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(),
                requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper>> enqueueWithResponseAsync(
        String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive,
        Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout,
                messageTimeToLive, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper>> enqueueWithResponseAsync(
        String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive,
        Integer timeout, String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .enqueue(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout,
                this.client.getVersion(), requestId, queueMessage, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SendMessageResultWrapper> enqueueAsync(String queueName, QueueMessage queueMessage,
        Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        return enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout,
            requestId).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SendMessageResultWrapper> enqueueAsync(String queueName, QueueMessage queueMessage,
        Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        return enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout,
            requestId, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SendMessageResultWrapper>> enqueueNoCustomHeadersWithResponseAsync(String queueName,
        QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(context -> enqueueNoCustomHeadersWithResponseAsync(queueName, queueMessage, visibilitytimeout,
                messageTimeToLive, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SendMessageResultWrapper>> enqueueNoCustomHeadersWithResponseAsync(String queueName,
        QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout,
        String requestId, Context context) {
        final String accept = "application/xml";
        return service
            .enqueueNoCustomHeaders(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout,
                this.client.getVersion(), requestId, queueMessage, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<MessagesEnqueueHeaders, SendMessageResultWrapper> enqueueWithResponse(String queueName,
        QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout,
        String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.enqueueSync(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout,
                this.client.getVersion(), requestId, queueMessage, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SendMessageResultWrapper enqueue(String queueName, QueueMessage queueMessage, Integer visibilitytimeout,
        Integer messageTimeToLive, Integer timeout, String requestId) {
        try {
            return enqueueWithResponse(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout,
                requestId, Context.NONE).getValue();
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
     * specified to make the message invisible until the visibility timeout expires. A message must be in a format that
     * can be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for
     * versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     *
     * @param queueName The queue name.
     * @param queueMessage A Message object which can be stored in a Queue.
     * @param visibilitytimeout Optional. If specified, the request must be made using an x-ms-version of 2011-08-18 or
     * later. If not specified, the default value is 0. Specifies the new visibility timeout value, in seconds, relative
     * to server time. The new value must be larger than or equal to 0, and cannot be larger than 7 days. The visibility
     * timeout of a message cannot be set to a value later than the expiry time. visibilitytimeout should be set to a
     * value smaller than the time-to-live value.
     * @param messageTimeToLive Optional. Specifies the time-to-live interval for the message, in seconds. Prior to
     * version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
     * time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
     * parameter is omitted, the default time-to-live is 7 days.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Put Message on a Queue along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SendMessageResultWrapper> enqueueNoCustomHeadersWithResponse(String queueName,
        QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout,
        String requestId, Context context) {
        try {
            final String accept = "application/xml";
            return service.enqueueNoCustomHeadersSync(this.client.getUrl(), queueName, visibilitytimeout,
                messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>>
        peekWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link ResponseBase} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>> peekWithResponseAsync(
        String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        final String peekonly = "true";
        final String accept = "application/xml";
        return service
            .peek(this.client.getUrl(), queueName, peekonly, numberOfMessages, timeout, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PeekedMessageItemInternalWrapper> peekAsync(String queueName, Integer numberOfMessages, Integer timeout,
        String requestId) {
        return peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PeekedMessageItemInternalWrapper> peekAsync(String queueName, Integer numberOfMessages, Integer timeout,
        String requestId, Context context) {
        return peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PeekedMessageItemInternalWrapper>> peekNoCustomHeadersWithResponseAsync(String queueName,
        Integer numberOfMessages, Integer timeout, String requestId) {
        return FluxUtil.withContext(
            context -> peekNoCustomHeadersWithResponseAsync(queueName, numberOfMessages, timeout, requestId, context))
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PeekedMessageItemInternalWrapper>> peekNoCustomHeadersWithResponseAsync(String queueName,
        Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        final String peekonly = "true";
        final String accept = "application/xml";
        return service
            .peekNoCustomHeaders(this.client.getUrl(), queueName, peekonly, numberOfMessages, timeout,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper> peekWithResponse(String queueName,
        Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        try {
            final String peekonly = "true";
            final String accept = "application/xml";
            return service.peekSync(this.client.getUrl(), queueName, peekonly, numberOfMessages, timeout,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PeekedMessageItemInternalWrapper peek(String queueName, Integer numberOfMessages, Integer timeout,
        String requestId) {
        try {
            return peekWithResponse(queueName, numberOfMessages, timeout, requestId, Context.NONE).getValue();
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter the visibility
     * of the message.
     *
     * @param queueName The queue name.
     * @param numberOfMessages Optional. A nonzero integer value that specifies the number of messages to retrieve from
     * the queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single
     * message is retrieved from the queue with this operation.
     * @param timeout The The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting
     * Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws QueueStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the object returned when calling Peek Messages on a Queue along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PeekedMessageItemInternalWrapper> peekNoCustomHeadersWithResponse(String queueName,
        Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        try {
            final String peekonly = "true";
            final String accept = "application/xml";
            return service.peekNoCustomHeadersSync(this.client.getUrl(), queueName, peekonly, numberOfMessages, timeout,
                this.client.getVersion(), requestId, accept, context);
        } catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }
}
