// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A wrapper around List&lt;QueueMessageItemInternal&gt; which provides top-level metadata for serialization.
 */
public final class QueueMessageItemInternalWrapper implements XmlSerializable<QueueMessageItemInternalWrapper> {
    private final List<QueueMessageItemInternal> queueMessagesList;

    /**
     * Creates an instance of QueueMessageItemInternalWrapper.
     * 
     * @param queueMessagesList the list.
     */
    public QueueMessageItemInternalWrapper(List<QueueMessageItemInternal> queueMessagesList) {
        this.queueMessagesList = queueMessagesList;
    }

    /**
     * Get the List&lt;QueueMessageItemInternal&gt; contained in this wrapper.
     * 
     * @return the List&lt;QueueMessageItemInternal&gt;.
     */
    public List<QueueMessageItemInternal> items() {
        return queueMessagesList;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueMessagesList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (queueMessagesList != null) {
            for (QueueMessageItemInternal element : queueMessagesList) {
                xmlWriter.writeXml(element, "QueueMessage");
            }
        }
        return xmlWriter.writeEndElement();
    }

    @Generated
    public static QueueMessageItemInternalWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    @Generated
    public static QueueMessageItemInternalWrapper fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueMessagesList" : rootElementName;
        return xmlReader.readObject(rootElementName, reader -> {
            List<QueueMessageItemInternal> items = null;

            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("QueueMessage".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<>();
                    }

                    items.add(QueueMessageItemInternal.fromXml(reader));
                } else {
                    reader.nextElement();
                }
            }
            return new QueueMessageItemInternalWrapper(items);
        });
    }
}
