// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Storage Service Properties.
 */
@Fluent
public final class QueueServiceProperties implements XmlSerializable<QueueServiceProperties> {
    /*
     * Azure Analytics Logging settings
     */
    @Generated
    private QueueAnalyticsLogging analyticsLogging;

    /*
     * A summary of request statistics grouped by API in hourly aggregates for queues
     */
    @Generated
    private QueueMetrics hourMetrics;

    /*
     * a summary of request statistics grouped by API in minute aggregates for queues
     */
    @Generated
    private QueueMetrics minuteMetrics;

    /*
     * The set of CORS rules.
     */
    @Generated
    private List<QueueCorsRule> cors;

    /**
     * Creates an instance of QueueServiceProperties class.
     */
    @Generated
    public QueueServiceProperties() {
    }

    /**
     * Get the analyticsLogging property: Azure Analytics Logging settings.
     * 
     * @return the analyticsLogging value.
     */
    @Generated
    public QueueAnalyticsLogging getAnalyticsLogging() {
        return this.analyticsLogging;
    }

    /**
     * Set the analyticsLogging property: Azure Analytics Logging settings.
     * 
     * @param analyticsLogging the analyticsLogging value to set.
     * @return the QueueServiceProperties object itself.
     */
    @Generated
    public QueueServiceProperties setAnalyticsLogging(QueueAnalyticsLogging analyticsLogging) {
        this.analyticsLogging = analyticsLogging;
        return this;
    }

    /**
     * Get the hourMetrics property: A summary of request statistics grouped by API in hourly aggregates for queues.
     * 
     * @return the hourMetrics value.
     */
    @Generated
    public QueueMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    /**
     * Set the hourMetrics property: A summary of request statistics grouped by API in hourly aggregates for queues.
     * 
     * @param hourMetrics the hourMetrics value to set.
     * @return the QueueServiceProperties object itself.
     */
    @Generated
    public QueueServiceProperties setHourMetrics(QueueMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    /**
     * Get the minuteMetrics property: a summary of request statistics grouped by API in minute aggregates for queues.
     * 
     * @return the minuteMetrics value.
     */
    @Generated
    public QueueMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    /**
     * Set the minuteMetrics property: a summary of request statistics grouped by API in minute aggregates for queues.
     * 
     * @param minuteMetrics the minuteMetrics value to set.
     * @return the QueueServiceProperties object itself.
     */
    @Generated
    public QueueServiceProperties setMinuteMetrics(QueueMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    /**
     * Get the cors property: The set of CORS rules.
     * 
     * @return the cors value.
     */
    @Generated
    public List<QueueCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new ArrayList<>();
        }
        return this.cors;
    }

    /**
     * Set the cors property: The set of CORS rules.
     * 
     * @param cors the cors value to set.
     * @return the QueueServiceProperties object itself.
     */
    @Generated
    public QueueServiceProperties setCors(List<QueueCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.analyticsLogging, "Logging");
        xmlWriter.writeXml(this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml(this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (QueueCorsRule element : this.cors) {
                xmlWriter.writeXml(element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QueueServiceProperties from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QueueServiceProperties if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueServiceProperties.
     */
    @Generated
    public static QueueServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QueueServiceProperties from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QueueServiceProperties if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueServiceProperties.
     */
    @Generated
    public static QueueServiceProperties fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "StorageServiceProperties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueServiceProperties deserializedQueueServiceProperties = new QueueServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Logging".equals(elementName.getLocalPart())) {
                    deserializedQueueServiceProperties.analyticsLogging
                        = QueueAnalyticsLogging.fromXml(reader, "Logging");
                } else if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedQueueServiceProperties.hourMetrics = QueueMetrics.fromXml(reader, "HourMetrics");
                } else if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedQueueServiceProperties.minuteMetrics = QueueMetrics.fromXml(reader, "MinuteMetrics");
                } else if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedQueueServiceProperties.cors == null) {
                                deserializedQueueServiceProperties.cors = new ArrayList<>();
                            }
                            deserializedQueueServiceProperties.cors.add(QueueCorsRule.fromXml(reader, "CorsRule"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQueueServiceProperties;
        });
    }
}
