// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Storage Service Properties.
 */
@JacksonXmlRootElement(localName = "StorageServiceProperties")
@Fluent
public final class QueueServiceProperties {
    /*
     * Azure Analytics Logging settings
     */
    @JsonProperty(value = "Logging")
    private QueueAnalyticsLogging analyticsLogging;

    /*
     * A summary of request statistics grouped by API in hourly aggregates for
     * queues
     */
    @JsonProperty(value = "HourMetrics")
    private QueueMetrics hourMetrics;

    /*
     * a summary of request statistics grouped by API in minute aggregates for
     * queues
     */
    @JsonProperty(value = "MinuteMetrics")
    private QueueMetrics minuteMetrics;

    private static final class CorsWrapper {
        @JacksonXmlProperty(localName = "CorsRule")
        private final List<QueueCorsRule> items;

        @JsonCreator
        private CorsWrapper(@JacksonXmlProperty(localName = "CorsRule") List<QueueCorsRule> items) {
            this.items = items;
        }
    }

    /*
     * The set of CORS rules.
     */
    @JsonProperty(value = "Cors")
    private CorsWrapper cors;

    /**
     * Get the analyticsLogging property: Azure Analytics Logging settings.
     *
     * @return the analyticsLogging value.
     */
    public QueueAnalyticsLogging getAnalyticsLogging() {
        return this.analyticsLogging;
    }

    /**
     * Set the analyticsLogging property: Azure Analytics Logging settings.
     *
     * @param analyticsLogging the analyticsLogging value to set.
     * @return the QueueServiceProperties object itself.
     */
    public QueueServiceProperties setAnalyticsLogging(QueueAnalyticsLogging analyticsLogging) {
        this.analyticsLogging = analyticsLogging;
        return this;
    }

    /**
     * Get the hourMetrics property: A summary of request statistics grouped by
     * API in hourly aggregates for queues.
     *
     * @return the hourMetrics value.
     */
    public QueueMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    /**
     * Set the hourMetrics property: A summary of request statistics grouped by
     * API in hourly aggregates for queues.
     *
     * @param hourMetrics the hourMetrics value to set.
     * @return the QueueServiceProperties object itself.
     */
    public QueueServiceProperties setHourMetrics(QueueMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    /**
     * Get the minuteMetrics property: a summary of request statistics grouped
     * by API in minute aggregates for queues.
     *
     * @return the minuteMetrics value.
     */
    public QueueMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    /**
     * Set the minuteMetrics property: a summary of request statistics grouped
     * by API in minute aggregates for queues.
     *
     * @param minuteMetrics the minuteMetrics value to set.
     * @return the QueueServiceProperties object itself.
     */
    public QueueServiceProperties setMinuteMetrics(QueueMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    /**
     * Get the cors property: The set of CORS rules.
     *
     * @return the cors value.
     */
    public List<QueueCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new CorsWrapper(new ArrayList<QueueCorsRule>());
        }
        return this.cors.items;
    }

    /**
     * Set the cors property: The set of CORS rules.
     *
     * @param cors the cors value to set.
     * @return the QueueServiceProperties object itself.
     */
    public QueueServiceProperties setCors(List<QueueCorsRule> cors) {
        this.cors = new CorsWrapper(cors);
        return this;
    }
}
