/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;

@ServiceClientBuilder(serviceClients={AzureQueueStorageImpl.class})
public final class AzureQueueStorageBuilder {
    private String url;
    private String version;
    private HttpPipeline pipeline;

    public AzureQueueStorageBuilder url(String url) {
        this.url = url;
        return this;
    }

    public AzureQueueStorageBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AzureQueueStorageBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureQueueStorageImpl build() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        AzureQueueStorageImpl client = new AzureQueueStorageImpl(this.pipeline);
        if (this.url != null) {
            client.setUrl(this.url);
        }
        if (this.version != null) {
            client.setVersion(this.version);
        } else {
            client.setVersion("2018-03-28");
        }
        return client;
    }
}

