/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessageIdUpdateHeaders;
import com.azure.storage.queue.implementation.models.MessageIdsUpdateResponse;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.QueueGetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueueGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesResponse;
import com.azure.storage.queue.implementation.util.QueueSasImplUtil;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueProperties;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import com.azure.storage.queue.sas.QueueServiceSasSignatureValues;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Mono;

public final class QueueAsyncClient {
    private final ClientLogger logger = new ClientLogger(QueueAsyncClient.class);
    private final AzureQueueStorageImpl client;
    private final String queueName;
    private final String accountName;
    private final QueueServiceVersion serviceVersion;

    QueueAsyncClient(AzureQueueStorageImpl client, String queueName, String accountName, QueueServiceVersion serviceVersion) {
        Objects.requireNonNull(queueName, "'queueName' cannot be null.");
        this.queueName = queueName;
        this.client = client;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
    }

    public String getQueueUrl() {
        return String.format("%s/%s", this.client.getUrl(), this.queueName);
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public Mono<Void> create() {
        try {
            return this.createWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> createWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.queues().createWithRestResponseAsync(this.queueName, null, metadata, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse() {
        try {
            return FluxUtil.withContext(this::deleteWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.queues().deleteWithRestResponseAsync(this.queueName, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<QueueProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<QueueProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.queues().getPropertiesWithRestResponseAsync(this.queueName, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::getQueuePropertiesResponse);
    }

    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.queues().setMetadataWithRestResponseAsync(this.queueName, null, metadata, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public PagedFlux<QueueSignedIdentifier> getAccessPolicy() {
        try {
            Function<String, Mono> retriever = marker -> this.client.queues().getAccessPolicyWithRestResponseAsync(this.queueName, Context.NONE).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, (Object)((QueueGetAccessPolicyHeaders)response.getDeserializedHeaders())));
            return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> setAccessPolicy(Iterable<QueueSignedIdentifier> permissions) {
        try {
            return this.setAccessPolicyWithResponse(permissions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setAccessPolicyWithResponse(Iterable<QueueSignedIdentifier> permissions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(permissions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setAccessPolicyWithResponse(Iterable<QueueSignedIdentifier> permissions, Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (permissions != null) {
            for (QueueSignedIdentifier permission : permissions) {
                if (permission.getAccessPolicy() != null && permission.getAccessPolicy().getStartsOn() != null) {
                    permission.getAccessPolicy().setStartsOn(permission.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (permission.getAccessPolicy() == null || permission.getAccessPolicy().getExpiresOn() == null) continue;
                permission.getAccessPolicy().setExpiresOn(permission.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        List<QueueSignedIdentifier> permissionsList = StreamSupport.stream(permissions != null ? permissions.spliterator() : Spliterators.emptySpliterator(), false).collect(Collectors.toList());
        return this.client.queues().setAccessPolicyWithRestResponseAsync(this.queueName, permissionsList, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> clearMessages() {
        try {
            return this.clearMessagesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> clearMessagesWithResponse() {
        try {
            return FluxUtil.withContext(this::clearMessagesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> clearMessagesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.messages().clearWithRestResponseAsync(this.queueName, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<SendMessageResult> sendMessage(String messageText) {
        try {
            return this.sendMessageWithResponse(messageText, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<SendMessageResult>> sendMessageWithResponse(String messageText, Duration visibilityTimeout, Duration timeToLive) {
        try {
            return FluxUtil.withContext(context -> this.sendMessageWithResponse(messageText, visibilityTimeout, timeToLive, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<SendMessageResult>> sendMessageWithResponse(String messageText, Duration visibilityTimeout, Duration timeToLive, Context context) {
        Integer visibilityTimeoutInSeconds = visibilityTimeout == null ? null : Integer.valueOf((int)visibilityTimeout.getSeconds());
        Integer timeToLiveInSeconds = timeToLive == null ? null : Integer.valueOf((int)timeToLive.getSeconds());
        QueueMessage message = new QueueMessage().setMessageText(messageText);
        context = context == null ? Context.NONE : context;
        return this.client.messages().enqueueWithRestResponseAsync(this.queueName, message, visibilityTimeoutInSeconds, timeToLiveInSeconds, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)((SendMessageResult)response.getValue().get(0))));
    }

    public Mono<QueueMessageItem> receiveMessage() {
        try {
            return this.receiveMessagesWithOptionalTimeout(1, null, null, Context.NONE).singleOrEmpty();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<QueueMessageItem> receiveMessages(Integer maxMessages) {
        try {
            return this.receiveMessagesWithOptionalTimeout(maxMessages, null, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<QueueMessageItem> receiveMessages(Integer maxMessages, Duration visibilityTimeout) {
        try {
            return this.receiveMessagesWithOptionalTimeout(maxMessages, visibilityTimeout, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<QueueMessageItem> receiveMessagesWithOptionalTimeout(Integer maxMessages, Duration visibilityTimeout, Duration timeout, Context context) {
        Integer visibilityTimeoutInSeconds = visibilityTimeout == null ? null : Integer.valueOf((int)visibilityTimeout.getSeconds());
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.client.messages().dequeueWithRestResponseAsync(this.queueName, maxMessages, visibilityTimeoutInSeconds, null, null, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, (Object)((MessagesDequeueHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public Mono<PeekedMessageItem> peekMessage() {
        try {
            return this.peekMessages(null).singleOrEmpty();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<PeekedMessageItem> peekMessages(Integer maxMessages) {
        try {
            return this.peekMessagesWithOptionalTimeout(maxMessages, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<PeekedMessageItem> peekMessagesWithOptionalTimeout(Integer maxMessages, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.client.messages().peekWithRestResponseAsync(this.queueName, maxMessages, null, null, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, (Object)((MessagesPeekHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    public Mono<UpdateMessageResult> updateMessage(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        try {
            return this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<UpdateMessageResult>> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        try {
            return FluxUtil.withContext(context -> this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<UpdateMessageResult>> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout, Context context) {
        QueueMessage message = messageText == null ? null : new QueueMessage().setMessageText(messageText);
        context = context == null ? Context.NONE : context;
        visibilityTimeout = visibilityTimeout == null ? Duration.ZERO : visibilityTimeout;
        return this.client.messageIds().updateWithRestResponseAsync(this.queueName, messageId, popReceipt, (int)visibilityTimeout.getSeconds(), message, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::getUpdatedMessageResponse);
    }

    public Mono<Void> deleteMessage(String messageId, String popReceipt) {
        try {
            return this.deleteMessageWithResponse(messageId, popReceipt).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteMessageWithResponse(String messageId, String popReceipt) {
        try {
            return FluxUtil.withContext(context -> this.deleteMessageWithResponse(messageId, popReceipt, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteMessageWithResponse(String messageId, String popReceipt, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.messageIds().deleteWithRestResponseAsync(this.queueName, messageId, popReceipt, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues) {
        return new QueueSasImplUtil(queueServiceSasSignatureValues, this.getQueueName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }

    private Response<QueueProperties> getQueuePropertiesResponse(QueuesGetPropertiesResponse response) {
        QueueGetPropertiesHeaders propertiesHeaders = (QueueGetPropertiesHeaders)response.getDeserializedHeaders();
        QueueProperties properties = new QueueProperties(propertiesHeaders.getMetadata(), propertiesHeaders.getApproximateMessagesCount());
        return new SimpleResponse((Response)response, (Object)properties);
    }

    private Response<UpdateMessageResult> getUpdatedMessageResponse(MessageIdsUpdateResponse response) {
        MessageIdUpdateHeaders headers = (MessageIdUpdateHeaders)response.getDeserializedHeaders();
        UpdateMessageResult updateMessageResult = new UpdateMessageResult(headers.getPopReceipt(), headers.getTimeNextVisible());
        return new SimpleResponse((Response)response, (Object)updateMessageResult);
    }
}

