/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueProperties;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import com.azure.storage.queue.sas.QueueServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class QueueClient {
    private final QueueAsyncClient client;

    QueueClient(QueueAsyncClient client) {
        this.client = client;
    }

    public String getQueueUrl() {
        return this.client.getQueueUrl();
    }

    public QueueServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public void create() {
        this.createWithResponse(null, null, Context.NONE);
    }

    public Response<Void> createWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.createWithResponse(metadata, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public QueueProperties getProperties() {
        return (QueueProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    public Response<QueueProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Mono<Response<QueueProperties>> response = this.client.getPropertiesWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, Context.NONE);
    }

    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setMetadataWithResponse(metadata, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PagedIterable<QueueSignedIdentifier> getAccessPolicy() {
        return new PagedIterable(this.client.getAccessPolicy());
    }

    public void setAccessPolicy(List<QueueSignedIdentifier> permissions) {
        this.setAccessPolicyWithResponse(permissions, null, Context.NONE);
    }

    public Response<Void> setAccessPolicyWithResponse(List<QueueSignedIdentifier> permissions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setAccessPolicyWithResponse(permissions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void clearMessages() {
        this.clearMessagesWithResponse(null, Context.NONE);
    }

    public Response<Void> clearMessagesWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.clearMessagesWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public SendMessageResult sendMessage(String messageText) {
        return (SendMessageResult)this.sendMessageWithResponse(messageText, null, null, null, Context.NONE).getValue();
    }

    public Response<SendMessageResult> sendMessageWithResponse(String messageText, Duration visibilityTimeout, Duration timeToLive, Duration timeout, Context context) {
        Mono<Response<SendMessageResult>> response = this.client.sendMessageWithResponse(messageText, visibilityTimeout, timeToLive, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public QueueMessageItem receiveMessage() {
        return (QueueMessageItem)this.client.receiveMessage().block();
    }

    public PagedIterable<QueueMessageItem> receiveMessages(Integer maxMessages) {
        return this.receiveMessages(maxMessages, Duration.ofSeconds(30L), null, Context.NONE);
    }

    public PagedIterable<QueueMessageItem> receiveMessages(Integer maxMessages, Duration visibilityTimeout, Duration timeout, Context context) {
        return new PagedIterable(this.client.receiveMessagesWithOptionalTimeout(maxMessages, visibilityTimeout, timeout, context));
    }

    public PeekedMessageItem peekMessage() {
        return (PeekedMessageItem)this.client.peekMessage().block();
    }

    public PagedIterable<PeekedMessageItem> peekMessages(Integer maxMessages, Duration timeout, Context context) {
        return new PagedIterable(this.client.peekMessagesWithOptionalTimeout(maxMessages, timeout, context));
    }

    public UpdateMessageResult updateMessage(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        return (UpdateMessageResult)this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, null, Context.NONE).getValue();
    }

    public Response<UpdateMessageResult> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout, Duration timeout, Context context) {
        Mono<Response<UpdateMessageResult>> response = this.client.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void deleteMessage(String messageId, String popReceipt) {
        this.deleteMessageWithResponse(messageId, popReceipt, null, Context.NONE);
    }

    public Response<Void> deleteMessageWithResponse(String messageId, String popReceipt, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteMessageWithResponse(messageId, popReceipt, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String getQueueName() {
        return this.client.getQueueName();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues) {
        return this.client.generateSas(queueServiceSasSignatureValues);
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues, Context context) {
        return this.client.generateSas(queueServiceSasSignatureValues, context);
    }
}

